.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoPopAtts 3D  "Dore"
.SH NAME
DoPopAtts \- Create an organizational object that pops all attributes 
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoPopAtts()
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOPPA()
.in -.5i
.fi
.SH DESCRIPTION
.IX DOPPA
.IX DoPopAtts
\f2DoPopAtts\fP creates an organizational object that pops all attributes.
This object restores the local attribute environment
that was saved with \f2DoPushAtts\fP <\f2DOPUA\fP>.
See \f2DoPushAtts\fP for details on using these functions.
.SH ERRORS
\f2DoPopAtts\fP will generate a warning if it is invoked
in a group without a corresponding \f2DoPushAtts\fP <\f2DOPUA\fP>.
.PP
This warning is only generated during traversal of the database,
not during creation of the object. 
For example, the warning will occur when you update
or otherwise traverse the database,
but will not occur when you execute
the initial code that creates the object.
.TP 15
[WARNING - cannot pop stack]
.SH "SEE ALSO"
.na
.nh
DoGroup(3D), DoInLineGroup(3D), DoPopMatrix(3D), DoPushAtts(3D),
DoPushMatrix(3D)
.ad
.hy
