.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoLightColor 3D  "Dore"
.SH NAME
DoLightColor \- Create a light color studio attribute object
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoLightColor(colormodel, color)
DtColorModel colormodel;
DtReal color[\|];
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOLC(COLMOD, COLOR)
INTEGER*4 COLMOD
REAL*8 COLOR(*)
.in -.5i
.fi
.SH DESCRIPTION
.IX DOLC
.IX DoLightColor
.I DoLightColor
creates a light color studio attribute object.
The parameter \f2colormodel\fP specifies the color model used.
The parameter \f2color\fP specifies the color, 
in the designated color model,
of subsequent light objects.
.PP
When \f2colormodel\fP is RGB, \f2color\fP
is an array of three components, with the
value of each component between 0.0 and 1.0.
.PP
The light color attribute controls only the chromatic
composition of the light emitted by a light source; the
intensity of the light source is determined by the light intensity
attribute.
.SH DEFAULTS
The default \f2DoLightColor\fP is (\f2DcRGB\fP, (1.0, 1.0, 1.0)),
a white light.
.SH "SEE ALSO"
DoLight(3D), DoLightIntens(3D)
