.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoLightAttenuation 3D "Dore"
.SH NAME
DoLightAttenuation \- Create a light attribute object defining light intensity falloff with distance
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoLightAttenuation(c1, c2)
DtReal c1;
DtReal c2;
.sp
.in  -.5i
FORTRAN:
.in  +.5i
INTEGER*4 DOLTA(C1, C2)
REAL*8 C1
REAL*8 C2
.in  -.5i
.fi 
.IX "DoLightAttenuation"
.IX "DOLTA"
.SH DESCRIPTION
.LP
\f2DoLightAttenuation\fP creates a light studio attribute object
that defines a multiplicative factor modifying the light intensity as
a function of the distance from the light source.
The parameters \f2c1\fP and \f2c2\fP are constants used to 
calculate this factor:
.sp
attn = 1. / (\f2c1\fP + \f2c2\fP*distance)
.sp 
The \f2DoLightAttenuation\fP attribute defines the light attenuation for 
lights of type \f2DcLightPointAttn\fP <\f2DCLTPA\fP> and
\f2DcLightSpotAttn\fP <\f2DCLTSA\fP>. 
.SH DEFAULTS
The default \f2DoLightAttenuation\fP is  (1., 1.).
.SH SEE ALSO
.na
.nh
DoLightSpreadAngles(3D),
DoLightSpreadExp(3D)
DoLightType(3D)
.ad
.hy
