.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DoBackfaceCullable 3D  "Dore"
.SH NAME
DoBackfaceCullable \- Create a primitive attribute object defining backface cullability
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DoBackfaceCullable(switchvalue)
DtSwitch switchvalue;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DOBFC(SWVAL)
INTEGER*4 SWVAL
.in -.5i
.fi
.SH DESCRIPTION
.IX DOBFC
.IX DoBackfaceCullable
.I DoBackfaceCullable
creates a backface cullability primitive attribute object.
Backface cullability is a surface property of a primitive object.
The \f2switchvalue\fP parameter specifies whether subsequent
primitive objects will render more efficiently 
if their backward facing surfaces
are ignored before shading and rendering takes place.
The actual backface culling cannot take place until
the \f2DoBackfaceCullSwitch\fP <\f2DOBFCS\fP> is enabled.
.SH DEFAULTS
The default value for \f2DoBackfaceCullable\fP is \f2DcOff\fP <\f2DCOFF\fP>.
.SH "SEE ALSO"
DoBackfaceCullSwitch(3D), DoHiddenSurfSwitch(3D)
