.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdSetViewport 3D  "Dore"
.SH NAME
DdSetViewport \- Define a device viewport for a device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DdSetViewport(device, viewport)
DtObject device;
DtVolume *viewport;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DDSDV(DEVICE, VWPORT)
INTEGER*4 DEVICE
REAL*8 VWPORT(6)
.in -.5i
.fi
.SH DESCRIPTION
.IX DdSetViewport
.IX DDSDV
.I DdSetViewport
sets the device viewport for the device \f2device\fP
to \f2viewport\fP. 
The device viewport specifies the
portion of the device's extent onto which the frame boundary is mapped
(i.e. the portion of the device's view surface to be used for display).
The default viewport uses all of the current device volume.  If the device 
extent changes (for example, if an X-window is resized), then the default 
viewport automatically changes to fit the new device extent, unless the device
is specified as a non-auto-resizing device (see \f2DoDevice\fP).
.SH ERRORS
.I DdSetViewport
will fail if the device handle is invalid.
.TP 15
[WARNING - invalid device handle]
.SH "SEE ALSO"
DdInqExtent(3D), DdInqViewport(3D), DoDevice(3D)
