.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdSetPickCallback 3D "Dore"
.SH NAME
DdSetPickCallback \- Set the picking callback object of a device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DdSetPickCallback(device, pickcallbackobj)
DtObject device;
DtObject pickcallbackobj;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DDSPCB(DEVICE, PKCBOJ)
INTEGER*4 DEVICE
INTEGER*4 PKCBOJ
.in -.5i
.fi
.SH DESCRIPTION
.IX DDSPCB
.IX DdSetPickCallback
.I DdSetPickCallback
sets the device picking callback object, \f2pickcallbackobj\fP, to be
used on the device, \f2device\fP.
.PP
Picking is a method of identifying displayable primitive objects that
fall within a specified volume known as a device pick aperture (see
\f2DdSetPickAperture\fP).  A pick is initiated by a call to
\f2DdPickObjs\fP <\f2DDPO\fP>.
The pick callback is a callback object that selects which primitive
objects found within the pick aperture during a pick (known as
"hits") will actually be returned.  Dor\o.\(aae. currently provides three
standard pick callback objects that may be used; however, users may
also easily provide their own.  The standard callback objects
are:
.IP "\f2DcPickFirst\fP <\f2DCPKFR\fP>"
Accept only the first hit found.
.IP "\f2DcPickClosest\fP <\f2DCPKCL\fP>"
Accept only the hit that was frontmost (closest to the viewer)
in the pick aperture.
.IP "\f2DcPickAll\fP <\f2DCPKAL\fP>"
Add all hits found to the hit list.
.PP
Users may want to add other types of callback objects such as those
that accept or exclude only hits on certain types of objects or
those that accept only up to a maximum number of hits before
terminating a search.
.PP
The following information is intended mainly for users who wish to create
their own pick callback objects.
.PP
\f2DdSetPickCallback\fP specifies a callback object that is called
each time a hit is detected.  That callback gets to peek at
each pick path generated by pick hits and decide what to do with the hit.
Users create their own pick callback objects by writing a function
and making the function into an object
using the function, \f2DoCallback\fP <\f2DOCB\fP>.
The function in C should look like this:
.nf

	DtHitStatus my_callback_fcn(data, path_elements, path, 
    	     z_value, view, hits);
	DtPtr data;               /* if \f2data\fP is a pointer to data */
	Dt32Bits data;            /* if \f2data\fP is a value */
	DtInt path_elements;	
	long *path;
	DtReal z_value;
	DtObject view;
	DtInt hits;

.fi
FORTRAN:
.nf

	INTEGER*4 FCN(DATA,PTHELE,PATH,ZVAL,VIEW,
       + HITS)
	INTEGER*4 DATA
	INTEGER*4 PTHELE
	INTEGER*4 PATH
	REAL*8 ZVAL
	INTEGER*4 VIEW
	INTEGER*4 HITS

.fi
The function takes the following six arguments:
.IP "\f2data\ \ \ \fP"
A \f2Dt32Bits\fP or \f2DtPtr\fP that contains associated run-time
data to be passed to the function (see \f2DoCallback\fP).
.IP "\f2path_elements\fP"
An integer specifying the number of pick elements in the pick path.
.IP "\f2path\ \ \fP"
A returned integer that is the beginning of the pick path
(described below).
.IP "\f2z_value\fP"
A real number specifying the depth of the closest point of the hit (in 
device coordinates).
.IP "\f2view\ \ \ \fP"
An object specifying the view in which the hit was found.
.IP "\f2hits\ \ \ \fP"
An integer specifying the total number of hits accepted so far
during this pick.
.PP
A "hit" primitive is uniquely identified by its
\f2pick path\fP.  A pick path is a list of \f2pick elements\fP that
trace the display tree nodes between the root object and 
the picked primitive.
Each pick element, for a particular node, consists of three values 
in the display tree:
.IP
The object handle for this node's object.
.IP
The current pick ID for this node.
.IP
The location within this group of the next node.
This location is the same as the group element number of the next node
in the pick path.  Note that the last pick element in the path (or
first, if the pick path order is \f2DcBottomFirst\fP <\f2DCBOTF\fP>)
refers to the primitive that was hit instead of a containing group object. 
The location of the next node within this primitive object is
undefined because this primitive object is the last node (and this
primitive object is not a group).
.PP
The pick path passed to the callback function will always be ordered
from the root node of the group network down to the picked primitive
regardless of the current value of the device's pick path order.  The
function can choose whether to accept this hit and add it to the hit
list that will be returned by the current pick, reject the hit, or
overwrite the previous hit (path) accepted.
.PP
The pick callback function must return a value of type
\f2DtHitStatus\fP. Valid values are:
.nf
	\f2DcHitAccept\fP <\f2DCHACC\fP>
	\f2DcHitReject\fP <\f2DCHREJ\fP>
	\f2DcHitOverwrite\fP <\f2DCHOVW\fP>
.fi
.PP
Returning \f2DcHitOverwrite\fP <\f2DCHOVW\fP>
when no hits have yet been accepted
behaves the same as \f2DcHitAccept\fP <\f2DCHACC\fP>.
Any other returned value will result in a \f2DcPickBadStatus\fP 
<\f2DCPBAD\fP> error
word being generated and returned by the current call to \f2DdPickObjs\fP
<\f2DDPO\fP>.
.PP
The callback function can choose to stop the execution of the current
group or can abort the pick altogether by calling \f2DsExecutionReturn\fP
<\f2DSER\fP> or \f2DsExecutionAbort\fP <\f2DSEA\fP>.
An aborted pick will still return the paths of all the hits previously
accepted.
.PP
Pickability is controlled by the pickability switch attribute.  Its
value is determined by \f2DoPickSwitch\fP <\f2DOPS\fP> and also
by name sets and filters (see \f2DoNameSet\fP and \f2DoFilter\fP).
The invisibility attribute is treated similarly.  Primitive objects
which are invisible or unpickable cannot be picked.
By default, all objects are not pickable.
.SH ERRORS
.I DdSetPickCallback
will fail if passed an invalid device handle or pick callback object.
.TP 15
[WARNING - invalid device handle]
.TP 15
[WARNING - invalid pick callback object]
.SH DEFAULTS
The default \f2DdSetPickCallback\fP is \f2DcPickFirst\fP <\f2DCPKFR\fP>.
.SH "SEE ALSO"
.na
.nh
DdInqPickAperture(3D), DdInqPickCallback(3D), DdPickObjs(3D),
DdSetPickAperture(3D), DoFilter(3D), DoNameSet(3D), DoPickID(3D),
DoCallback(3D), DsExecutionAbort(3D), DsExecutionReturn(3D)
.ad
.hy
