.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdInqResolution 3D  "Dore"
.SH NAME
DdInqResolution \- Return the resolution of a device
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
void DdInqResolution(device, x, y)
DtObject device;
DtReal *x;
DtReal *y;
.sp
.in -.5i
FORTRAN:
.in +.5i
CALL DDQR(DEVICE, X, Y)
INTEGER*4 DEVICE
REAL*8 X
REAL*8 Y
.in -.5i
.fi
.SH DESCRIPTION
.IX DDQR
.IX DdInqResolution
.I DdInqResolution
returns the size of a pixel (in millimeters) on the device, 
\f2device\fP.  It returns the width and height values in the two parameters
\f2x\fP and \f2y\fP.
.PP
\f2DdInqExtent\fP <\f2DDQE\fP> is used to determine the extent
of the device in XYZ.
.SH ERRORS
.I DdInqResolution
will fail if the device handle is invalid.
.TP 15
[WARNING - invalid device handle]
.SH "SEE ALSO"
DdInqExtent(3D)
