.\"#ident "%W% %G%"
.\"
.\" # Copyright (C) 1994 Kubota Graphics Corp.
.\" # 
.\" # Permission to use, copy, modify, and distribute this material for
.\" # any purpose and without fee is hereby granted, provided that the
.\" # above copyright notice and this permission notice appear in all
.\" # copies, and that the name of Kubota Graphics not be used in
.\" # advertising or publicity pertaining to this material.  Kubota
.\" # Graphics Corporation MAKES NO REPRESENTATIONS ABOUT THE ACCURACY
.\" # OR SUITABILITY OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED
.\" # "AS IS", WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING THE
.\" # IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" # PURPOSE AND KUBOTA GRAPHICS CORPORATION DISCLAIMS ALL WARRANTIES,
.\" # EXPRESS OR IMPLIED.
.\"
.TH DdInqFrame 3D  "Dore"
.SH NAME
DdInqFrame \- Return the frame of a device 
.SH SYNOPSIS
.nf
.ft 3
C:
.in  +.5i
DtObject DdInqFrame(device)
DtObject device;
.sp
.in -.5i
FORTRAN:
.in +.5i
INTEGER*4 DDQFR(DEVICE)
INTEGER*4 DEVICE
.in -.5i
.fi
.SH DESCRIPTION
.IX DDQFR
.IX DdInqFrame
.I DdInqFrame
returns the frame for device, \f2device\fP.  Only one frame is allowed
per device.
.PP
A frame is an organizational object used to describe an image that is to be
displayed on a device.  A frame can be
displayed on zero or more devices using the function
\f2DdSetFrame\fP <\f2DDSF\fP>.
.SH ERRORS
.I DdInqFrame
will fail if the device handle is invalid; the value
\f2DcNullObject\fP <\f2DCNULL\fP> is returned.
.TP 15
[WARNING - invalid device handle]
.SH "SEE ALSO"
DdSetFrame(3D), DoFrame (3D)
