#include "salem.h"

int addview();
int set_cluster();
int set_color();
int copilot(), uncopilot();
int background();

char *ViewUsage = "view view_name [stereo] [orthogonal] [x y X Y]" ;
initialize_windows()
{
	register_client("view",   addview,  ViewUsage );
	notranscribe_last_client();
	register_client("setcluster",set_cluster, "setcluster view_name [objname]");
	register_client("copilot",copilot, "copilot master_view slave_views");
	register_client("uncopilot",uncopilot, "uncopilot view_names");
	register_client("globalcolor",set_color,  "globalcolor [r g b] " );
	register_client("background",background,  "background [r g b] " );
}

/*
 * draw polygons of all objects.
 * graphics state is set by the caller.
 */

draw_obj(obj,win,disp)
object_t	*obj;
window_t	*win;
double		disp;
{
	objlink_t	*link;
	polygon_t       *endpoly;
	int             i,j,skip;

	if (obj == NULL) return;

	disp = disp * obj->displayed;
	if (disp <= 0.0) return;

	pushmatrix(); 
	multmatrix(obj->v); 

	for (link = obj->child_list; link; link = link->c_next) {
		draw_obj(link->child,win,disp);
		}

	i	= 0;
	skip	= 1/disp;	
	j	= (rand()/10463)%skip;
	endpoly = obj->polygons + obj->n_polygons;

	if (win->stereo)
		stereo_shade(obj->polygons, endpoly, i,j,skip);
	else    {
		switch(obj->shading)    {
			case GOURAUD :
				gouraud_shade(obj->polygons, endpoly, i,j,skip);				break;
			case FLAT :
				flat_shade(obj->polygons, endpoly, i,j,skip);
				break;
			case MIXED :
				mixed_shade(obj,obj->polygons,endpoly,i,j,skip);				break;
			case WIREFRAME :
				wire_shade(obj->polygons, endpoly, i,j,skip);
				break;
			case PATCHES :
				patch_shade(obj);
				break;
			default :
				fprintf(stderr," %s : unknown shading model\n",
					obj->shading);
				break;
			}
		}
	popmatrix();

	if (obj->flags & SL_SHOWNAME) {
		cmov(obj->v[3][0],obj->v[3][1],obj->v[3][2]);
		charstr(obj->name);
	}
}

gouraud_shade(poly_first, poly_last, i,j,skip)
polygon_t     *poly_first, *poly_last;
int           i,j,skip;
{
      polygon_t       *poly;
      vertex_t        **v,**endv;
      vertex_t *v0, *v1, *v2 ;
      unsigned long c0, c1, c2;
      int is;

      shademodel(GOURAUD);

      for (poly = poly_first; poly < poly_last; poly++) {
              if (i++ < j) continue;
              j += skip;
              if (poly->n_vertices == 3)      {
			v0 = poly->v[0]; v1 = poly->v[1]; v2 = poly->v[2];
                 c0 = (poly->v[0]->colored) ? poly->v[0]->fastcolor:Globalcolor;
                 c1 = (poly->v[1]->colored) ? poly->v[1]->fastcolor:Globalcolor;
                 c2 = (poly->v[2]->colored) ? poly->v[2]->fastcolor:Globalcolor;
                      bgnpolygon();
                      cpack(c0);
                      v4f(v0->position);
                      cpack(c1);
                      v4f(v1->position);
                      cpack(c2);
                      v4f(v2->position);
                      endpolygon();
                      }
              else    {
                      endv = poly->v + poly->n_vertices;
                      bgnpolygon();
                      for (v = poly->v; v < endv; v++) {
                              cpack(((*v)->colored)?(*v)->fastcolor:Globalcolor);
                              if (Lights_exist) n3f((*v)->normal);
                              v4f((*v)->position);
				}
                      endpolygon();
                      }
              }
}

flat_shade(poly_first, poly_last, i,j,skip)
polygon_t     *poly_first, *poly_last;
int           i,j,skip;
{
      polygon_t       *poly;
      vertex_t        **v,**endv;
      int             vc,co,r,g,b,rt,gt,bt;
      unsigned long   lcol;
      shademodel(FLAT);
      for (poly = poly_first; poly < poly_last; poly++) {
              if (i++ < j) continue;
              j += skip;
              endv = poly->v + poly->n_vertices;
              if (poly->colored)
                      lcol = poly->fastcolor;
              else    {
                      r = g = b = vc =0;
                      for ( v = poly->v; v < endv ; v++)
                              if ((*v)->colored)      {
                                vc++;
				extract_color_triple((*v)->fastcolor,&rt,&gt,&bt);
                                b += bt;
                                g += gt;
                                r += rt;
				}
                      lcol = (vc != 0) ?
                              int_color_triple(r/vc,g/vc,b/vc): Globalcolor;
                      }
              bgnpolygon();
              cpack(lcol);
              for ( v = poly->v; v < endv; v++) {
                      v4f((*v)->position);
                      }
              endpolygon();
              }
}

mixed_shade(obj,poly_first, poly_last, i,j,skip)
object_t      *obj;
polygon_t     *poly_first, *poly_last;
int           i,j,skip;
{

      while (obj->g_st < 0) obj->g_st += obj->n_polygons;
      while (obj->g_st >= obj->n_polygons ) obj->g_st -= obj->n_polygons;
      while (obj->g_end < 0) obj->g_end += obj->n_polygons;
      while (obj->g_end >= obj->n_polygons ) obj->g_end -= obj->n_polygons;
      if (obj->g_st < obj->g_end)
              gouraud_shade(poly_first+obj->g_st,poly_first+obj->g_end,i,j,skip);
              if (obj->g_end < (obj->n_polygons -1))
                      flat_shade(poly_first+obj->g_end+1, poly_last,i,j,skip);
              if (obj->g_st > 0)
                      flat_shade(poly_first, poly_first+obj->g_st-1,i,j,skip);
      else    {
              gouraud_shade(poly_first+obj->g_end, poly_last,i,j,skip);
              gouraud_shade(poly_first, poly_first + obj->g_st,i,j,skip);
              if ((obj->g_end - obj->g_st) > 2)
                      flat_shade(poly_first+obj->g_st+1,
                              poly_first+obj->g_end-1,i,j,skip);
              }

      obj->g_st += obj->c_st;
      obj->g_end += obj->c_end;

}

wire_shade(poly_first, poly_last, i,j,skip)
polygon_t     *poly_first, *poly_last;
int           i,j,skip;
{
      polygon_t       *poly;
      vertex_t        **v,**endv;

      for (poly = poly_first; poly < poly_last; poly++) {
              if (i++ < j) continue;
              j += skip;
              bgnclosedline();
              endv = poly->v + poly->n_vertices;
              v = poly->v;
              cpack( ((*v)->colored) ? (*v)->fastcolor :Globalcolor);
              for ( ; v < endv; v++) v4f((*v)->position);
              endclosedline();
		}
}

stereo_shade(poly_first, poly_last, i,j,skip)
polygon_t     *poly_first, *poly_last;
int           i,j,skip;
{
      polygon_t       *poly;
      vertex_t        **v,**endv;
      for (poly = poly_first; poly < poly_last; poly++) {
              if (i++ < j) continue;
              j += skip;
              endv = poly->v + poly->n_vertices;
              bgnclosedline();
              for (v = poly->v; v < endv; v++) {v4f((*v)->position);}
              endclosedline();
              }
}

patch_shade(obj)
object_t      *obj;
{
      int i;
      patchcurves(4,4);
      patchprecision(200,200);
      cpack(Globalcolor);
      for (i = 0; i < obj->n_patches; i++) {
              patch(obj->patches[i].x,obj->patches[i].y, obj->patches[i].z);
              }
}

/* because views can be swept with the mouse,
 * "view" does its own transcription.
 */
transcribe_view (win)
window_t	*win;
{
	int	argc = 0, xorg,yorg,xsize,ysize;
	char	*argv[8],lx[16],ly[16],ux[16],uy[16];

	if (!Transcript_fp) return;
	argv[argc++]	= "view";
	argv[argc++]	= win->obj->name;
	if (win->stereo) argv[argc++] = "stereo";
	if (win->proj.type == ORTHOGONAL) 
		argv[argc++] = "orthogonal"; 
	getorigin(&xorg,&yorg);
	getsize(&xsize,&ysize);
	sprintf(lx,"%d",xorg); argv[argc++] = lx;
	sprintf(ly,"%d",yorg); argv[argc++] = ly;
	sprintf(ux,"%d",xorg+xsize); argv[argc++] = ux;
	sprintf(uy,"%d",yorg+ysize); argv[argc++] = uy;
	transcribe(argc,argv);
}

init_window (win)
window_t	*win;
{
	win->gid = winopen(win->obj->name);
	if (win->stereo == FALSE) {
		zbuffer(TRUE);
		lsetdepth(0,0x7fffff);
		}
	doublebuffer();
	RGBmode();
	mmode(MVIEWING);
	gconfig();
	if (win->stereo == FALSE) {
		cpack(Backgroundcolor);
		clear();
		swapbuffers();
		}
	win->proj.frontclip= .01;
	win->proj.backclip= 10000;
	win->proj.zoom = 1;
	win->flags|= WINDOW_RUNNING|WINDOW_REDRAW;
	geom_translate(win->obj->v, 0.0, 0.0, -1.0); /* Mr.window starts at (0,0,-1) */
	transcribe_view(win);
}

update_window(win) 
window_t* win; 
{
	Matrix M;
	if (win->flags & WINDOW_EXISTS) {
		if (win->gid == 0) init_window(win);
		if ((win->flags & WINDOW_REDRAW) && (win->flags & WINDOW_RUNNING)){
			winset(win->gid);
			reshapeviewport();
			RGBcolor(255,255,255);
			RGBwritemask(255,255,255);
			clear();
			RGBcolor(0, 0, 0) ;
			if (win->stereo)	{
	
				perspective_view(M, win,1);
				loadmatrix(M);
				get_position(M, win->obj);
				invert_matrix(M, M);
				multmatrix(M);
				RGBwritemask(255,0,0);
				draw_obj(win->cluster,win,1.0);
	
				perspective_view(M, win,-1);
				loadmatrix(M);
				get_position(M, win->obj);
				invert_matrix(M, M);
				multmatrix(M);
				RGBwritemask(0,255,255);
				draw_obj(win->cluster,win,1.0);

				}
			else	{
				perspective_view(M, win,0);
				loadmatrix(M);
				get_position(M, win->obj);
				invert_matrix(M, M);
				multmatrix(M);

				if (win->light_on) {
					float prop[20];
					prop[0]= POSITION;
					prop[1]= 0;prop[2]= 0;prop[3]= 1;
					prop[4]= LMNULL;
					lmdef(DEFLIGHT,(win-Window)+1,5,prop);
					redraw_all_windows();
					}
				cpack(Backgroundcolor);
				clear();
				zclear();
	
				draw_obj(win->cluster,win,1.0);
				}
			swapbuffers();
			win->flags &= ~WINDOW_REDRAW;
			}
		}
	else if (win->gid != 0) {
		if (win->obj->win == win) delete_object(win->obj);
		winclose(win->gid);
		win->gid = 0;
		bzero(win,(unsigned)sizeof(window_t));
		}
}

display_tick()
{
	int		i;

	Last_tick++;
	if (Ticks_to_wait) Ticks_to_wait--;
	for (i = 0; i < MAXWINDOWS; i++) update_window(&Window[i]);
}

window_flag(gid,flag,state)
int gid,flag;
Boolean state;
{
	window_t *win = find_window(gid);
	if (win) {
		if (state)	win->flags|= flag;
		else		win->flags&= ~flag;
		}
}

redraw_all_windows()
{
	window_t *win;
	for (win = Window; win < Window+MAXWINDOWS; win++)
		if (win->gid != 0) win->flags|= WINDOW_REDRAW;
}

window_t *find_window(gid)
int gid;
{
	window_t *win;
	if (gid) {
		for (win = Window; win < Window+MAXWINDOWS; win++)
			if (win->gid == gid) return(win);
		fprintf(stderr,"warning, lost a window\n");
	}
	return NULL;
}

addview(argc,argv)
int  argc;
char **argv;
{
	int		slot;
	int		i,j;
	char	buf[80];

	if ((argc > 8)  || (argc < 2)) ERR_RET(ViewUsage);
	if (get_object(argv[1])) ERR_RET_2(argv[1],":object already exists")

	for (slot = 0; slot < MAXWINDOWS; slot++) 
		if (!(Window[slot].flags&WINDOW_EXISTS)) break;
	
	if (slot >= MAXWINDOWS)
		fprintf(stderr,"view: too many windows open\n");
	else {
		i = slot;
		Window[i].obj = new_object(strdup(argv[1]), argc,argv);
		Window[i].obj->win = Window+i;
		Window[i].flags|= WINDOW_EXISTS;
		Window[i].stereo = FALSE ;
		sprintf(buf,"view/%s_cluster",Window[i].obj->name);
		make_link(Window[i].cluster = new_subobject(buf,Root,argc,argv),World);
		Window[i].proj.type = PERSPECTIVE;
		Window[i].fp = 5.00;
		Window[i].fe = 0.15;
		for (j = 2 ; j < argc ; j++ )	{
			if (isdigit(argv[j][0]))	{
				long lx,ly,ux,uy;
				lx = atol(argv[j++]);
				ly = atol(argv[j++]);
				ux = atol(argv[j++]);
				uy = atol(argv[j]);
				prefposition(lx,ux,ly,uy);
				}
			else	switch(argv[j][0])	{
				case 's' : 
					Window[i].stereo = TRUE ;
					break;
				case 'o' : 
					Window[i].proj.type = ORTHOGONAL;
					break;
				}
		}
	}
	return slot;
}

set_cluster(argc,argv)
int argc;
char **argv;
{
	int			i;
	window_t	*win;
	object_t	*obj;
	objlink_t	*link;

	if (argc <= 1) return;
	if((obj=get_object(argv[1]))==NULL) ERR_RET_2(argv[1],":no such object")
	if ((win = obj->win) == NULL) ERR_RET_2(argv[1],":not a window");
	if (argc > 2) 	{
		for (i = 2; i < argc; i++) {
			if ((obj = get_object(argv[i])) == NULL)
			  fprintf(stderr,"no such object as %s\n",argv[i]);
			else 	{
				if ( (win->cluster->child_list != NULL) &&
				    (win->cluster->child_list->child == World))
					delete_link(win->cluster->child_list);
				if (get_link(win->cluster,obj) == NULL)
					make_link(win->cluster,obj);
				}
			}
		}
	else 	while (link = win->cluster->child_list) delete_link(link);
}

set_color(argc,argv)
int	argc;
char	**argv;
{
	int  r0,r1,r2;
	if(argc != 4) {
		extract_color_triple(Globalcolor,&r0,&r1,&r2);
		printf(" default color is %f %f %f\n",r0,r1,r2);
		}
	else	
		Globalcolor = int_color_triple(atoi(argv[1]),atoi(argv[2]),
			atoi(argv[3]));
}

background(argc,argv)
int   argc;
char **argv;
{
	int  r0,r1,r2;
	if(argc != 4) {
		extract_color_triple(Backgroundcolor,&r0,&r1,&r2);
		printf(" default color is %d %d %d\n",r0,r1,r2);
		}
	else	
		Backgroundcolor = int_color_triple(atoi(argv[1]),atoi(argv[2]),
			atoi(argv[3]));
}

copilot(argc,argv)
int		argc;
char	**argv;
{
	int			i;
	object_t	*master,*slave;
	window_t	*mwin,*swin;

	if (argc < 3) return;
	master = get_object(argv[1]);
	if (master == NULL) ERR_RET_2(argv[1],"not found");
	if (master->win == NULL) ERR_RET_2(argv[1],"is not a window object");
	for (i = 2; i < argc; i++) {
		slave = get_object(argv[i]);
		if (slave == NULL) fprintf(stderr,"%s not found\n",argv[i]);
		else {
			if (slave->win == NULL)
				fprintf(stderr,"%s is not a window object",argv[i]);
			else {
				slave->win->obj = master;
				/*slave->win = NULL;*/
				/*delete_object(slave);*/
			}
		}
	}
}

uncopilot(argc,argv)
int		argc;
char	**argv;
{
	int			i;
	object_t	*obj;

	for (i = 1; i < argc; i++) {
		obj = get_object(argv[i]);
		if (obj == NULL) fprintf(stderr,"%s not found\n",argv[i]);
		else if (obj->win == NULL)
			fprintf(stderr,"%s is not a window object",argv[i]);
		else {
			emu_copy_matrix(obj->v,obj->win->obj->v);
			obj->win->obj = obj;
		}
	}
}
