#include "salem.h"
#define NEW_VERTS	100
#define NEW_POLYS	100

#define ERR_RANGE(j,k,l)	{\
			fprintf(stderr,"vertex %d face %d (%d) out of range",j,k,l);\
			fprintf(stderr," -- new face not created\n");\
			free(cobj->polygons[cobj->n_polygons].v);\
			return(-1);\
			}
static object_t *cobj;

sl_quick_create_object(oname)
char *oname;
{
	char argv[2][MAXLINE];
	strcpy(argv[0],"sl_quick_create");
	strcpy(argv[1],"oname");
	return(sl_create_object(oname,0,0,2,argv));
}

sl_create_object(oname, nvr, nfr, argc, argv)
char *oname;
int nvr;
int nfr;
int argc;
char **argv;
{
	object_t *obj;
	char 		largv[4][MAXLINE], nname[MAXLINE];
	int 		i;
	
        if (get_object(oname)) {
                fprintf(stderr,"object %s already exists ",oname);
		i = 0;
		do	{
			if (i < 10) sprintf(nname,"%s.%1d",oname,i);
			else if (i < 100) sprintf(nname,"%s.%2d",oname,i);
			i++ ;
			}	
		while(get_object(nname));
                fprintf(stderr,"-- your object has beeen renamed %s\n",nname);
                }
	else strcpy(nname, oname);

	if (argc == 0)	{
		strcpy(largv[0],"easy_object");
		strcpy(largv[1],oname);
		sprintf(largv[2],"%d",nvr);
		sprintf(largv[3],"%d",nfr);
       		obj = new_object(nname,4,largv);
		}
	else	obj = new_object(nname,argc,argv);

	if (nvr == 0)	nvr = NEW_VERTS;
	obj->v_list = N_NEW(nvr, vertex_t);
	if (NULL == obj->v_list) 	{
		fprintf(stderr,"malloc fails in sl_object\n");
		return(0);
		}
	obj->n_vertices_alloc = nvr;

	if (nfr == 0)	nfr = NEW_POLYS;
	obj->polygons = N_NEW(nfr, polygon_t);
	if (NULL == obj->polygons) {
		fprintf(stderr,"malloc fails in sl_object\n");
		return(0);
		}
	obj->n_polygons_alloc = nfr;

	if (cobj != NULL) sl_close_object();
	cobj = obj;
	return(1);
}

sl_reopen_object(oname)
char *oname;
{
	object_t		*nobj;
        if ((nobj = get_object(oname)) == NULL) {
                fprintf(stderr,"object %s doesn't exists ",oname);
		return(0);
                }
	if (cobj != NULL) sl_close_object();
	cobj = nobj;
	return(1);
}

sl_vertex(x,y,z)
double x,y,z;
{
	return(sl_vertex_4(x,y,z,(double) 1.0));
}

sl_vertex_4(x,y,z,w)
double x,y,z,w;
{
	polygon_t	*pp;
	vertex_t 	*vold;
	int 		i,j;

	if (cobj->n_vertices == cobj->n_vertices_alloc)	{
		vold = cobj->v_list;
		cobj->v_list = N_RE(cobj->v_list, 
			(cobj->n_vertices+NEW_VERTS), vertex_t);
		for(i=0, pp=cobj->polygons; i<cobj->n_polygons; i++, pp++)
			for (j = 0 ; j < pp->n_vertices ; j++ )
				pp->v[j] = cobj->v_list + (pp->v[j] - vold);
		cobj->n_vertices_alloc += NEW_VERTS;
		}
	cobj->v_list[cobj->n_vertices].position[0] = x;
	cobj->v_list[cobj->n_vertices].position[1] = y;
	cobj->v_list[cobj->n_vertices].position[2] = z;
	cobj->v_list[cobj->n_vertices].position[3] = w;
	return(cobj->n_vertices++);
}

sl_color_face(n,varr,col)
int n, varr[], col;
{
	int fno;
	if ((fno = sl_face(n,varr)) == -1)	return(-1);
	return(sl_color(fno,col));
}
	
sl_color_triangle(v0,v1,v2,col)
int v0,v1,v2,col;
{
	int v[3];
	v[0] = v0; v[1] = v1; v[2] = v2;
	return(sl_color_face(3,v,col));
}
	
sl_triangle(v0,v1,v2)
int v0,v1,v2;
{
	int v[3];
	v[0] = v0; v[1] = v1; v[2] = v2;
	return(sl_face(3,v));
}

sl_face(n,varr)
int n, varr[];
{
	int j;
	if (cobj->n_polygons == cobj->n_polygons_alloc)	{
		cobj->polygons = N_RE(cobj->polygons, 
			(cobj->n_polygons+NEW_POLYS), polygon_t);
		cobj->n_polygons_alloc += NEW_POLYS;
		}
	cobj->polygons[cobj->n_polygons].v = N_NEW(n, vertex_t*);
	for (j = 0 ; j < n ; j++ )	{
		if (varr[j] < 0) 
			if (varr[j] <= cobj->n_vertices)
				varr[j] = cobj->n_vertices - varr[j];
			else	ERR_RANGE(j,cobj->n_polygons,varr[j])
		if (varr[j] >= cobj->n_vertices)	
			ERR_RANGE(j,cobj->n_polygons,varr[j])
		cobj->polygons[cobj->n_polygons].v[j] = cobj->v_list + varr[j];
		}
	for (j = 0 ; j < n ; j++ )	
		cobj->v_list[varr[j]].order++;
	cobj->polygons[cobj->n_polygons].n_vertices = n;
	make_normal(&cobj->polygons[cobj->n_polygons]);
	return(cobj->n_polygons++);
}

sl_color(fno, col)
int fno, col;
{
	if ( (fno < 0) || (fno >= cobj->n_polygons))	{
		fprintf(stderr," face number %d is out of range\n",fno);
		return(-1);
		}
	cobj->polygons[fno].fastcolor = col;
	cobj->polygons[fno].colored = TRUE;
	return(1);
}

sl_color_object()
{
	int i;
	for (i = 0 ; i < cobj->n_polygons ; i++ )
		cobj->polygons[i].fastcolor = random_face_color();
}

sl_default_color_object()
{
	int i;
	for (i = 0 ; i < cobj->n_polygons ; i++ )
		cobj->polygons[i].fastcolor = Globalcolor;
}

sl_set_transform(oname, transform)
char *oname;
Matrix transform;
{
	object_t	*tobj,*nobj;
        if ((nobj = get_object(oname)) == NULL) {
                fprintf(stderr,"object %s doesn't exists ",oname);
		return(0);
                }
	tobj = cobj;
	cobj = nobj;
	sl_transform(transform);
	cobj = tobj;
	return(1);
}

sl_transform(transform)
Matrix transform;
{
	emu_copy_matrix(cobj->v, transform);
}

sl_close_object()
{
	make_vertex_normals(cobj);
	make_vertex_colors(cobj);
	cobj = NULL;
	return(1);
}

sl_current_object(nn)
char *nn;
{
	if (cobj == NULL) strcpy(nn,"NoObject");
	else	strcpy(nn,cobj->name);
}

sl_bounding_box(mins,maxs)
double mins[];
double maxs[];
{
	int 		i,j;
	vertex_t	*v;

	for (i = 0; i < 3; i++ ) {mins[i] = FLT_MAX;maxs[i] = -FLT_MAX;}

	for (v = cobj->v_list, i = 0 ; i < cobj->n_vertices ; i++, v++ )
		for (j = 0 ; j < 3 ; j++ )      {
			if (v->position[j] < mins[j]) mins[j] = v->position[j];
			if (v->position[j] > maxs[j]) maxs[j] = v->position[j];
			}

	return(1);
}

sl_command(s)
char *s;
{
	parse_entire_string(s);
}
