#include "salem.h"

int 	bind_mouse();
int 	unbind_mouse();

initialize_mouse()
{
	register_client("bind",bind_mouse,"bind button_list [to] command" );
	notranscribe_last_client();
	register_client("unbind",unbind_mouse,"unbind button_list " );
	notranscribe_last_client();
}

sym_t event_names[] = {
	{"leftmouse",	LEFTMOUSEBUTTON},
	{"middlemouse",	MIDDLEMOUSEBUTTON},
	{"rightmouse",	RIGHTMOUSEBUTTON},
	{"leftshift",	LEFTSHIFTBUTTON},
	{"rightshift",	RIGHTSHIFTBUTTON},
	{"f1",	F1BUTTON},
	{"f2",	F2BUTTON},
	{"f3",	F3BUTTON},
	{"f4",	F4BUTTON},
	{"f5",	F5BUTTON},
	{"f6",	F6BUTTON},
	{"f7",	F7BUTTON},
	{"f8",	F8BUTTON},
	{"f9",	F9BUTTON},
	{"f10",	F10BUTTON},
	{"f11",	F11BUTTON},
	{"f12",	F12BUTTON},
	{"button",0},	/* these are noise words */
	{"buttons",0},
	{"to",0},
	{"and",0},
	{NULL,0}
};

typedef struct event_action event_action;
struct event_action {
	long		buttons;
	char		*action;
	event_action	*prev,*next;
};

event_action *Bindings;

do_mouse() 
{
	event_action	*listptr;

	if (!Mouse.buttonsdown) return;
	for (listptr = Bindings; listptr; listptr = listptr->next) {
		if (listptr->buttons == Mouse.buttonsdown)
			parse_entire_string(listptr->action);
		}
}

bind_mouse(argc,argv)
int	argc;
char	**argv;
{
	int		i = 1, buttons = 0;
	char		cmd[MAXLINE],*p;
	sym_t		*sym;
	event_action	*new_entry,*entry;

	for (i = 1; ((i < argc) && (sym = lookup(argv[i],event_names))) ; i++ )
		buttons |= sym->val;

	if (buttons && (i < argc)) {
		unbind(buttons);
		p = cmd;
		while (i < argc) {
			strcpy(p,argv[i++]);
			strcat(p," ");
			while (*p++);
			}
		new_entry = NEW(event_action);
		new_entry->buttons = buttons;
		new_entry->action = strdup(cmd);
		new_entry->next = Bindings;
		new_entry->prev = 0;
		if (Bindings) Bindings->prev = new_entry;
		Bindings = new_entry;
		}
	else {
		if (!buttons) fprintf(stderr,"bind button_list [to] command\n");
		for (entry = Bindings; entry; entry = entry->next) {
			if (!buttons || entry->buttons == buttons) {
				printf("bind ");
				for (i = 0; event_names[i].name; i++) {
					if (event_names[i].val & entry->buttons)
						printf("%s ",event_names[i].name);
				}
				printf(" to \"%s\"\n",entry->action);
				}
			}
		}
}

unbind_mouse(argc,argv)
int argc;
char *argv[];
{
	int 		i = 1, buttons;
	sym_t		*sym;
	for (i = 1; ((i < argc) && (sym = lookup(argv[i],event_names))) ; i++ )
		buttons |= sym->val;
	unbind(buttons);
}

static unbind(buttons)
int buttons;
{
	event_action    *p;

	for (p = Bindings ; p ; p = p->next ) {
		if (p->buttons == buttons) {
			if (p->prev) p->prev->next = p->next;
			else	Bindings = p->next;
			if (p->next) p->next->prev = p->prev;
			free(p);
			break;
			}
		}
}
