#include "salem.h"
int    load_lincoln();
int	load_off();

char *lincoln_usage =	"lincoln file objname" ;
char *off_usage =	"off file objname colorfile" ; 

initialize_load()
{
        register_client("lincoln", load_lincoln, lincoln_usage );
	register_client("off", load_off, off_usage );
}

#define MAXVERTICESPERFACE 100
#define CONV(ptr,type,no,num,list)	if (ptr != 0) { \
	if ((((int) ptr) <= (num)) && (((int) ptr) > 0)) \
		(ptr) = list + ((long)(ptr) - 1);\
	else	{\
		ptr = NULL;\
		fprintf(stderr,"load_lincoln-%s[%d] has field out of range\n",type,no);\
		}\
	}

static FILE *simple_parse(argc, argv, usage, dirname)
int argc;
char **argv, *usage, *dirname;
{
	FILE *my_fopen();
	if (argc < 3)	{
		fprintf(stderr,"Usage: %s\n",usage);
		return(NULL);
		}
	return(my_fopen(argv[1],dirname));
}
	
/*load_lincoln: read a lincoln file, and add a new object to the Object list.*/

static lvertex_t	*vertex_list;
static ledge_t		*edge_list;
static lface_t		*face_list;

load_lincoln(argc,argv)
int	argc;
char	**argv;
{
	ldata_t		header;
	lvertex_t	*vp;
	ledge_t		*ep;
	lface_t		*fp;
	int 		i,j,k,ne,nv,nf,varr[MAXVERTICESPERFACE + 1], vn,fn;
	FILE		*file_in, *simple_parse();

	if ((file_in = simple_parse(argc,argv,lincoln_usage,LFILEDIR)) == NULL){
		error("load_lincoln");
		return;
		}

	fread(&header,sizeof(ldata_t),1,file_in);

	nv = header.nvertices ;
	vertex_list = N_NEW(nv,lvertex_t);
	fread(vertex_list,sizeof(lvertex_t),nv,file_in);

	ne = header.nedges ;
	edge_list = N_NEW(ne,ledge_t);
	fread(edge_list,sizeof(ledge_t),ne,file_in);

	nf = header.nfaces ;
	face_list = N_NEW(nf,lface_t);
	fread(face_list,sizeof(lface_t),nf,file_in);
	sl_create_object(argv[argc-1], header.nvertices, header.nfaces, argc, argv);

	for (i=0, vp=vertex_list; vp<vertex_list+header.nvertices; i++, vp++) {
		CONV(vp->e,"vertex",i,ne,edge_list);
		sl_vertex(vp->position[0],vp->position[1], vp->position[2]);
		}
	for (i=0, ep = edge_list; ep<edge_list+header.nedges; i++, ep++) {
		for (j = 0 ; j < 2 ; j++ )	{
			CONV(ep->f[j],"face",i,nf,face_list);
			CONV(ep->v[j],"vertex",i,nv,vertex_list);
			for (k = 0 ; k < 2 ; k++ )
				CONV(ep->e[j][k],"edge",i,ne,edge_list);
			}
		}
	for (i = 0, fp= face_list; fp < face_list+header.nfaces; i++, fp++) {
		CONV(fp->e,"face",i,ne,edge_list);
		ep = fp->e;
		vp =  ep-> v [ (ep->f[1] == fp) ? 0 : 1 ];
		for (j = 0; j < fp->order; j++) {
			varr[j]= (int) (vp - vertex_list);
			vn = (ep->v[0] == vp) ? 1 : 0 ;
			fn = (ep->f[0] == fp) ? 0 : 1 ;
			vp = ep->v[vn];
			ep = ep->e[fn][vn];
			}
		sl_color_face(fp->order, varr, fp->chars.color);
		}

	sl_close_object();
	fclose(file_in);
	free((char*)vertex_list);
	free((char*)edge_list);
	free((char*)face_list);
}

load_off(argc,argv)
int	argc;
char	**argv;
{
	int 		deg,i, nv,nf,ne, n_read,cind, v[MAXVERTICESPERFACE + 1];
	char		junk[MAXLINE];
	double 		rv[4];
	FILE		*simple_parse(), *my_fopen(), *file_in, *color_file;

	if ((file_in=simple_parse(argc,argv,off_usage,OFILEDIR))==NULL) {
		error("load_off");
		return;
		}

	if (argc == 4)
		color_file = my_fopen(argv[3],OFILEDIR);
	else	color_file = NULL;

	while(!fgets(junk, 127, file_in));
	if (2 > sscanf(junk,"%d%d%d",&nv,&nf,&ne))
		fprintf(stderr," misread nv, nf, ne maybe\n");

	sl_create_object(argv[2], nv, nf, argc, argv);

	for (i = 0 ; i < nv ; i++ )	{
		while(!fgets(junk, 127, file_in));
		if ((n_read = sscanf(junk,"%lf%lf%lf%lf",&rv[0],&rv[1],&rv[2],&rv[3])) < 3)
			fprintf(stderr,"potential problem point %d\n",i);
		if (n_read == 3) sl_vertex(rv[0],rv[1],rv[2]);
		else	sl_vertex_4(rv[0],rv[1],rv[2],(double) 1.0);
		}

	for (i = 0 ; i < nf ; i++ )	{
		while(!fgets(junk, 127, file_in));
		n_read = sscanf(junk,"%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d",
			&deg,&v[0],&v[1],&v[2],&v[3],&v[4],&v[5],&v[6],
			&v[7],&v[8],&v[9],&v[10],&v[11],&v[12],&v[13],
			&v[14],&v[15],&v[16],&v[17],&v[18]);
		if (n_read != (1+deg))
			fprintf(stderr,"potential problem polygon %d\n",i);
		if (color_file)	{
			while(!fgets(junk, 127, color_file));
			sscanf(junk,"%d",&cind);
			sl_color_face(n_read-1,v,cind);
			}
		else	sl_face(n_read-1,v);
		}

	fclose(file_in);
	if (color_file) fclose(color_file);
	else		sl_color_object();
	sl_close_object();
}
