#include "salem.h"

initialize_iris()
{
	extern Matrix Beziermatrix;

	signal(SIGINT,clean_exit);
	signal(SIGTERM,clean_exit);
	foreground();
	noport();
	winopen("");
	defbasis(BEZIER,Beziermatrix);
	patchbasis(BEZIER,BEZIER);

	qdevice(LEFTMOUSE);
	qdevice(MIDDLEMOUSE);
	qdevice(RIGHTMOUSE);

	qdevice(LEFTSHIFTKEY);
	qdevice(RIGHTSHIFTKEY);

	qdevice(F1KEY);
	qdevice(F2KEY);
	qdevice(F3KEY);
	qdevice(F4KEY);
	qdevice(F5KEY);
	qdevice(F6KEY);
	qdevice(F7KEY);
	qdevice(F8KEY);
	qdevice(F9KEY);
	qdevice(F10KEY);
	qdevice(F11KEY);
	qdevice(F12KEY);

	qdevice(TIMER0);

	qdevice(WINQUIT);
	qdevice(WINFREEZE);
	qdevice(WINTHAW);

	qdevice(INPUTCHANGE);
	qdevice(REDRAW);
	qdevice(PIECECHANGE);
}

iris_mouse_position()
{
	static Coord	last_x,last_y;
	static long     time_elapsed, current_time;

	current_time = getvaluator(TIMER0);
	time_elapsed = current_time - Last_time;
	if (time_elapsed < 0) Last_time = getvaluator(TIMER0);
	if (time_elapsed < Time_quantum) return FALSE;
	Last_time = current_time;

	Mouse.x = (Coord) getvaluator(MOUSEX);
	Mouse.y = (Coord) getvaluator(MOUSEY);
	Mouse.dx = 5*(Mouse.x-last_x)/time_elapsed;
	Mouse.dy = 5*(Mouse.y-last_y)/time_elapsed;
	last_x = Mouse.x;
	last_y = Mouse.y;

	return TRUE;
}

iris_event()
{
	long	device;
	short	data;
	Boolean retval = FALSE;

	while (qtest()) {
		device = qread(&data);
		switch (device) {
			case LEFTMOUSE: 
			case MIDDLEMOUSE: 
			case RIGHTMOUSE:
			case LEFTSHIFTKEY:
			case RIGHTSHIFTKEY:
			case F1KEY:
			case F2KEY:
			case F3KEY:
			case F4KEY:
			case F5KEY:
			case F6KEY:
			case F7KEY:
			case F8KEY:
			case F9KEY:
			case F10KEY:
			case F11KEY:
			case F12KEY:
				iris_buttons(device,data); break;
			case TIMER0:
				break;
			case WINQUIT:
				window_flag(data,WINDOW_EXISTS,FALSE); break;
			case WINFREEZE:
				window_flag(data,WINDOW_RUNNING,FALSE); break;
			case WINTHAW:
				window_flag(data,WINDOW_RUNNING,TRUE); break;
			case INPUTCHANGE:
				Input_window = find_window(data); break;
			case REDRAW:
			case PIECECHANGE:
				window_flag(data,WINDOW_REDRAW,TRUE); break;
			default:
				fatal("qread");
			}
		retval = TRUE;
		}
	return retval;
}

iris_buttons(device,value)
int	device, value;
{
	int button ;

	switch(device)	{
		case LEFTMOUSE:	    button = LEFTMOUSEBUTTON; 		  break;
		case MIDDLEMOUSE:   button = MIDDLEMOUSEBUTTON; 	  break;
		case RIGHTMOUSE:    button = RIGHTMOUSEBUTTON; 		  break;
		case LEFTSHIFTKEY:  button = LEFTSHIFTBUTTON; 		  break;
		case RIGHTSHIFTKEY: button = RIGHTSHIFTBUTTON; 		  break;
		default:	    button = F1BUTTON << (device-F1KEY);  break;
		}
	if (value) Mouse.buttonsdown|= button;
	else Mouse.buttonsdown&= ~button;
}
