#include "salem.h"
#define MAXPERFACE 25
#define NO_EDGE  -1
int *hash_table ;
int eused ;

lvertex_t 	*lvl;
ledge_t 	*lel;
lface_t 	*lfl;
ldata_t		*ldl;

vertex_t	*ovl;
polygon_t	*opl;

object_sizes(objname,nvr,nfr)
char *objname;
int *nvr, *nfr;
{
	object_t *objn;
	if (!(objn = get_object(objname)))      {
		fprintf(stderr,"object_sizes: no such object %s\n",objname);
		return(0);
		}
	*nvr = objn->n_vertices;
	*nfr = objn->n_polygons;
	return(1);
}

salem_to_lincoln(objname,lobjn)
char *objname;
lincoln_t *lobjn;
{

	int i,j,ii,fno,vno,nadj,adjacent[MAXPERFACE], edge_no[MAXPERFACE];
#define AD(i) adjacent[(nadj+(i))%nadj]
#define EN(i) edge_no[((i)+nadj)%nadj]
	ledge_t *et,*ep, *en ;
	object_t *objn;

	if (!(objn = get_object(objname)))	{
		fprintf(stderr,"salem_to_lincoln: no such object %s\n",objname);
		return(0);
		}

	ovl = objn->v_list;
	opl = objn->polygons;

	ldl = &lobjn->data;
	ldl->nvertices = objn->n_vertices;
	ldl->nfaces = objn->n_polygons;
	for (ldl->nedges = 0, i = 0 ; i < ldl->nfaces ; i++ )	
		ldl->nedges += opl[i].n_vertices;   /* very conservative */
	eused = 0;

	lvl = N_NEW(ldl->nvertices,lvertex_t);
	lel = N_NEW(ldl->nedges, ledge_t);
	lfl = N_NEW(ldl->nfaces, lface_t );

	lobjn->vlist = lvl ;
	lobjn->elist = lel;
	lobjn->flist = lfl ;

	for (i = 0 ; i < ldl->nvertices ; i++ )	{
		bcopy(ovl[i].position,lvl[i].position,4*sizeof(float));
		lvl[i].order = 0;
		lvl[i].e = NULL;
		}

	init_hash(ldl->nedges);

	for (i = 0 ; i < ldl->nfaces ; i++ )	{
		nadj = opl[i].n_vertices;
		if (nadj > MAXPERFACE)	
			ERR_RET_2("too many vertices on face %d\n",i);

		for (j = 0 ; j < nadj ; j++ )
			adjacent[j] = Vint(opl[i].v[j],ovl);

		for (j = 0 ; j < nadj ; j++ )
			edge_no[j] = check_hash(AD(j-1),AD(j),lobjn);

		lfl[i].order = nadj ;
		lfl[i].e = &lel[ abs(edge_no[0]) ];
		lfl[i].chars.color = opl[i].fastcolor;

		for (ii = 0 ; ii < nadj ; ii++ )	{
			et = &lel[ abs(EN(ii)) ] ;
			ep = &lel[ abs(EN(ii-1))];
			en = &lel[ abs(EN(ii+1)) ];
			fno = ((EN(ii) < 0)||((EN(ii)==0)&&(lel[0].f[0])))?1:0;
			vno = (et->v[0] == &lvl[AD(ii-1)]) ? 0 : 1 ;
			et->f[fno] = &lfl[i];
			et->e[fno][vno] = ep; et->e[fno][1-vno] = en; 
			}

		}

	ldl->nedges = eused;

	/* here we delete vertices of degree 0 */
	for (i = 0 ; i < ldl->nvertices ; i++ )
		if (lvl[i].order == 0)	{
			for (j = i ; j < (ldl->nvertices - 1) ; j++ )  
				bcopy(lvl[j+1],lvl[j], sizeof(lvertex_t));
			for (j = 0 ; j < ldl->nedges ; j++ ) {
				if (lel[j].v[0] >= &(lvl[i])) lel[j].v[0]-- ;
				if (lel[j].v[1] >= &(lvl[i])) lel[j].v[1]-- ;
				}
			ldl->nvertices-- ;
			i-- ;
			}

	free(hash_table);
	return(1);
}
		
int tsize; 

init_hash(nn)
int nn;
{
	int i;
	tsize = 2 * nn - 1;
	hash_table = N_NEW(tsize, int);
	for (i = 0 ; i < tsize  ; i++ ) hash_table[i] = NO_EDGE ;
}

#define BIGNUM 1
#define NUM2 0

check_hash(i,j)
int i,j;
{
	int tmpi, haddr ;

	if (i > j) { tmpi = i ; i = j ; j = tmpi ; }

	haddr = ( (i*ldl->nedges + j) * BIGNUM + NUM2) % tsize ;

	while (1)	{
		if (hash_table[haddr] == NO_EDGE) {
			hash_table[haddr] = eused;
			lel[eused].v[0] = &lvl[i];
			lel[eused].v[1] = &lvl[j];
			lvl[i].e = lel + eused ;
			lvl[j].e = lel + eused ;
			lvl[i].order++;
			lvl[j].order++;
			return(eused++);
			}

		else if (is_edge(lel[hash_table[haddr]],i,j))
			return(-hash_table[haddr]);
		else 	if (haddr-- == 0) haddr = tsize - 1 ;
		}
}

is_edge(e,i,j)
ledge_t e;
int i,j;
{
	int vi,vj;
	vi = Vint(e.v[0],lvl);
	vj = Vint(e.v[1],lvl);
	if ( ((vi == i) && (vj == j)) || ((vi == j) && (vj == i)) ) return(1);
	return(0);
}
