#include "salem.h"

int print_object();
int write_off();
int make_local();
int pick_local();

char PrHelp[] = "print_object objname";
char WrOffHelp[] = "write_off objname filename";
char MkLocalHelp[] = "make_local_neighborhood  objname vno vdepth nobj";
char PkLocalHelp[] = "pick_local_neighborhood  (always uses depth 3 on pick)";

initialize_print()
{
	register_client("print_object", print_object, PrHelp );
	register_client("write_off", write_off, WrOffHelp );
	register_client("make_local_neighborhood", make_local, MkLocalHelp );
	register_client("pick_local_neighborhood", pick_local, PkLocalHelp );
}

print_object(argc,argv)
int argc;
char **argv;
{

	int i,j;
	object_t *objn;

	if (argc < 2) ERR_RET(PrHelp);	

	if (!(objn = get_object(argv[1])))
		ERR_RET_2("print_object: no such object as",argv[1]);

	printf(" object %s has %d vertices and %d faces\n",objn->name,
		objn->n_vertices, objn->n_polygons);

	interactive(objn);
}

interactive(objn)
object_t *objn;
{
	int i,j;
	char instr[127],junk[20],*jp;

	while(1)	{
		printf(" > ");
		gets(instr);
		sscanf(instr,"%s%d%d",junk,&i,&j);
		for (jp = junk ; (*jp) && isspace(*jp) ; jp++ ) 	;
		switch(*jp)	{
			case 'v' :	show_vertex(i,i,objn); break;
			case 'V' :	show_vertex(i,j,objn); break;
			case 'f' :	show_face(i,i,objn); break;
			case 'F' :	show_face(i,j,objn); break;
			case 'a' :	show_adj(i,objn); break;
			case 'd' : 	dump(objn); break;
			case 'q' :
			case 'Q' :	return;
			default  :	help_msg();
					break;
			}
		}
}
		
help_msg()
{
	printf(" print_object: commands are \n");
	printf("\tv i to show vertex i\n");
	printf("\tV i j to show vertices i through j\n");
	printf("\tf i to show face i\n");
	printf("\tF i j to show faces i through j\n");
	printf("\ta i to show the faces adjacent to vertex i\n");
	printf("\td to dump the entire object\n");
	printf("\tq to exit\n");
	printf("\th to print this message\n");
}

dump(objn)
object_t *objn;
{
	int i,j;

	show_vertex(0, objn->n_vertices - 1, objn);
	show_face(0, objn->n_polygons - 1 , objn);
}

show_vertex(i,j,objn)
int i,j;
object_t *objn;
{
	int t;
	if (i < 0) i = 0;
	if (j >= objn->n_vertices) j = objn->n_vertices - 1;

	for (t = i ; t <= j ; t++ )
		printf(" vertex[ %d ] = ( %g , %g , %g , %g )\n",
		t, objn->v_list[t].position[0], objn->v_list[t].position[1],
		objn->v_list[t].position[2], objn->v_list[t].position[3]);
}

show_face(i,j,objn)
int i,j; 
object_t *objn; 
{ 
	int t,k;
	if (i < 0) i = 0; 
	if (j >= objn->n_polygons) j = objn->n_polygons - 1;

	for (t = i ; t <= j ; t++ )	{
		printf(" polygon %d has degree %d and involves vertices ( ",
			t,objn->polygons[t].n_vertices);
		for (k = 0 ; k < objn->polygons[t].n_vertices ; k++ )
			if (k != (objn->polygons[t].n_vertices - 1))
				printf(" %d ,",Vint(objn->polygons[t].v[k] , objn->v_list));
			else
				printf(" %d )",Vint(objn->polygons[t].v[k] , objn->v_list));
		printf("\n");
		}
}

find_adj(i,objn,adj)
int i, *adj;
object_t *objn;
{
	polygon_t	*fp;
	int 		j,t,k;
	if (i < 0) i = 0; 

	t = 0;
	for (k = 0, fp = objn->polygons; k < objn->n_polygons ; k++, fp++ ) 
		for (j = 0 ; j < fp->n_vertices ; j++ )
			if (Vint(fp->v[j],objn->v_list) == i)
				adj[t++] = k;

	return(t);
}

show_adj(i,objn)
int i;
object_t *objn;
{
	int k, t, adj[MAXFACEORDER];
	t = find_adj(i,objn,adj);
	printf(" vertex %d is adjacent to faces ( ",i);
	for (k = 0 ; k < t ; k++ )	printf(" %d , ",adj[k]);
	printf(")\n");	
}

write_off(argc,argv)
int argc;
char **argv;
{
	int 		i,j;
	object_t 	*objn;
	vertex_t	*vp;
	polygon_t	*fp;
	FILE *fd;

	if (argc < 3) ERR_RET(WrOffHelp);	

	if (!(objn = get_object(argv[1])))
		ERR_RET_2("write_off: no such object as",argv[1]);

	if (!(fd = fopen(argv[2],"w")))
		ERR_RET_2("write_off: cannot open file ",argv[2]);

	fprintf(fd," %d %d 18\n", objn->n_vertices, objn->n_polygons);

	for (i = 0, vp = objn->v_list; i < objn->n_vertices ; i++ , vp++ )
		fprintf(fd," %g %g %g %g\n", vp->position[0], vp->position[1], 
			vp->position[2], vp->position[3] );

	for (i = 0, fp = objn->polygons ; i < objn->n_polygons; i++, fp++) {
		fprintf(fd," %d ",fp->n_vertices);
		for (j = 0 ; j < fp->n_vertices; j++ )
			fprintf(fd," %d ",Vint(fp->v[j], objn->v_list));
		fprintf(fd," \n");
		}
	fclose(fd);
}

print_lincoln(lobj)
lincoln_t *lobj;
{
	ldata_t 	*ldl = &lobj->data;
	lvertex_t 	*lvl =  lobj->vlist ;
	ledge_t 	*lel =  lobj->elist ;
	lface_t 	*lfl =  lobj->flist ;
	int 		i;

	printf(" lincoln file of %d vertices %d edges %d faces\n",
		ldl->nvertices, ldl->nedges, ldl->nfaces);

	for (i = 0 ; i < ldl->nvertices ; i++ )
		printf(" vertex %d = ( %g, %g, %g ) edge %d order %d\n",
			i,lvl[i].position[0], lvl[i].position[1], 
			lvl[i].position[2],Vint(lvl[i].e,lel),lvl[i].order);

	for (i = 0 ; i < ldl->nedges; i++ )
		printf(" edge %d joins ( %d , %d), adjacencies ( %d , %d) on face %d ( %d , %d ) on face %d\n",
			i,Vint(lel[i].v[0],lvl),Vint(lel[i].v[1],lvl),
			Vint(lel[i].e[0][0],lel),Vint(lel[i].e[0][1],lel),
			Vint(lel[i].f[0],lfl), Vint(lel[i].e[1][0],lel),
			Vint(lel[i].e[1][1],lel),Vint(lel[i].f[1],lfl));

	for (i = 0 ; i < ldl->nfaces; i++ )
		printf(" face %d has edge %d and order %d\n",
			i,Vint(lfl[i].e,lel),lfl[i].order);
}

make_local(argc,argv)
int argc;
char **argv;
{
	int 		vval, vdepth, i, j, k, t, adj[MAXFACEORDER], nfr, nvr;
	int		*vertices_doing, vd;
	int		*vertices_to_do, vtd;
	polygon_t	*pp;
	int 		rv[100];
	object_t 	*objn;
	int 		*faces, *vertices, *vert_nos;
	vertex_t	*vp;

	if (argc < 5) ERR_RET(MkLocalHelp);

	if (!(objn = get_object(argv[1])))
		ERR_RET_2("print_object: no such object as",argv[1]);

	faces = N_NEW(objn->n_polygons, int);
	vertices = N_NEW(objn->n_vertices, int);
	vert_nos = N_NEW(objn->n_vertices, int);
	vertices_doing = N_NEW(objn->n_vertices, int);
	vertices_to_do = N_NEW(objn->n_vertices, int);
	
	vertices_to_do[0] = atoi(argv[2]);
	vdepth = atoi(argv[3]);
	vtd = 1;
	
	for ( ; vdepth > 0 ; vdepth-- )	{
		for (i = 0 ; i < vtd ; i++ )	
			vertices_doing[i] = vertices_to_do[i];
		vd = vtd; 
		vtd = 0;
		for (i = 0 ; i < vd ; i++ )	{
			t = find_adj(vertices_doing[i], objn, adj);

			for (k = 0 ; k < t ; k++ )	{
				pp = &objn->polygons[adj[k]] ;
				for (j = 0 ; j < pp->n_vertices ; j++ )	{
					vval = Vint(pp->v[j],objn->v_list);
					if (vertices[vval] == 0)	{
						vertices_to_do[vtd++] = vval;
						vertices[vval] = 1;
						}
					}
				}

			for (k = 0 ; k < t ; k++ )
				faces[adj[k]] = 1;
			}
		}

	sl_create_object(argv[4], 0, 0, argc, argv);

	for (i = nvr = 0 ; i < objn->n_vertices ; i++ )
		if (vertices[i] == 1) {
			vert_nos[i] = nvr++;
			vp = &objn->v_list[i] ;
			sl_vertex( (double) vp->position[0] ,
			    (double)vp->position[1],(double)vp->position[2]);
			}

	for (i = nfr = 0 ; i < objn->n_polygons ; i++ )
		if (faces[i] == 1) 	{
			pp = &objn->polygons[i] ;
			for (j = 0 ; j < pp->n_vertices ; j++ )
				rv[j] = vert_nos[Vint(pp->v[j], objn->v_list)];
			sl_color_face(pp->n_vertices, rv, pp->fastcolor);
			}

	sl_close_object();

	free(faces);
	free(vertices);
	free(vert_nos);
	free(vertices_doing);
	free(vertices_to_do);

	return(1);
}

pick_local(argc,argv)
int argc;
char **argv;
{
	int		vn, vd	= 3;
	polygon_t	*pp;
	object_t 	*objn;
	char		com[MAXLINE], cobjname[MAXLINE];
	Matrix		M;

	sl_command("pick");

	if (Selected.object == NULL)
		ERR_RET("pick_local: bad pick no such object as");
	objn = Selected.object;
	emu_copy_matrix(M,Selected.object->v);

	if ( (Selected.polygon < 0) || (Selected.polygon > objn->n_polygons))
		ERR_RET("pick_local: bad pick polygon number out of range");

	pp = &objn->polygons[Selected.polygon];

	if ( (Selected.vertex < 0) || (Selected.vertex > pp->n_vertices) )
		ERR_RET("pick_local: bad pick -- vertex number out of range");
	
	vn = Vint(pp->v[Selected.vertex],objn->v_list);


	sprintf(com,"make_local_neighborhood %s %d %d %s",
		objn->name,vn,vd,objn->name);
	sl_command(com);

	sl_current_object(cobjname);
	sprintf(com,"pick %s",cobjname);
	sl_command(com);

	Selected.object->shading = objn->shading;

	sl_transform(M);
}
