#include	"Polyhedra_bogus.h"
#include	"Polyhedra_poly.h"
#include 	"sl_constants.h"
#include	"sli.h"

static short **facelist();
#define		SPLIT(s)	getmfields(s, ptr, sizeof ptr/sizeof ptr[0])

poly_read(p, file_name)
	register Polyhedron *p;
	char *file_name;
{
	char buf[128];
	char *s, *nexts;
	int i, j, k;
	short *sp;
	char *ptr[10];

	strcpy(buf,file_name);
	if (poly_ifield(buf))
		return(1);
	p->number = atoi(poly_field("number"));
	p->name = strdup(poly_field("name"));
	p->comment = strdup(poly_field("comment"));
	p->symbol = strdup(poly_field("symbol"));
	p->dual = strdup(poly_field("dual"));
	p->sfaces = strdup(poly_field("sfaces"));
	p->svertices = strdup(poly_field("svertices"));
	s = poly_field("vertices");
	if(p->nvertices = atoi(s)){
		p->vertices = (Vertex *)malloc(p->nvertices*sizeof(Vertex));
		for(nexts = s; *nexts++;);
		if(SPLIT(s) == 2)
			p->nnet = atoi(ptr[1]);
		else
			p->nnet = p->nvertices;
		for(i = 0, s = nexts; *s; s = nexts, i++){
			for(nexts = s; *nexts++;);
			if(SPLIT(s) != 3){
				fprintf(stderr, "bad vertex in file %s (next line is %s)\n", buf, nexts);
				return(1);
			}
			rdvalue(&p->vertices[i].x, ptr[0]);
			rdvalue(&p->vertices[i].y, ptr[1]);
			rdvalue(&p->vertices[i].z, ptr[2]);
		}
		if(i != p->nvertices){
			fprintf(stderr, "%s: expected %d vertices, read %d\n", buf,
				p->nvertices, i);
			return(1);
		}
	}
	p->maxface = 0;
	p->nface = 0;
	p->net = facelist(p, "net", buf);
	p->solid = facelist(p, "solid", buf);
	s = poly_field("hinges");
	if(p->nhinges = atoi(s)){
		p->hinges = (Hinge *)malloc(p->nhinges*sizeof(Hinge));
		while(*s++);
		for(i = 0; *s; s = nexts, i++){
			for(nexts = s; *nexts++;);
			if(SPLIT(s) != 5){
				fprintf(stderr, "%s: bad hinge line\n", buf);
				return(1);
			}
			p->hinges[i].f1 = atoi(ptr[0]);
			p->hinges[i].s1 = atoi(ptr[1]);
			p->hinges[i].f2 = atoi(ptr[2]);
			p->hinges[i].s2 = atoi(ptr[3]);
			rdvalue(&p->hinges[i].d, ptr[4]);
		}
		if(i != p->nhinges){
			fprintf(stderr, "%s: expected %d hinges, read %d\n", buf,
				p->nhinges, i);
			return(1);
		}
	}
	s = poly_field("dihedral");
	if(p->ndih = atoi(s)){
		p->dih = (Dihedral *)malloc(p->ndih*sizeof(Dihedral));
		while(*s++);
		for(i = 0; i < p->ndih; s = nexts, i++){
			for(nexts = s; *nexts++;);
			k = SPLIT(s);
			if(k == 4){
				rdvalue(&p->dih[i].s, ptr[2]);
				rdvalue(&p->dih[i].c, ptr[3]);
				p->dih[i].sc = 1;
				k -= 2;
			} else
				p->dih[i].sc = 0;
			if(k != 2){
				fprintf(stderr, "%s: bad dihedral count\n", buf);
				return(1);
			}
			k = p->dih[i].count = atoi(ptr[0]);
			rdvalue(&p->dih[i].d, ptr[1]);
			s = nexts;
			if(k){
				sp = p->dih[i].fe = (short *)malloc(2*k*sizeof(short));
				for(j = 0; j < k; s = nexts, j++){
					for(nexts = s; *nexts++;);
					if(SPLIT(s) != 2){
						fprintf(stderr, "%s: bad face-edge\n", buf);
						return(1);
					}
					*sp++ = atoi(ptr[0]);
					*sp++ = atoi(ptr[1]);
				}
			} else
				p->dih[i].fe = 0;
		}
		if(i != p->ndih){
			fprintf(stderr, "%s: expected %d dihedrals, read %d\n", buf,
				p->ndih, i);
			return(1);
		}
	}
	s = poly_field("dih");
	if(p->ndgoo = atoi(s)){
		p->dgoo = (Hinge *)malloc(p->ndgoo*sizeof(Hinge));
		while(*s++);
		for(i = 0; *s; s = nexts, i++){
			for(nexts = s; *nexts++;);
			if(SPLIT(s) != 4){
				fprintf(stderr, "%s: bad dgoo line\n", buf);
				return(1);
			}
			p->dgoo[i].f1 = atoi(ptr[0]);
			p->dgoo[i].s1 = atoi(ptr[1]);
			p->dgoo[i].f2 = atoi(ptr[2]);
			rdvalue(&p->dgoo[i].d, ptr[3]);
		}
		if(i != p->ndgoo){
			fprintf(stderr, "%s: expected %d dgoo, read %d\n", buf,
				p->ndgoo, i);
			return(1);
		}
	}
	return(0);
}

rdvalue(v, s)
	Value *v;
	register char *s;
{
	v->v = atof(s);
	while(*s && (*s != '['))
		s++;
	if(*s == '['){
		char *ss = ++s;

		while(*s && (*s != ']'))
			s++;
		*s = 0;
		v->code = strdup(ss);
	} else
		v->code = 0;
}

static short **
facelist(p, ss, file)
	Polyhedron *p;
	char *ss, *file;
{
	char *s, *nexts;
	char *ptr[100];
	int i, j, k, n;
	short **ret;

	s = poly_field(ss);
	if(atoi(s) == 0)
		return((short **)0);
	nexts = strchr(s, 0)+1;
	if(SPLIT(s) != 2){
		fprintf(stderr, "%s: bad count line for '%s'\n", file, ss);
		return((short **)0);
	}
	n = atoi(ptr[0]);
	p->maxface = atoi(ptr[1]);
	if(p->nface){
		if(p->nface != n){
			fprintf(stderr, "%s: nface disagreement: %d vs %d\n", file,
				p->nface, n);
			return((short **)0);
		}
	} else
		p->nface = n;
	ret = (short **)malloc(p->nface*sizeof(short *));
	s = nexts;
	for(i = 0; *s && (i < p->nface); i++, s = nexts){
		nexts = strchr(s, 0)+1;
		SPLIT(s);
		k = atoi(ptr[0]);
		ret[i] = (short *)malloc((k+1)*sizeof(short));
		for(j = 0; j <= k; j++)
			ret[i][j] = atoi(ptr[j]);
	}
	return(ret);
}

int
poly_name(s,real_name)
char	*s;
char	*real_name;
{
	FILE	*ixfp;
	char	buf[BUFSIZ],first_match[BUFSIZ],*lp,*rp;
	int	ix = -1;

	if ((ixfp = fopen(POLY_INDEX,"r")) == NULL)
		perror(POLY_INDEX);
	else {
		sprintf(real_name,"%s/",POLYDIR);
		while (fgets(buf,sizeof(buf),ixfp)) {
			lp = strtok(buf," \t");
			rp = strtok((char*)0," \t");
			if (strncmp(s,lp,strlen(s)) == 0) {
				if (ix >= 0) {
					fprintf(stderr,"%s is ambiguous.  try one of:\n",s);
					fprintf(stderr,"%s\n",first_match);
					ix = -2;
				}
				if (ix == -2) fprintf(stderr,"%s\n",lp);
				else {
					strcpy(first_match,lp);
					strcat(real_name,lp);
					ix = atoi(rp);
				}
			}
		}
		fclose(ixfp);
	}
	return (ix >= 0);
}
