#include "salem.h"

#define		NDIM		3

/****** macros *****/
#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))
#define SQR(a) ((a)*(a))
#define HASHSIZE	1013
#define	MIN_EDGE	(.01)
#define	EPSILON	(.0001)
#define	K_coeff	(1.0)
/*#define N_NEW(n,t) (t*)malloc(sizeof(t)*(n))*/

/****** types *****/
typedef struct pointN_t	{
	Coord	x[NDIM];
} pointN_t;

typedef struct node_t {
	int				id;
	pointN_t		pos;
	int				degree;
	char		*name;
	struct node_t	*hash_link;
	struct edge_t	*edge_list;
	float			energy;
} node_t;

typedef struct edge_t {
	struct node_t	*n0,*n1;
	char		*name;
	float			length;
	struct edge_t	*next0,*next1;
} edge_t;

typedef struct graph_t {
	char		*name;
	int		N_nodes,N_edges;
	node_t		**nodelist;
	edge_t		***Adj;
	double 		node_color_scale;
	node_t		*hashtable[HASHSIZE];
	int		Move;
	float		**K;		/* spring length	*/
	float		**L;		/* spring strength	*/
	float		***t;		/* N_nodes X N_nodes X NDIM */
	float		**sum_t;	/* N_Nodes X NDIM	*/
} graph_t;

/****** forward *****/
int	htdag3(int, char**);
int	htset (int, char**);
graph_t	*read_graph(int, char**);
graph_t	*new_graph(int, char**);
node_t	*bind_node();
node_t	*new_node();
char *new_node_obj();
edge_t	*bind_edge();
edge_t	*new_edge();
char *new_edge_obj();

/****** globals *****/
static pointN_t		zeropt;
