#include "sli.h"
#define MAXDEGREE_DEFAULT	12
#include "sl_lincoln.h"

int create_hierarchy();
int full_hierarchy();
char HierHelp[] = "create_hierarchy objname newobjname [dmaxdegree] [vertices to remove]";
char FullHierHelp[] = "full_hierarchy objname [maxdegree]";

initialize_hierarchy()
{
	register_client("create_hierarchy", create_hierarchy,HierHelp );
	register_client("full_hierarchy", full_hierarchy,FullHierHelp );
}

int 
icompfun(ii, jj)
int *ii, *jj;
{
	if ((*ii) > (*jj)) return(1);
	if ((*jj) > (*ii)) return(-1);
	return(0);
}


int		*dead_vertex_list, *dead_edge_list, *dead_face_list;
int		ndead_vertices, ndead_edges, ndead_faces;
int 		faces_used, edges_used;
lvertex_t       *lvl;
ledge_t         *lel;
lface_t         *lfl;
ldata_t         *ldl;
int 		ld_dead_vert, ld_dead_fac, ld_dead_cface;

full_hierarchy(argc,argv)
int argc;
char **argv;
{
	char 		rootname[MAXLINE], oldname[MAXLINE], newname[MAXLINE];
	char		cmd_buf[MAXLINE], *av[3];
	int		i,nvr,nfr;
	int		maxdegree = MAXDEGREE_DEFAULT; 

	if (argc < 2)	ERR_RET(FullHierHelp);
	if (argc == 3)	{
			maxdegree = atoi(argv[2]);
			if ((maxdegree < 3) || (maxdegree > 1000))
				maxdegree = MAXDEGREE_DEFAULT;
			}
	strcpy(rootname,argv[1]);
	strcpy(newname,rootname);
	object_sizes(newname,&nvr,&nfr);
	for ( i = 1 ; nvr > 3 ; i++ )	{
		strcpy(oldname,newname);
		sprintf(newname,"%s.%d",rootname,i);
		sprintf(cmd_buf,"create_hierarchy %s %s d%d",
			oldname,newname,maxdegree);
		if (!parse_entire_string(cmd_buf)) return(0);
		object_sizes(newname,&nvr,&nfr);
		printf("object %s %d vertices and %d faces\n",newname,nvr,nfr);
		}
	return(1);
}

create_hierarchy(argc,argv)
int argc;
char **argv;
{
	lincoln_t 	Lobj, *lobj;
	lvertex_t       *lvp;
	ledge_t		*e;
	lface_t         *lfp;
	int 		i, *isv, isetsz;
	int		maxdegree = MAXDEGREE_DEFAULT; 
	int 		rv[3], j, vno, fno, ded, faceno;

	lobj = &Lobj;
	if (argc < 3) ERR_RET(HierHelp);
	if (!salem_to_lincoln(argv[1],lobj)) return(0);

	ldl = &lobj->data;
	lvl =  lobj->vlist ;
       	lel =  lobj->elist ;
	lfl =  lobj->flist ;

	isv = N_NEW(1+ldl->nvertices, int);

	if ((argc > 3) && (argv[3][0] != 'd'))	{
		for (i = 3 ; i < argc ; i++ ) {
			isv[i-3] = atoi(argv[i]);
			if ( (isv[i-3] < 0) || (isv[i-3] >= ldl->nvertices)) 
				ERR_RET_2("vertex %d is out of range",isv[i-3]);
			}
		isetsz = i - 3;
		}
	else	{
		if (argc == 4)	{
			maxdegree = atoi(&argv[3][1]);
			if ((maxdegree < 3) || (maxdegree > ldl->nvertices))
				maxdegree = MAXDEGREE_DEFAULT;
			}
		isetsz = find_independent_set(lobj,isv,maxdegree);
		}

	if (isetsz < 1) return(0);

	ndead_vertices = ndead_edges = ndead_faces = 0;
	dead_vertex_list 	= N_NEW(1 + isetsz, int);
	dead_edge_list 		= N_NEW(1 + 3*isetsz, int);
	dead_face_list 		= N_NEW(1 + 2*isetsz, int);

	for (i = 0 ; i < isetsz ; i++ )
		if (!remove_apex_vertex(&lobj->vlist[isv[i]],lobj))
			return(0);

	qsort(dead_vertex_list, ndead_vertices, sizeof(int), icompfun);
	qsort(dead_edge_list, ndead_edges, sizeof(int), icompfun);
	qsort(dead_face_list, ndead_faces, sizeof(int), icompfun);

	dead_vertex_list[ndead_vertices]    = 
		dead_edge_list[ndead_edges] = 
		dead_face_list[ndead_faces] = -1;

	ld_dead_vert = ld_dead_fac = ld_dead_cface = 0;

	if (0 == sl_create_object(argv[2], lobj->data.nvertices - ndead_vertices, 
			lobj->data.nfaces - ndead_faces, argc, argv) )
		return(0);

	for (i=0,lvp= &lvl[0];i<lobj->data.nvertices-ndead_vertices;i++,lvp++) {
		vno = i + ld_dead_vert;
		while (vno == dead_vertex_list[ld_dead_vert] )	{
			ld_dead_vert++;
			vno++;
			lvp++;
			}
		sl_vertex( (double) lvp->position[0], (double)lvp->position[1],
			(double)lvp->position[2]);
		}

	for (i=0,lfp = &lfl[0]; i<lobj->data.nfaces-ndead_faces; i++, lfp++ )  {

		for (faceno = i + ld_dead_fac ; 
			faceno == dead_face_list[ld_dead_fac] ; 
				ld_dead_fac++ , faceno++ , lfp++ )		;

		rv[0] = lfp->order;
		e = lfp->e;
		rv[0] = Vint(e->v[0],lvl);

		rv[1] = Vint(e->v[1],lvl);
		fno = (e->f[0] == lfp) ? 0 : 1;
		e = e->e[fno][1];
		vno = (Vint(e->v[0],lvl) == rv[1]) ? 1 : 0;
		rv[2] = Vint(e->v[vno],lvl);
		for (j = 0 ; j < lfp->order ; j++ ) {
			ded = 0;
			while((dead_vertex_list[ded] < rv[j]) && (ded < ndead_vertices))
				ded++;
			rv[j] -= ded;
			}
		sl_color_face(3,rv,lfp->chars.color);
		}
	sl_close_object();

	free(isv);
	free(dead_vertex_list);
	free(dead_edge_list);
	free(dead_face_list);
	free(lvl);
	free(lel);
	free(lfl);
	return(1);
}

#define NMAX 25
ledge_t 	*boundary_edge[NMAX], *peak_edge[NMAX];
lvertex_t 	*boundary_vertex[NMAX], *peak;
lface_t		*peak_face[NMAX]; /* faces along the peak which are recycled*/
int 		 boundary_size;

#define BV(i)	boundary_vertex[(i)%boundary_size]
#define BE(i)	boundary_edge[(i)%boundary_size]
#define BF(i)	boundary_face[(i)%boundary_size]

struct new_face	{
	lvertex_t	 *v[3];
	ledge_t	 	*e[3];
	}	new_faces[NMAX];


remove_apex_vertex(v)
lvertex_t *v;
{
	faces_used = 0; 
	edges_used = 0;
	trace_vertex(v);	/* fill boundary fields, clear peak fields*/
	triangulate(0, 1, boundary_size - 1, BE(0));
	if (!make_new_faces_and_edges())	return(0);

		/* Remove peak vertex, Last 2 peak faces, last 3 peak edges */
	dead_vertex_list[ndead_vertices++] = Vint(peak, lvl) ;
	dead_edge_list[ndead_edges++]=Vint(peak_edge[boundary_size-3],lel);
	dead_edge_list[ndead_edges++]=Vint(peak_edge[boundary_size-2],lel);
	dead_edge_list[ndead_edges++]=Vint(peak_edge[boundary_size-1],lel);
	dead_face_list[ndead_faces++]=Vint(peak_face[boundary_size-2],lfl);
	dead_face_list[ndead_faces++]=Vint(peak_face[boundary_size-1],lfl);

	return(1);
}

trace_vertex(v)
lvertex_t *v;
{
	int i, fno, vno, bfno;
	peak = v;
	if (peak->order > NMAX)	ERR_RET("degree too high");
	boundary_size = peak->order;
	peak_edge[0] = peak->e;
	fno = 0;
	for (i = 0 ; i < boundary_size ; i++ )	{
		peak_face[i] = peak_edge[i]->f[fno];
		vno = (peak == peak_edge[i]->v[0])? 0 : 1;
		BV(i) = peak_edge[i]->v[1-vno] ;
		BE(i) = peak_edge[i]->e[fno][1-vno];
		if (i != (boundary_size - 1))	{
			peak_edge[i+1] = peak_edge[i]->e[fno][vno];
			fno = (peak_edge[i+1]->f[0] == peak_face[i]) ? 1 : 0 ;
			}
		peak_edge[i]->f[0] = peak_edge[i]->f[1] = NULL;
		bfno =  (BE(i)->f[0] == peak_face[i]) ? 0 : 1 ;
		BE(i)->f[bfno] = NULL;
		BE(i)->e[bfno][0] = NULL;
		BE(i)->e[bfno][1] = NULL;
		}
}

triangulate(a,first,length,edgein)
int a, first, length;
ledge_t *edgein;
{
	ledge_t *e0, *e1, *add_edge();
	int i, truesign, candidate = 1;

	if (length < 2)	
		ERR_RET(" trying to create on a length 2 chain");

	if (length == 2)	{ /* already a triangle */
		add_face(a,first,first+1,edgein,BE(first),BE(first+1));
		return;
		}
	truesign = DET4(BV(a), BV(first), BV(first+1), peak);
	for (i = 2 ; i < length ; i++ )
		if (DET4(BV(a), BV(first), BV(first+candidate), BV(first+i)) 
				== truesign)
			candidate = i;

	if ((candidate != 1) && (candidate != (length - 1))) {
		e0 = add_edge(first, first+candidate);
		e1 = add_edge(a, first + candidate);
		add_face(a,first,first+candidate,edgein,e0,e1);
		triangulate(first+candidate, first, candidate, e0);
		triangulate(a, first+candidate, length - candidate, e1);
		}
	else if (candidate != 1)	{ /* candidate = (length -1 ) */
		e0 = add_edge(first, first+candidate);
		add_face(a,first,first+candidate, edgein,e0,BE(first+length-1));
		triangulate(first+candidate, first, candidate, e0);
		}
	else	{ /* candidate = 1 */
		e0 = add_edge(a, first + 1);
		add_face(a, first, first+1, edgein, BE(first), e0);
		triangulate(a, first+1, length - 1, e0);
		}
}

ledge_t *
add_edge(i,j)
int i,j;
{
	ledge_t *eret;
	eret = peak_edge[edges_used++];
	eret->v[0] = BV(i);
	eret->v[1] = BV(j);
	return(eret);
}

add_face(i,j,k,ei,ej,ek)
int i,j,k;
ledge_t *ei, *ej, *ek;
{
	struct new_face *fr;
	fr = &new_faces[faces_used++];
	fr->v[0] = BV(i);
	fr->v[1] = BV(j);
	fr->v[2] = BV(k);
	fr->e[0] = ei;
	fr->e[1] = ej;
	fr->e[2] = ek;
}

make_new_faces_and_edges()
{
	int i,j, vno, fno;
	lface_t *f;
	ledge_t *ne;
	for (i = 0 ; i < boundary_size - 2 ; i++ )	{
		f = peak_face[i];
		f->chars.color = -1;
		f->order = 3;
		f->e = new_faces[i].e[0];
		for (j = 0 ; j < 3 ; j++ )	{
			ne = new_faces[i].e[j];
			if (ne->f[0] == NULL)	
				if (ne->f[1] == NULL)	{
					ne->v[0] = new_faces[i].v[j];
					ne->v[1] = new_faces[i].v[(j+1)%3];
					fno = 0;
					vno = 0;
					}
				else	{
					fno = 0;
					vno = (ne->v[0] == new_faces[i].v[j]) ? 0 : 1;
					}
			else	if (ne->f[1] == NULL)	{
				fno = 1;
				vno = (ne->v[0] == new_faces[i].v[j]) ? 0 : 1;
				}
			else 	{
				printf("problem in make_new_faces_and_edges");
				printf(" neither f0 or f1 are NULL\n");
				return(0);
				}
			ne->f[fno] = f;
			ne->e[fno][vno] = new_faces[i].e[(j+2)%3];
			ne->e[fno][1-vno] = new_faces[i].e[(j+1)%3];
			}
		}
	return(1);
}

DET4(a,b,c,d)
lvertex_t *a,*b,*c,*d;
{
	float m[3][3], rv ;
	float DET3();
	int i;
	for (i = 0 ; i < 3 ; i++ )	{
		m[0][i] = a->position[i] - d->position[i] ; 
		m[1][i] = b->position[i] - d->position[i] ; 
		m[2][i] = c->position[i] - d->position[i] ; 
		}
	rv = DET3(m);
/* was 1E-7 but didn't catch everything */
	return(rv > -1E-10);
}

float
DET3(m)
float m[][3];
{
	float plus, minus;
	plus = m[0][0]*m[1][1]*m[2][2] + m[0][1]*m[1][2]*m[2][0] +
			m[0][2]*m[1][0]*m[2][1] ;
	minus = m[0][0]*m[1][2]*m[2][1] + m[0][1]*m[1][0]*m[2][2] +
			m[0][2]*m[1][1]*m[2][0] ;
	return (plus - minus);
}
