/*=====================================================================
    structs.h

          defines all global variables and structures.              

  ======================================================================*/

#include "sli.h"
typedef int FLAG;
#define X 0
#define Y 1
#define Z 2

/* Define structures for vertices, edges and faces */
struct tvertex {
	double v[3];
          int vnum, order;
          struct tedge *duplicate;
          FLAG mark;
          struct tvertex *next, *prev;
          };

struct tedge {
          struct tface *adjface[3];
          struct tvertex *endpts[2];
          FLAG deleted;
          struct tedge *next, *prev;
          };

struct tface {
          struct tedge *edg[3];
          struct tvertex *vert[3];
          FLAG visible;
          double p[3];
          struct tface *next, *prev;
          };

struct rvertex {
	double v[3];
	int order ;
          };

struct rface {
          int vert[3];
          };

/* Define flags */
#define ACTIVE   1
#define DELETED  1
#define VISIBLE  1
#define MARKED   1

/* Global variable definitions */
#ifdef global
struct tvertex *vertices ;
struct tedge   *edges    ;
struct tface   *faces    ;
struct tvertex **bad_vertices, **duplicate_vertices ;
struct tedge **bad_edges, **adj_2_edges ;
struct tface **bad_faces ;
int bad_vertex_no, bad_edge_no, adj_2_edge_no, bad_face_no, duplicate_vertex_no;

#else
extern struct tvertex *vertices;
extern struct tedge   *edges;
extern struct tface   *faces;
extern struct tvertex **bad_vertices, **duplicate_vertices ;
extern struct tedge **bad_edges, **adj_2_edges ;
extern struct tface **bad_faces ;
extern int bad_vertex_no , bad_edge_no , adj_2_edge_no , bad_face_no,
	duplicate_vertex_no ;

#endif
