#define DEFINE_GLOBALS
#include "2D-DT_defines.h"

int delaunay();

initialize_delaunay()
{
	register_client("del_tri", delaunay, "del_tri n [objname] [nsteps]" );
}

/*			TICK STUFF THAT HAS TO BE INTEGRATED
int delaunay_tick();

typedef struct	user_tick	{
	int nv;
	int number_steps;
	int curstep;
	double	*zmove;
	} user_tick ;

#define DEFAULT_NUMBER_STEPS  5000

int 
delaunay_tick(oname,ut)
char *oname, *ut;
{
	int j;

	double 		*zmove;
	int 		nv, number_steps, *curstep;
	user_tick	*user_stuff;

	user_stuff = (user_tick *) ut ;
	zmove = user_stuff->zmove ;
	nv = user_stuff->nv;
	number_steps = user_stuff->number_steps ;
	curstep = &user_stuff->curstep ;
	sl_reopen_object(oname);
	if ((*curstep) == number_steps )	{
		for (j = 0 ; j < nv ; j++ )
			sl_move_vertex(j, (double) 0.0, (double) 0.0,
				 -number_steps * zmove[j]);
		(*curstep) = 0;
		}
	else	{
		for (j = 0 ; j < nv ; j++ )
			sl_move_vertex(j, (double) 0.0, (double) 0.0, zmove[j]);
		*curstep++;
		}
}
*/

int
delaunay(argc,argv) 
int argc;
char **argv;
{
	EDGE_PTR edge;
	int i, n, ns, rows, but;
    	double curmax;
	int j,nf, fcount;

	if (argc < 3) ERR_RET("delaunay.2d NN objectname number_steps");

	n = atoi(argv[1]); if ((n < 4) || (n > 1000000)) n = 100;
	ns = atoi(argv[3]); if ((ns < 10) || (ns > 10000)) ns = 5000;
	delete_all_edges();

	my_alloc(va, struct VERTEX, n );
    	srand(1023);
	curmax = 1.0;
	for (i = n; i>0;) {
		curmax *= exp(log(drand())/(double) i);
	    	i--;
	    	VX(i) = curmax; VY(i) = drand();
		}

	sl_create_object(argv[2], n, 2*n, argc, argv);

	num_vertices = n + 1;
	num_edgeparts = 12*num_vertices;
	stack_size = num_edgeparts/2;
	my_alloc(vp, VERTEX_PTR, num_vertices);
	my_alloc(org, VERTEX_PTR, num_edgeparts);
	my_alloc(next, EDGE_PTR, num_edgeparts);
	my_alloc(my_stack.elts, EDGE_PTR , num_edgeparts);
	my_alloc(see, char, num_edgeparts);

       	rows = (int) (0.5 + sqrt((double) n / log((double) n)));
	build_delaunay_triangulation(n-1, &edge, rows);

	output_voronoi_diagram(edge,n);

/*		MORE TICK STUFF 
	user_data = (user_tick *) (char*)N_NEW(2, user_tick ); /* make this 2 lines?
	user_data->nv = n;
	user_data->number_steps = ns;
	user_data->curstep = 0;
	user_data->zmove  = N_NEW(user_data->nv,double);
	sl_register_tick(delaunay_tick, user_data);
	for (j = 0 ; j < user_data->nv ; j++ )	{
		double x,y,z;	/* move these elsewhere 
		sl_get-vertex(j,&x,&y,&z);
		user_data->zmove[j] = x*x + y*y; 
		user_data->zmove[j] /= ((double) ns) ;
			}
*/

	fflush(stdout);
	delete_all_edges();
	free(va);
	free(vp);
	free(org);
	free(next);
	free(my_stack.elts);
	free(see);

	sl_color_object();
	sl_close_object();
}
