#include "2D-DT_defines.h"

/****************************************************************/
/*	Geometric primitives
/****************************************************************/

BOOLEAN incircle(a,b,c,d)
    /* incircle, as in the Guibas-Stolfi paper. */
VERTEX_PTR a,b,c,d;
{
    double adx, ady, bdx, bdy, cdx, cdy, dx, dy, dnorm;
    double dret ;
    dx = VX(d);	dy = VY(d);	dnorm = NORM(d);
    adx = VX(a) - dx;    ady = VY(a) - dy;    
    bdx = VX(b) - dx;    bdy = VY(b) - dy;    
    cdx = VX(c) - dx;    cdy = VY(c) - dy;    
    dret = 
        (  (NORM(a) - dnorm) * (bdx * cdy - bdy * cdx)
	 + (NORM(b) - dnorm) * (cdx * ady - cdy * adx)
	 + (NORM(c) - dnorm) * (adx * bdy - ady * bdx));
    return( (0.0 < dret) ? TRUE : FALSE );
};

BOOLEAN ccw(a,b,c)
	/* TRUE iff A, B, C form a counterclockwise oriented triangle */
VERTEX_PTR a,b,c;
{
	double dret ;
     dret =  (VX(a)-VX(c))*(VY(b)-VY(c)) - (VX(b)-VX(c))*(VY(a)-VY(c)) ;
    return( (dret  > 0.0)? TRUE : FALSE);
};
