#include "sli.h"

#define EPSILON (1.0e-6)

#ifndef BOOLEAN 
#define BOOLEAN int
#endif
#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

typedef int EDGE_PTR;
typedef int VERTEX_PTR;

struct VEC2 {
    double x,y;
};

struct VERTEX {
	struct VEC2 v;
	double norm;
};

#define onext(a) next[a]
#define oprev(a) rot(onext(rot(a)))
#define lnext(a) rot(onext(rotinv(a)))
#define lprev(a) sym(onext(a))
#define rnext(a) rotinv(onext(rot(a)))
#define rprev(a) onext(sym(a))
#define dnext(a) sym(onext(sym(a)))
#define dprev(a) rotinv(onext(rotinv(a)))

#define VX(a) va[a].v.x
#define VY(a) va[a].v.y
#define NORM(a) va[a].norm

#define orig(a) org[a]
#define dest(a) orig(sym(a))
#define seen(a) see[a]

#define sym(a) ((a) ^ 2)
#define origv(a) va[orig(a)].v
#define destv(a) va[dest(a)].v

#define rot(a) ( (((a) + 1) & 3) | ((a) & ~3) )
#define rotinv(a) ( (((a) + 3) & 3) | ((a) & ~3) )

struct EDGE_STACK {
    int ptr;
    EDGE_PTR *elts ;
};

extern EDGE_PTR alloc_edge();
extern EDGE_PTR makeedge();
extern splice();
extern swapedge();
extern EDGE_PTR connect();
extern deleteedge();
extern build_delaunay_triangulation();
extern zero_seen();
#define pop_edge(x) (x)->elts[(x)->ptr--];

#ifdef IRIS
#define drand() (((double) rand()) / (double) 0x7fff)
#else
#define drand() (((double) rand()) / (double) 0x7fffffff)
#endif

#ifdef DEFINE_GLOBALS
#define EXTERN 
#else
#define EXTERN extern
#endif

EXTERN VERTEX_PTR *vp ;
EXTERN struct VERTEX *va ;
EXTERN EDGE_PTR *next ;
EXTERN VERTEX_PTR *org ;
EXTERN int num_vertices, num_edgeparts, stack_size ;
EXTERN char filename[127];
EXTERN char *see;

#ifdef ODEFINE_GLOBALS
#define OEXTERN
#else
#define OEXTERN extern
#endif  
OEXTERN struct EDGE_STACK my_stack;


#define my_alloc(str_name, str_type, str_cnt) \
		if (NULL == (str_name = (str_type *) \
		calloc((unsigned) (str_cnt ), (unsigned) (sizeof(str_type)))))\
		exit(fprintf(stderr," cannot malloc (str_name) \n"))

#define more_alloc(str_name, str_type, str_cnt) \
		if (NULL == (str_name = (str_type *) \
		realloc (str_name, (unsigned) (str_cnt * sizeof(str_type))))) \
		exit(fprintf(stderr," cannot realloc (str_name) \n"))

#define VERTEX_ALLOC 1000
