#include "2D-DT_defines.h"

EDGE_PTR connect_left(a, b)
EDGE_PTR a,b;
{
    register EDGE_PTR ans;
    ans = makeedge(dest(a), orig(b));
    splice(ans, lnext(a));
    splice(sym(ans), b);
    return(ans);
};

EDGE_PTR connect_right(a, b)
EDGE_PTR a,b;
{
    register EDGE_PTR ans;
    ans = makeedge(dest(a), orig(b));
    splice(ans, sym(a));
    splice(sym(ans), oprev(b));
    return(ans);
};

deleteedge(e)
    /* disconnects e from the rest of the structure and destroys it. */
EDGE_PTR e;
{
    splice(e, oprev(e));
    splice(sym(e), oprev(sym(e)));
    free_edge(e);
};
