/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: print.c,v 1.5 1993/11/23 21:55:40 gbourhis Exp $";
#endif


#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/TextF.h>
#include <Xm/MessageB.h>
#include <Xm/Separator.h>
#include <Xm/Frame.h>
#include <Xm/PushB.h>
#include <Xm/FileSB.h>
#include "view.h"

#ifndef MALLOC
#define MALLOC(x)	malloc(x)
#define FREE(x)		free(x)
#endif



typedef struct {
	Widget toptop;
	Widget top;
	Widget label;
	Widget outToggleBox;
	Widget colorToggleBox;
	Widget command;
	Widget okButton;
	Boolean save;
	Boolean lpr;
	Boolean grayscale;
	unsigned char *image;
	int	xdim,ydim;
	Boolean shouldFreeImage;
	unsigned char *rgb;
	Boolean shouldFreeRGB;
	Widget fileBox;
	Boolean poppedUp;	/* interface popped up*/
	Boolean inUse;	/* being used? popped up or save popped up?*/
	} PrintUI;


extern Display *myDpy;
static Widget rootWidget;

static unsigned char defaultRGB[768];
static long	background;
static PrintUI *printUI;

static PrintUI *PrintCreateUI PARAMS((void));

DEFUN(PrintInit,(top),Widget top)
{
	XColor defaultCCells[256];
	Display *myDpy;
	int x;

	myDpy = XtDisplay(top);
	rootWidget = top;

        for(x=0;x < 256; x++)
                defaultCCells[x].pixel = x;
        XQueryColors(myDpy,DefaultColormap(myDpy,DefaultScreen(myDpy)),
                        defaultCCells,256);
	ConvertXColorsToRGB(defaultCCells,defaultRGB);
		

	background = WhitePixel(myDpy, DefaultScreen(myDpy));
	printUI = PrintCreateUI();

}

static void
DEFUN(
      PrintRaster,(psFileName,title,raster,xdim,ydim,palette,grayscale),
      char *psFileName AND
      char *title AND
      unsigned char *raster AND
      int xdim AND
      int ydim AND
      unsigned char *palette AND
      Boolean grayscale)
{
	PSbegin(psFileName);

	if (grayscale) {
		PSputbwimage(raster,xdim,ydim,palette);
		}
	else {
		PSputcolorimage(raster,xdim,ydim,palette);
		}

	if (psFileName && strlen(psFileName)) {
		PSsetrgbcolor(0.0, 0.0, 0.9);
		PSsetfont("Helvetica",20);
		PSdrawtextat(title,100,70);
		}

	PSfinish();
}


void CBPrintImage(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
View *v;
static char title[1024];
char ebuff[1024];
char buff[256];

	v = (View *) client_data;

/*
	if (XtIsManaged(printUI->top)) {
		ErrMesg("Print dialog already displayed");
		return;
		}
*/
	if (printUI->inUse) {
		ErrMesg("Please close previous print request first");
		return;
		}

	printUI->image = (unsigned char *) v->cData->buff;
	printUI->xdim = v->cData->xdim;
	printUI->ydim = v->cData->ydim;
	printUI->shouldFreeImage = FALSE;
	if (v->cData->hasPalette) {
		printUI->rgb = (unsigned char *) v->cData->pal->rgb;
		printUI->shouldFreeRGB = FALSE;
		}
	else {
		printUI->rgb = defaultRGB;
		printUI->shouldFreeRGB = FALSE;
		}
	XtPopup(printUI->toptop,XtGrabNone);
	printUI->poppedUp = TRUE;

	XmTextFieldSetString(printUI->label,v->cData->name);



}

void CBPrintOverlay(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
View *v;
int whiteboard;
XImage *drawImage;	/* data image */
XImage *doodleImage;	/* data image + overlay */
unsigned char *raster;
register int x,y;
unsigned char *ptr;
int width,height;
char ebuff[1024];
char buff[256];
char title[1024];
char palette[768];


        v = (View *) client_data;

/*
	if (XtIsManaged(printUI->top)) {
		ErrMesg("Print dialog already displayed");
		return;
		}
*/
	if (printUI->inUse) {
		ErrMesg("Please close previous print request first");
		return;
		}

	if (v->type == V_WHITEBOARD)
                whiteboard = 1;
        else 
                whiteboard = 0;
        width = v->cData->xdim;
        height = v->cData->ydim;

        if (!whiteboard) {
#ifdef DEBUG
		fprintf(stderr,"doing an XGetImage for !whiteboard\n");
	        fprintf(stderr,"XGetImage(%x,%x,%d,%d,%d,%d,%x,%x)\n",
				myDpy, v->drawPix, 0, 0, width, height,
                                AllPlanes, ZPixmap);
#endif
                drawImage = XGetImage(myDpy, v->drawPix, 0, 0, width, height,
                        		AllPlanes, ZPixmap);
        	}
#ifdef DEBUG
	fprintf(stderr,"XGetImage(%d,%d,%d,%d,%d,%d,%d,%d)\n",
				myDpy, v->doodlePix, 0, 0, width, height,
                                AllPlanes, ZPixmap);
#endif
        doodleImage = XGetImage(myDpy, v->doodlePix, 0, 0, width, height,
                			AllPlanes, ZPixmap);
#ifdef DEBUG
	fprintf(stderr,"Just did XGetImage\n");
#endif

        if (!(raster = (unsigned char *)MALLOC(width * height 
				* sizeof(unsigned char)))) {
		ErrMesg("Out of memory printing overlay image");
		return;
		}
	ptr = raster;
        for (y=0; y<height; y++) {
                for (x=0; x<width; x++) {
                        unsigned long p1, p2;
                        if (!whiteboard) {
                                p1 = XGetPixel(drawImage, x, y);
                        	}
                        p2 = XGetPixel(doodleImage, x, y);

			/* extract overlay from image+overlay */
                        if ((!whiteboard)&&(p2 == p1)) {
                                *ptr++ = (unsigned char) background;
                        	}
                        else {
                                *ptr++ = (unsigned char)p2;
                        	}
                	}
		}
	sprintf(title,"Overlay of %s",v->cData->name);

        printUI->image = raster;
        printUI->xdim = v->cData->xdim;
        printUI->ydim = v->cData->ydim;
        printUI->shouldFreeImage = TRUE;
        if (v->cData->hasPalette) {
                printUI->rgb = (unsigned char *) v->cData->pal->rgb;
                printUI->shouldFreeRGB = FALSE;
                }
        else {
                printUI->rgb = defaultRGB;
                printUI->shouldFreeRGB = FALSE;
                }
        XtPopup(printUI->toptop,XtGrabNone);
	printUI->poppedUp = TRUE;

        XmTextFieldSetString(printUI->label,title);

	return;
}

void CBPrintOverlayWithImage(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
View *v;
int whiteboard;
XImage *drawImage;	/* data image */
XImage *doodleImage;	/* data image + overlay */
unsigned char *raster;
register int x,y;
unsigned char *ptr;
int width,height;
char ebuff[1024];
char buff[256];
char title[1024];


        v = (View *) client_data;

/*
	if (XtIsManaged(printUI->top)) {
		ErrMesg("Print dialog already displayed");
		return;
		}
*/
	if (printUI->inUse) {
		ErrMesg("Please close previous print request first");
		return;
		}

	if (v->type == V_WHITEBOARD)
                whiteboard = 1;
        else 
                whiteboard = 0;
        width = v->cData->xdim;
        height = v->cData->ydim;

#ifdef DEBUG
	fprintf(stderr,"XGetImage(%d,%d,%d,%d,%d,%d,%d,%d)\n",
				myDpy, v->doodlePix, 0, 0, width, height,
                                AllPlanes, ZPixmap);
#endif
        doodleImage = XGetImage(myDpy, v->doodlePix, 0, 0, width, height,
                			AllPlanes, ZPixmap);
#ifdef DEBUG
	fprintf(stderr,"Just did XGetImage\n");
#endif

        if (!(raster = (unsigned char *)MALLOC(width * height 
				* sizeof(unsigned char)))) {
		ErrMesg("Out of memory printing overlay image");
		return;
		}
	ptr = raster;
        for (y=0; y<height; y++) {
                for (x=0; x<width; x++) {
			*ptr++ = XGetPixel(doodleImage,x,y);
                	}
		}

	sprintf(title,"Image and Overlay of %s",v->cData->name);
        printUI->image = raster;
        printUI->xdim = v->cData->xdim;
        printUI->ydim = v->cData->ydim;
        printUI->shouldFreeImage = TRUE;
        if (v->cData->hasPalette) {
                printUI->rgb = (unsigned char *) v->cData->pal->rgb;
                printUI->shouldFreeRGB = FALSE;
                }
        else {
                printUI->rgb = defaultRGB;
                printUI->shouldFreeRGB = FALSE;
                }
        XtPopup(printUI->toptop,XtGrabNone);
	printUI->poppedUp = TRUE;

        XmTextFieldSetString(printUI->label,title);

}

static void
DEFUN(CBPrintToggle,(w,client_data,call_data),
      Widget w AND
      XtPointer client_data AND
      XtPointer call_data)
{
	PrintUI *print  = (PrintUI *) client_data;

	print->lpr = ((XmToggleButtonCallbackStruct *)call_data)->set;
}


static void
DEFUN(CBSaveToggle,(w,client_data,call_data),
      Widget w AND
      XtPointer client_data AND
      XtPointer call_data)
{
	PrintUI *print = (PrintUI *) client_data;

	print->save = ((XmToggleButtonCallbackStruct *)call_data)->set;
}

static void
DEFUN(CBColor,(w,client_data,call_data),
      Widget w AND
      XtPointer client_data AND
      XtPointer call_data)
{
	PrintUI *print = (PrintUI *) client_data;

	print->grayscale = ((XmToggleButtonCallbackStruct *)call_data)->set;
}

static void
DEFUN(ContinuePrint,(print,fileName),
      PrintUI *print AND
      char *fileName)
{
char *lprcommand;
char ebuff[2048];
char buff[256];

	printf("Continue print called\n");
	printf("print->lpr = %d, print->save = %d\n",print->lpr,print->save);
	if (print->lpr) {
		PrintRaster(fileName, XmTextFieldGetString(print->label),
				print->image, print->xdim,print->ydim, 
				print->rgb,print->grayscale);

		lprcommand = XmTextFieldGetString(print->command);
		if ((!lprcommand) || (!strlen(lprcommand))) {
			ErrMesg("No Print Command specified");
			}
		else {
		        sprintf(ebuff,"%s %s\n",lprcommand,fileName);
       			system(ebuff);
			sprintf(buff,"Image is printing\n"); 
					/*** actually should check status*/
                                        /* with a wait(status); */
       		 	WriteMesg(buff);
			if (!print->save) {
				sprintf(ebuff,"rm %s",fileName);
				system(ebuff);
				}
			}
		}
	else {
		if (print->save) {
			PrintRaster(fileName, 
				XmTextFieldGetString(print->label),
				print->image, print->xdim,print->ydim, 
				print->rgb,print->grayscale);
			sprintf(buff,"Saved PostScript image to %s\n",
					fileName); 
			WriteMesg(buff);
			}
		}

}

static void
CBPrintOk(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
PrintUI *print;
char fileName[256];

	print = (PrintUI *) client_data;
/**/	print = printUI;
	XtPopdown(print->toptop);
	printUI->poppedUp = FALSE;
	if (print->save) {
		XtManageChild(print->fileBox);
		}
	else {
		if (print->lpr) {
			sprintf(fileName,"%s.ps",tempnam(0,"collage"));
			ContinuePrint(print,fileName);
			}
		print->inUse = FALSE;
		}
}

static void
CBPrintCancel(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
PrintUI *print;

        print = (PrintUI *) client_data;
/**/	print = printUI;
        XtPopdown(print->toptop);
	printUI->inUse = FALSE;
	printUI->poppedUp = FALSE;
}

static void
CBPrintFileNewOk(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
XmFileSelectionBoxCallbackStruct *f;
PrintUI *print;
char *fileName;

        print = (PrintUI *) client_data;
        f = (XmFileSelectionBoxCallbackStruct *) call_data;
        XmStringGetLtoR(f->value,XmSTRING_DEFAULT_CHARSET,&fileName);
	XtUnmanageChild(print->fileBox);
	if (print->lpr || print->save) {
		ContinuePrint(print,fileName);
		}
	print->inUse = FALSE;
}

static void
CBPrintFileNewCancel(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
PrintUI *print;

        print = (PrintUI *) client_data;
	XtUnmanageChild(print->fileBox);
	print->inUse = FALSE;
}

static PrintUI *
DEFUN_VOID(PrintCreateUI)
{
Cardinal i;
PrintUI *print;
Widget b;
XmString label;
Arg argList[15];
Widget separator;
Widget textForm1;
Widget textForm2;
Widget frame1;
Widget frame2;
Widget buttonBox;

        if (!(print = (PrintUI*) MALLOC(sizeof(PrintUI )))) {
                ErrMesg("Out of Memory: Can't Print\n");
                return(0);
                }
	print->save = FALSE;
	print->lpr = TRUE;
	print->grayscale = TRUE;

        i = 0;
        XtSetArg(argList[i], XmNallowShellResize, True); i++;
        XtSetArg(argList[i], XtNtitle, "PostScript Print Info"); i++;
        XtSetArg(argList[i], XmNkeyboardFocusPolicy, XmPOINTER); i++;
        XtSetArg(argList[i], XmNdeleteResponse, XmUNMAP); i++;
	print->toptop= XtCreatePopupShell("PrintShell", 
					topLevelShellWidgetClass,
                                        rootWidget, argList, i);
/*
	i=0;
        XtSetArg(argList[i], XmNallowShellResize, True); i++;
        XtSetArg(argList[i], XmNwidth, 250); i++;
        XtSetArg(argList[i], XmNheight, 300); i++;
	b = XmCreateMessageBox(print->toptop,"PrintShell",argList,i);
	XtManageChild(b);
*/

        i=0;
        XtSetArg(argList[i],XmNwidth,250); i++;
        XtSetArg(argList[i],XmNheight,180); i++;
        print->top  = XmCreateForm(print->toptop,0,argList,i);
        XtManageChild(print->top);


        i=0;
        XtSetArg(argList[i],XmNtopWidget,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        textForm1 = XmCreateForm(print->top,0,argList,i);
        XtManageChild(textForm1);

	i=0;
        label = XmStringCreateLtoR("Label:", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_FORM); i++;
	b = XmCreateLabel(textForm1,0,argList,i);
	XtManageChild(b);

	i=0;
        XtSetArg(argList[i], XmNeditable, True); i++;
        XtSetArg(argList[i],XmNtopWidget,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftWidget,b); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_WIDGET); i++;
	print->label = XmCreateTextField(textForm1,0,argList,i);
	XtManageChild(print->label);

	i=0;
        XtSetArg(argList[i],XmNtopWidget,textForm1); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
	frame1 = XmCreateFrame(print->top,0,argList,i);
	XtManageChild(frame1);

	i=0;
        XtSetArg(argList[i], XmNwidth, 150); i++;
        XtSetArg(argList[i], XmNheight, 50); i++;
	print->outToggleBox = XmCreateRowColumn(frame1,0,argList,i);

	i=0;
        label = XmStringCreateLtoR("Print", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNset,print->lpr); i++;
        b = XmCreateToggleButton(print->outToggleBox,0,argList,i);
        XtAddCallback(b,XmNvalueChangedCallback, CBPrintToggle,(caddr_t)print);
	XtManageChild(b);

	i=0;
        label = XmStringCreateLtoR("Save...", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNset,print->save); i++;
        b = XmCreateToggleButton(print->outToggleBox,0,argList,i);
        XtAddCallback(b,XmNvalueChangedCallback, CBSaveToggle,(caddr_t)print);
	XtManageChild(b);
	XtManageChild(print->outToggleBox);

	i=0;
        XtSetArg(argList[i],XmNtopWidget,textForm1); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftWidget,frame1); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_WIDGET); i++;
	frame2 = XmCreateFrame(print->top,0,argList,i);
	XtManageChild(frame2);
	
	i=0;
        XtSetArg(argList[i], XmNwidth, 150); i++;
	print->colorToggleBox = XmCreateRadioBox(frame2,0,argList,i);
	XtManageChild(print->colorToggleBox);

	i=0;
        label = XmStringCreateLtoR("Grayscale", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNset,print->grayscale); i++;
        b = XmCreateToggleButton(print->colorToggleBox,0,argList,i);
        XtAddCallback(b,XmNvalueChangedCallback, CBColor,(caddr_t)print);
	XtManageChild(b);

	i=0;
        label = XmStringCreateLtoR("Color", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNset, (! print->grayscale)); i++;
        b = XmCreateToggleButton(print->colorToggleBox,0,argList,i);
	XtManageChild(b);
	
        i=0;
        XtSetArg(argList[i],XmNtopWidget,frame2); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        textForm2 = XmCreateForm(print->top,0,argList,i);
        XtManageChild(textForm2);

	i=0;
        label = XmStringCreateLtoR("Print Command:", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_FORM); i++;
	b = XmCreateLabel(textForm2,0,argList,i);
	XtManageChild(b);

	i=0;
        XtSetArg(argList[i], XmNeditable, True); i++;
        XtSetArg(argList[i],XmNleftWidget,b); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_FORM); i++;
	print->command = XmCreateTextField(textForm2,0,argList,i);
	XtManageChild(print->command);
	XmTextFieldSetString(print->command,"lpr");

	i=0;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNtopWidget,textForm2); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNorientation,XmHORIZONTAL); i++;
	separator = XmCreateSeparator(print->top,0,argList,i);
	XtManageChild(separator);
	
	i=0;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNtopWidget,separator); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_WIDGET); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_FORM); i++;
/*        XtSetArg(argList[i],XmNorientation,XmHORIZONTAL); i++;*/
	buttonBox = XmCreateForm(print->top,0,argList,i);
	XtManageChild(buttonBox);

	i=0;
        label = XmStringCreateLtoR("OK", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNfractionBase,110); i++;
        XtSetArg(argList[i],XmNleftPosition,5); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_POSITION); i++;
        XtSetArg(argList[i],XmNrightPosition,30); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_POSITION); i++;
        XtSetArg(argList[i],XmNtopPosition,25); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_POSITION); i++;
        XtSetArg(argList[i],XmNbottomPosition,75); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_POSITION); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
	print->okButton = XmCreatePushButton(buttonBox,0,argList,i);
        XtAddCallback(print->okButton,XmNactivateCallback,
					CBPrintOk,(caddr_t)printUI);
	XtManageChild(print->okButton);

	i=0;
        label = XmStringCreateLtoR("Cancel", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNfractionBase,110); i++;
        XtSetArg(argList[i],XmNleftPosition,35); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_POSITION); i++;
        XtSetArg(argList[i],XmNrightPosition,60); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_POSITION); i++;
        XtSetArg(argList[i],XmNtopPosition,25); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_POSITION); i++;
        XtSetArg(argList[i],XmNbottomPosition,75); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_POSITION); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
	b = XmCreatePushButton(buttonBox,0,argList,i);
        XtAddCallback(b,XmNactivateCallback,CBPrintCancel,(caddr_t)printUI);
	XtManageChild(b);

	i=0;
        label = XmStringCreateLtoR("Help", XmSTRING_DEFAULT_CHARSET);
        XtSetArg(argList[i],XmNfractionBase,110); i++;
        XtSetArg(argList[i],XmNleftPosition,65); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_POSITION); i++;
        XtSetArg(argList[i],XmNrightPosition,90); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_POSITION); i++;
        XtSetArg(argList[i],XmNtopPosition,25); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_POSITION); i++;
        XtSetArg(argList[i],XmNbottomPosition,75); i++;
        XtSetArg(argList[i],XmNbottomAttachment,XmATTACH_POSITION); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
	b = XmCreatePushButton(buttonBox,0,argList,i);
	XtManageChild(b);

	print->fileBox =  XmCreateFileSelectionDialog(rootWidget,
			"fileSelectionBox", argList,0);
        XtAddCallback(print->fileBox,XmNokCallback,
				CBPrintFileNewOk,(caddr_t)print);
        XtAddCallback(print->fileBox,XmNcancelCallback,
				CBPrintFileNewCancel, (caddr_t)print);

	print->poppedUp = FALSE;
	print->inUse = FALSE;

	return(print);
}
