/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: erase.c,v 1.4 1993/11/05 17:54:58 gbourhis Exp gbourhis $";
#endif


#include <stdio.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <dtm/dtm.h>
#define ABS(x)  ((x)>0) ? (x): (-1.0*(x))

#include "doodle.h"
#include "view.h"
#include "viewer.h"
#include "net.h"
#include "mode.h"


extern Pixmap FindDHash();
extern Cdata *CdataSearchByName();
extern void RubberBox();
extern void RubberPoint();
extern void RubberSelect();
extern void RubberLineSelect();
extern void SheetExposed();
extern void BufferSheetExposed();
extern void FlushSheetBuffer();
extern void TextClear();
extern void TextClearFlush();
extern int NetSendEraseDoodle();


extern NetPort	*outP;
extern int	start_x, end_x, start_y, end_y;
extern GC	drawAreaGC;
extern GC	invtextGC;
extern GC	invGC;
extern GC       clipOnGC;
extern GC       clipOffGC;
extern Display	*myDpy;
extern Cdata 	*currentObject;
extern char	textMode;
extern int	Swidth, Sheight, Sascent;
extern int	SdrawWidth, SdrawHeight, SdrawAscent;
extern int TopMargin, BottomMargin, LeftMargin, RightMargin, Border;

extern POINT	drawDoodle[];
extern long	lastDoodle;
extern long	doodleLength;


int MySendEraseDoodle();





void
EraseBlocks(V, d, array, start, end)
	View *V;
	Cdata *d;
	POINT *array;
	long start;
	long end;
{
	int i, x, y;
	int row1, row2, col1, col2;
	int px, py;
	Pixmap dmap;
	Pixmap clipmask;

	if ((V->Mode == TEXTINSERT)&&(V->isUp))
	{
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	}
	if (V->type == V_SHEET)
	{
		Cardinal cnt;
		Arg argList[10];
		Pixel bg;

		cnt = 0;
		XtSetArg(argList[cnt], XtNbackground, &bg); cnt++;
		XtGetValues(V->drawArea, argList, cnt);
		XSetForeground(myDpy, drawAreaGC, bg);

	    for (i=start; i <= end; i++)
	    {
		int erased = 0;

		col1 = (array[i].x - 8 + V->Scroll_x) / (SdrawWidth * S_DIGITS);
		col2 = (array[i].x + 8 + V->Scroll_x) / (SdrawWidth * S_DIGITS);
		row1 = (array[i].y - 8 + V->Scroll_y) / SdrawHeight;
		row2 = (array[i].y + 8 + V->Scroll_y) / SdrawHeight;
		for (y = row1; y <= row2; y++)
		{
		    for (x = col1; x <= col2; x++)
		    {
			if ((x < d->xdim)&&(y < d->ydim))
			{
			    dmap = FindDHash(V->Doodles, x, y, &clipmask);
			    px = (array[i].x - 8 + V->Scroll_x) -
				(x * SdrawWidth * S_DIGITS);
			    py = (array[i].y - 8 + V->Scroll_y) - (y * SdrawHeight);
			    if (dmap != (Pixmap)0)
			    {
				erased = 1;
				XFillRectangle(myDpy, dmap, drawAreaGC,
				    px, py, 16, 16);
				XFillRectangle(myDpy, clipmask, clipOffGC,
				    px, py, 16, 16);
			    }
			}
		    }
		}
		if ((V->isUp)&&(V->viewOverlay)&&(erased))
		{
			XFillRectangle(myDpy, XtWindow(V->drawArea), drawAreaGC,
				array[i].x - 8, array[i].y - 8, 16, 16);
			BufferSheetExposed(V, array[i].x - 8, array[i].y - 8,
				16, 16);
		}
	    }
	    return;
	}

	if (V->type == V_TEXT)
	{
		Cardinal cnt;
		Arg argList[10];
		Pixel bg;

		cnt = 0;
		XtSetArg(argList[cnt], XtNbackground, &bg); cnt++;
		XtGetValues(V->drawArea, argList, cnt);
		XSetForeground(myDpy, drawAreaGC, bg);

	    for (i=start; i <= end; i++)
	    {
		int erased = 0;

		col1 = (array[i].x - 8 + V->Scroll_x - LeftMargin) / Swidth;
		col2 = (array[i].x + 8 + V->Scroll_x - LeftMargin) / Swidth;
		row1 = (array[i].y - 8 + V->Scroll_y - TopMargin) / Sheight;
		row2 = (array[i].y + 8 + V->Scroll_y - TopMargin) / Sheight;
		for (y = row1; y <= row2; y++)
		{
		    for (x = col1; x <= col2; x++)
		    {
			if ((x >= 0)&&(y >= 0))
			{
			    dmap = FindDHash(V->Doodles, x, y, &clipmask);
			    px = (array[i].x - 8 + V->Scroll_x - LeftMargin) -
				(x * Swidth);
			    py = (array[i].y - 8 + V->Scroll_y - TopMargin) -
				(y * Sheight);
			    if (dmap != (Pixmap)0)
			    {
				erased = 1;
				XFillRectangle(myDpy, dmap, drawAreaGC,
				    px, py, 16, 16);
				XFillRectangle(myDpy, clipmask, clipOffGC,
				    px, py, 16, 16);
			    }
			}
		    }
		}
		if ((V->isUp)&&(V->viewOverlay)&&(erased))
		{
			XFillRectangle(myDpy, XtWindow(V->drawArea), drawAreaGC,
				array[i].x - 8, array[i].y - 8, 16, 16);
			TextClear(V->drawArea,
				array[i].x - 8, array[i].y - 8, 16, 16);
/*
			XClearArea(myDpy, XtWindow(V->drawArea),
				array[i].x - 8, array[i].y - 8, 16, 16, True);
*/
		}
	    }
	    return;
	}

	if (d == V->cData)
	{
		if (d->V->type == V_WHITEBOARD)
		{
			Cardinal cnt;
			Arg argList[10];
			Pixel bg;

			cnt = 0;
			XtSetArg(argList[cnt], XtNbackground, &bg); cnt++;
			XtGetValues(V->drawArea, argList, cnt);
			XSetForeground(myDpy, drawAreaGC, bg);
		}
		else
		{
			XSetFillStyle(myDpy, drawAreaGC, FillTiled);
			XSetTile(myDpy, drawAreaGC, V->drawPix);
		}

		if ((V->isUp)&&(V->viewOverlay))
		{
			if (V->areaSelect)
			{
				RubberSelect(V, V->drawArea);
			}
			if (V->lineSelect)
			{
				RubberLineSelect(V, V->drawArea, 0);
			}
			if (V->pointSelect)
			{
				RubberPoint(V, V->drawArea, 0);
			}
		}
		for (i=start; i <= end; i++)
		{
			if ((V->isUp)&&(V->viewOverlay))
			{
				XClearArea(myDpy, XtWindow(V->drawArea),
					array[i].x - 8, array[i].y - 8,
					16, 16, False);
			}
			XFillRectangle(myDpy, V->doodlePix, drawAreaGC,
				array[i].x - 8, array[i].y - 8, 16, 16);
		}
		if ((V->isUp)&&(V->viewOverlay))
		{
			if (V->pointSelect)
			{
				RubberPoint(V, V->drawArea, 1);
			}
			if (V->lineSelect)
			{
				RubberLineSelect(V, V->drawArea, 0);
			}
			if (V->areaSelect)
			{
				RubberSelect(V, V->drawArea);
			}
		}
		XSetFillStyle(myDpy, drawAreaGC, FillSolid);
	}

	if (d->V->type == V_WHITEBOARD)
	{
		int x, y;
		Cardinal cnt;
		Arg argList[10];
		Pixel bg;

		cnt = 0;
		XtSetArg(argList[cnt], XtNbackground, &bg); cnt++;
		XtGetValues(V->drawArea, argList, cnt);

		for (i = d->doodleImage != NULL ? start : end+1; i <= end; i++)
		{
			for (y = -8; y < 8; y++)
			{
				for (x = -8; x < 8; x++)
				{
					if (((array[i].x + x) >= 0)&&
						((array[i].y + y) >= 0)&&
						((array[i].x + x) < d->xdim)&&
						((array[i].y + y) < d->ydim))
					{
						XPutPixel(d->doodleImage,
							array[i].x + x,
							array[i].y + y,
							bg);
					}
				}
			}
		}
	}
	else
	{
		int x, y;
		unsigned long pix;

		for (i = d->doodleImage != NULL ? start : end+1; i <= end; i++)
		{
			for (y = -8; y < 8; y++)
			{
				for (x = -8; x < 8; x++)
				{
					if (((array[i].x + x) >= 0)&&
						((array[i].y + y) >= 0)&&
						((array[i].x + x) < d->xdim)&&
						((array[i].y + y) < d->ydim))
					{
						pix = XGetPixel(d->image,
							array[i].x + x,
							array[i].y + y);
						XPutPixel(d->doodleImage,
							array[i].x + x,
							array[i].y + y,
							pix);
					}
				}
			}
		}
	}
	if ((V->Mode == TEXTINSERT)&&(V->isUp))
	{
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	}
}


void
EraseArea(V, d, x1, y1, x2, y2)
	View *V;
	Cdata *d;
	int x1, y1;
	int x2, y2;
{
	int i, x, y;
	int row1, row2, col1, col2;
	int px, py;
	Pixmap dmap;
	Pixmap clipmask;

	if ((V->Mode == TEXTINSERT)&&(V->isUp))
	{
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	}
	if (V->type == V_SHEET)
	{
		Cardinal cnt;
		Arg argList[10];
		Pixel bg;

		cnt = 0;
		XtSetArg(argList[cnt], XtNbackground, &bg); cnt++;
		XtGetValues(V->drawArea, argList, cnt);
		XSetForeground(myDpy, drawAreaGC, bg);

		col1 = (x1 + V->Scroll_x) / (SdrawWidth * S_DIGITS);
		col2 = (x2 + V->Scroll_x) / (SdrawWidth * S_DIGITS);
		row1 = (y1 + V->Scroll_y) / SdrawHeight;
		row2 = (y2 + V->Scroll_y) / SdrawHeight;
		for (y = row1; y <= row2; y++)
		{
		    for (x = col1; x <= col2; x++)
		    {
			if ((x < d->xdim)&&(y < d->ydim))
			{
			    dmap = FindDHash(V->Doodles, x, y, &clipmask);
			    px = (x1 + V->Scroll_x) - (x * SdrawWidth * S_DIGITS);
			    py = (y1 + V->Scroll_y) - (y * SdrawHeight);
			    if (dmap != (Pixmap)0)
			    {
				XFillRectangle(myDpy, dmap, drawAreaGC, px, py,
					(unsigned int)(x2 - x1 + 1),
					(unsigned int)(y2 - y1 + 1));
				XFillRectangle(myDpy, clipmask, clipOffGC,
					px, py,
					(unsigned int)(x2 - x1 + 1),
					(unsigned int)(y2 - y1 + 1));
			    }
			}
		    }
		}
		if ((V->isUp)&&(V->viewOverlay))
		{
			SheetExposed(V, x1, y1,
				(unsigned int)(x2 - x1 + 1),
				(unsigned int)(y2 - y1 + 1));
		}
		return;
	}

	if (V->type == V_TEXT)
	{
		Cardinal cnt;
		Arg argList[10];
		Pixel bg;

		cnt = 0;
		XtSetArg(argList[cnt], XtNbackground, &bg); cnt++;
		XtGetValues(V->drawArea, argList, cnt);
		XSetForeground(myDpy, drawAreaGC, bg);

		col1 = (x1 + V->Scroll_x - LeftMargin) / Swidth;
		col2 = (x2 + V->Scroll_x - LeftMargin) / Swidth;
		row1 = (y1 + V->Scroll_y - TopMargin) / Sheight;
		row2 = (y2 + V->Scroll_y - TopMargin) / Sheight;
		for (y = row1; y <= row2; y++)
		{
		    for (x = col1; x <= col2; x++)
		    {
			if ((x >= 0)&&(y >= 0))
			{
			    dmap = FindDHash(V->Doodles, x, y, &clipmask);
			    px = (x1 + V->Scroll_x - LeftMargin) - (x * Swidth);
			    py = (y1 + V->Scroll_y - TopMargin) - (y * Sheight);
			    if (dmap != (Pixmap)0)
			    {
				XFillRectangle(myDpy, dmap, drawAreaGC, px, py,
					(unsigned int)(x2 - x1 + 1),
					(unsigned int)(y2 - y1 + 1));
				XFillRectangle(myDpy, clipmask, clipOffGC,
					px, py,
					(unsigned int)(x2 - x1 + 1),
					(unsigned int)(y2 - y1 + 1));
			    }
			}
		    }
		}
		if ((V->isUp)&&(V->viewOverlay))
		{
			TextClear(V->drawArea, x1, y1,
				(unsigned int)(x2 - x1 + 1),
				(unsigned int)(y2 - y1 + 1));
/*
			XClearArea(myDpy, XtWindow(V->drawArea), x1, y1,
				(unsigned int)(x2 - x1 + 1),
				(unsigned int)(y2 - y1 + 1), True);
*/
		}
		return;
	}


	if (d == V->cData)
	{
		if (d->V->type == V_WHITEBOARD)
		{
			Cardinal i;
			Arg argList[10];
			Pixel bg;

			i = 0;
			XtSetArg(argList[i], XtNbackground, &bg); i++;
			XtGetValues(V->drawArea, argList, i);
			XSetForeground(myDpy, drawAreaGC, bg);
		}
		else
		{
			XSetFillStyle(myDpy, drawAreaGC, FillTiled);
			XSetTile(myDpy, drawAreaGC, V->drawPix);
		}

		if ((V->isUp)&&(V->viewOverlay))
		{
			if (V->areaSelect)
			{
				RubberSelect(V, V->drawArea);
			}
			if (V->lineSelect)
			{
				RubberLineSelect(V, V->drawArea, 0);
			}
			if (V->pointSelect)
			{
				RubberPoint(V, V->drawArea, 0);
			}
			XClearArea(myDpy, XtWindow(V->drawArea), x1, y1,
				(unsigned int)(x2 - x1 + 1),
				(unsigned int)(y2 - y1 + 1), False);
		}
		XFillRectangle(myDpy, V->doodlePix, drawAreaGC, x1, y1,
			(unsigned int)(x2 - x1 + 1),
			(unsigned int)(y2 - y1 + 1));
		if ((V->isUp)&&(V->viewOverlay))
		{
			if (V->pointSelect)
			{
				RubberPoint(V, V->drawArea, 1);
			}
			if (V->lineSelect)
			{
				RubberLineSelect(V, V->drawArea, 0);
			}
			if (V->areaSelect)
			{
				RubberSelect(V, V->drawArea);
			}
		}

		XSetFillStyle(myDpy, drawAreaGC, FillSolid);
	}

	if (d->V->type == V_WHITEBOARD)
	{
		int x, y;
		Cardinal i;
		Arg argList[10];
		Pixel bg;

		i = 0;
		XtSetArg(argList[i], XtNbackground, &bg); i++;
		XtGetValues(V->drawArea, argList, i);

		for (y = d->doodleImage != NULL ? y1 : y2+1; y <= y2; y++)
		{
			for (x = x1; x <= x2; x++)
			{
				if ((x >= 0)&&(y >= 0)&&
					(x < d->xdim)&&(y < d->ydim))
				{
					XPutPixel(d->doodleImage, x, y, bg);
				}
			}
		}
	}
	else
	{
		int x, y;
		unsigned long pix;

		for (y = d->doodleImage != NULL ? y1 : y2+1; y <= y2; y++)
		{
			for (x = x1; x <= x2; x++)
			{
				if ((x >= 0)&&(y >= 0)&&
					(x < d->xdim)&&(y < d->ydim))
				{
					pix = XGetPixel(d->image, x, y);
					XPutPixel(d->doodleImage, x, y, pix);
				}
			}
		}
	}
	if ((V->Mode == TEXTINSERT)&&(V->isUp))
	{
		XFillRectangle(myDpy, XtWindow(V->drawArea), invGC,
			V->text_x, (V->text_y - Sascent), Swidth, Sheight);
	}
}


void
InitDrawErase(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	int status;

	drawDoodle[0].x = win_x;
	drawDoodle[0].y = win_y;
	EraseBlocks(V, V->cData, drawDoodle, 0, 0);
	lastDoodle = 0;
	doodleLength = 1;
}


void
DrawErase(V, w, win_x, win_y)
	View *V;
	Widget w;
	int win_x, win_y;
{
	long	start;
	int     status;


	if ((drawDoodle[doodleLength-1].x != win_x)||
	    (drawDoodle[doodleLength-1].y != win_y))
	{
		drawDoodle[doodleLength].x = win_x;
		drawDoodle[doodleLength].y = win_y;
		start = doodleLength;
		FillLine(drawDoodle, &doodleLength, MAXDRAWDOODLE);
		EraseBlocks(V, V->cData, drawDoodle, start,
			doodleLength);
		doodleLength++;

		/*
		 * Send Erase
		 */
		if (doodleLength == MAXDRAWDOODLE)
		{
			status = MySendEraseDoodle(V,
					(doodleLength - lastDoodle),
					&drawDoodle[lastDoodle], False, True);
			drawDoodle[0].x = drawDoodle[doodleLength  - 1].x;
			drawDoodle[0].y = drawDoodle[doodleLength  - 1].y;
			lastDoodle = 0;
			doodleLength = 1;
		}
		else
		{
			status = MySendEraseDoodle(V,
					(doodleLength - lastDoodle),
					&drawDoodle[lastDoodle], False, False);
			if (status == 1)
			{
				drawDoodle[0].x = drawDoodle[doodleLength -1].x;
				drawDoodle[0].y = drawDoodle[doodleLength -1].y;
				lastDoodle = 0;
				doodleLength = 1;
			}
		}
	}
}


void
DoneDrawErase(V, w, x, y)
	View *V;
	Widget w;
	int x, y;
{
	int status;

	if (V->type == V_TEXT)
	{
		TextClearFlush(V->drawArea);
	}
	else if (V->type == V_SHEET)
	{
		FlushSheetBuffer(V);
	}
	/*
	 * Send Erase
	 */
	if ((doodleLength)&&(lastDoodle < doodleLength))
	{
		status = MySendEraseDoodle(V, (doodleLength - lastDoodle),
				&drawDoodle[lastDoodle], False, True);
	}
}


void
DoneEraseBlock(V, w, x, y)
	View *V;
	Widget w;
	int x, y;
{
	int status;
	int tmp;

	if (start_x > end_x)
	{
		tmp = start_x;
		start_x = end_x;
		end_x = tmp;
	}
	if (start_y > end_y)
	{
		tmp = start_y;
		start_y = end_y;
		end_y = tmp;
	}

	EraseArea(V, V->cData, start_x, start_y, end_x, end_y);

	if (V->type == V_TEXT)
	{
		TextClearFlush(V->drawArea);
	}
	/*
	 * Send Erase Block
	 */
	drawDoodle[0].x = start_x;
	drawDoodle[0].y = start_y;
	drawDoodle[1].x = end_x;
	drawDoodle[1].y = end_y;
	status = MySendEraseDoodle(V, (int)2, drawDoodle, True);
}


void
DrawCollabErase(title, id, doodle, length)
	char *title;
	char *id;
	POINT *doodle;
	int length;
{
	Cdata *d;

	d = CdataSearchByName(title);
	if (d)
	{
		if (!(d->V->isUp))
		{
			XtPopup(d->V->shell, XtGrabNone);
			XFlush(myDpy);
		}
		if ((d->V->type == V_SHEET)||(d->V->type == V_TEXT))
		{
			int i;
			POINT *myDoodle;

			myDoodle = (POINT *)MALLOC(length * sizeof(POINT));

			for (i = 0; i < length; i++)
			{
				myDoodle[i].x = doodle[i].x - d->V->Scroll_x;
				myDoodle[i].y = doodle[i].y - d->V->Scroll_y;
			}
			EraseBlocks(d->V, d, myDoodle, 0, (length - 1));
			FREE((char *)myDoodle);
		}
		else if ((d->V->type == V_RASTER)||(d->V->type == V_WHITEBOARD))
		{
			EraseBlocks(d->V, d, doodle, 0, (length - 1));
		}

		XFlush(myDpy);		/* EJB */
	}
}


void
DrawCollabEraseBlock(title, id, doodle, length)
	char *title;
	char *id;
	POINT *doodle;
	int length;
{
	Cdata *d;

	if (length != 2)
	{
		fprintf(stderr, "DrawCollabEraseBlock: bad format\n");
		return;
	}

	d = CdataSearchByName(title);
	if (d)
	{
		if (!(d->V->isUp))
		{
			XtPopup(d->V->shell, XtGrabNone);
			XFlush(myDpy);
		}

		if ((d->V->type == V_SHEET)||(d->V->type == V_TEXT))
		{
			int i;
			POINT myDoodle[2];

			for (i = 0; i < 2; i++)
			{
				myDoodle[i].x = doodle[i].x - d->V->Scroll_x;
				myDoodle[i].y = doodle[i].y - d->V->Scroll_y;
			}
			EraseArea(d->V, d, myDoodle[0].x, myDoodle[0].y,
				myDoodle[1].x, myDoodle[1].y);
		}
		else if ((d->V->type == V_RASTER)||(d->V->type == V_WHITEBOARD))
		{
			EraseArea(d->V, d, doodle[0].x, doodle[0].y,
				doodle[1].x, doodle[1].y);
		}

		XFlush(myDpy);		/* EJB */
	}
}


int
MySendEraseDoodle(V, length, doodle, isblock, doQueue)
	View *V;
	int length;
	POINT *doodle;
	Boolean isblock;
	Boolean doQueue;
{
	int i, status;
	POINT *myDoodle;

	myDoodle = (POINT *)MALLOC(length * sizeof(POINT));

	if ((V->type == V_SHEET)||(V->type == V_TEXT))
	{
		for (i = 0; i < length; i++)
		{
			myDoodle[i].x = V->Scroll_x + doodle[i].x;
			myDoodle[i].y = V->Scroll_y + doodle[i].y;
		}
	}
	else if ((V->type == V_RASTER)||(V->type == V_WHITEBOARD))
	{
		for (i = 0; i < length; i++)
		{
			myDoodle[i].x = doodle[i].x;
			myDoodle[i].y = doodle[i].y;
		}
	}

	if (isblock == True)
	{
		if ((V->cData)&&(V->ispub))
		{
			status = NetSendEraseBlockDoodle(outP, V->cData->name,
					length, myDoodle);
		}
	}
	else
	{
		if ((V->cData)&&(V->ispub))
		{
			status = NetSendEraseDoodle(outP, V->cData->name,
					length, myDoodle, doQueue);
		}
	}
	FREE((char *)myDoodle);
	return(status);
}

