GNU inetutils NEWS -- history of user-visible changes.

# Noteworthy changes in release 2.7 (2025-12-14) [stable]

** Systems without asprintf are now supported through the use of gnulib.

** Fix link errors on Solaris 11 OmniOS.

** ftpd: Expanded documentation of user authentication rules.
Thanks to Benjamin Cathelineau, see
<https://lists.gnu.org/archive/html/bug-inetutils/2025-10/msg00000.html>.

** syslogd: Fix a stack-based buffer overflow (CWE-121).

** syslogd: Log 'DEL' control characters as '^?'.

** Fix codespell typos.

** syslogd, talkd: Better compatibility with utmp-less GNU/Linux systems
when configuring with --enable-systemd.
Thanks to Valentin Haudiquet for reporting the issue and testing possible
solutions.  For more info, see the thread starting at
<https://lists.gnu.org/archive/html/bug-inetutils/2025-11/msg00000.html>.

** README and NEWS now uses markdown syntax.

# Noteworthy changes in release 2.6 (2025-02-21) [stable]

** The release tarball is now reproducible.
The following pairs are tested continuously: Trisquel 11 and Ubuntu
22.04, PureOS 10 and Debian 11, AlmaLinux 8 and RockyLinux 8,
AlmaLinux 9 and RockyLinux 9.

** syslogd: Build fixes for macOS.
Thanks to Rui Chen and Caleb Xu, see
<https://savannah.gnu.org/bugs/?65093>.

** Fix link errors of syslogd, talkd and tests/readutmp for --with-systemd.
Thanks to Collin Funk:
https://lists.gnu.org/archive/html/bug-inetutils/2024-03/msg00000.html

** ifconfig: With -A, reject invalid prefix length specifications, and
correctly handle a prefix length of 0.

** ifconfig: Fix a 'dynamic-stack-buffer-overflow' detected by AddressSanitizer
when using the --format or --short option. More details in
<https://lists.gnu.org/archive/html/bug-inetutils/2024-05/msg00020.html>.

** Inetutils can now be built with C23 compilers.
Except for when configured to support Kerberos 4.

** telnet: Fix signed integer overflow handling when using any of the
commands `send do`, `send dont`, `send will`, or `send wont` with a
numerical argument.  On some systems a signed integer overflow using
one of these commands could have lead to an out-of-bounds array access
usually resulting in a crash.

** tests/libls.sh: Work better in container environments (pipelines).
Systems with incomplete /etc/passwd (for uid to username mapping) and
builds where srcdir/builddir is not useful as a test directory due to
spurious unrelated files.

** The release tarball uses tar --format=ustar.
Some other flags are added too, to follow these recommendations:
https://www.gnu.org/software/tar/manual/html_node/Reproducibility.html
For reference, the GNUMakefile file from gnulib add to TAR_OPTIONS:

--owner=0 --group=0 numeric-owner --sort=name

The cfg.mk file further add:

--mode=go+u,go-w --mtime=$(abs_top_srcdir)/NEWS

The modification time of NEWS is always set to last git commit time
before release, see mtime-NEWS-to-git-HEAD in Makefile.am.

We hope that the tarball produced this way is usable on all host but
please let us know if you run into troubles like unpacking the tarball
or that some generated file is rebuilt needlessly requiring some
maintainer tool that shouldn't normally be needed.

** ChangeLog entries for recent releases are now in ChangeLog.2.
The ChangeLog file contains entries since the last release only;
earlier entries are found in ChangeLog.0, ChangeLog.1 or ChangeLog.2
depending on age.  This allows the ChangeLog file to be dynamically
generated even from a shallow git clone that only contain commits
since the last release.

# Noteworthy changes in release 2.5 (2023-12-29) [stable]

** ftpd, rcp, rlogin, rsh, rshd, uucpd

*** Avoid potential privilege escalations by checking set*id() return values.
Reported by Jeffrey Bencteux in
<https://lists.gnu.org/archive/html/bug-inetutils/2023-07/msg00000.html>.

** ping6

*** Support RFC 4443 ICMPv6 destination unreachable messages.
Tiny patch contributed by Enrik Berkhan <Enrik.Berkhan@inka.de> in
<https://lists.gnu.org/archive/html/bug-inetutils/2023-01/msg00000.html>

** Various bugs fixes, internal improvements and clean ups.
The code is now indented using GNU indent 2.2.13.

# Noteworthy changes in release 2.4 (2022-10-25) [stable]

** ifconfig

*** Support specifying prefix netmask lengths in -A.
Patch by Samuel Thibault <samuel.thibault@gnu.org>.

** Hurd: tell pfinet translator interfaces to configure
Patch by Samuel Thibault <samuel.thibault@gnu.org>.

** ftp

*** Avoid crash caused by signed integer overflow resulting in
out-of-bounds buffer access.  Reported by AiDai in
<https://lists.gnu.org/archive/html/bug-inetutils/2021-12/msg00003.html>.

*** Avoid crash caused by heap buffer overflow.  Reported by ZFeiXQ in
<https://lists.gnu.org/archive/html/bug-inetutils/2021-12/msg00016.html>.

*** Avoid crash caused by NULL pointer dereference.  Reported by AiDai in
<https://lists.gnu.org/archive/html/bug-inetutils/2021-12/msg00004.html>.

*** Avoid crash caused by infinite macro recursion.  Reported by AiDai in
<https://lists.gnu.org/archive/html/bug-inetutils/2021-12/msg00005.html>.

** telnetd

*** Avoid crash on 0xff 0xf7 (IAC EC) or 0xff 0xf8 (IAC EL).  CVE-2022-39028
https://pierrekim.github.io/blog/2022-08-24-2-byte-dos-freebsd-netbsd-telnetd-netkit-telnetd-inetutils-telnetd-kerberos-telnetd.html

** telnet

*** Fix a buffer overflow problem.  CVE-2019-0053
https://cgit.freebsd.org/src/commit/?id=14aab889f4e50072a6b914eb95ebbfa939539dad

** tftp

*** Avoid crashing when given unexpected or invalid commands from tty.
Reported by AiDai in
<https://lists.gnu.org/archive/html/bug-inetutils/2021-12/msg00018.html>.

** Various bugs fixes, internal improvements and clean ups.
Update of gnulib and build fixes for C23.

# Noteworthy changes in release 2.3 (2022-07-08) [stable]

** telnet

*** Don't infloop when (malicious) server sends too large terminal
value, see: https://bugs.debian.org/cgi-bin/bugreport.cgi?bug=945861

*** Abort subnegotiation of X Display Location Option with WONT when
DISPLAY value is too large for buffer.  Reported by Joerg Mayer in
<https://lists.gnu.org/archive/html/bug-inetutils/2022-01/msg00010.html>.

*** Fix off-by-one error in Terminal-Type option subnegotiation if the
TERM variable has exactly 44 bytes.  This concerns the CVE-2019-0053
fixes.  Reported by Erik Auerswald in
<https://lists.gnu.org/archive/html/bug-inetutils/2022-02/msg00004.html>.

*** Avoid crashing when given unexpected or invalid commands from tty.
Reported by Peter Kasza in
<https://lists.gnu.org/archive/html/bug-inetutils/2017-06/msg00000.html>,
AiDai in <https://savannah.gnu.org/bugs/?61725> and
<https://savannah.gnu.org/bugs/?61726>, and ZFeiXQ in
<https://lists.gnu.org/archive/html/bug-inetutils/2021-12/msg00017.html>.

** Various bugs fixes, internal improvements and clean ups.

Further cleanup of configure.ac, updates to modern autoconf releases,
and improved gnulib usage.

# Noteworthy changes in release 2.2 (2021-09-01) [stable]

** ftp

The ftp client now validate addresses returned by PASV/LSPV responses,
to make sure they match the server address.  Reported by ZeddYu Lu in
<https://lists.gnu.org/archive/html/bug-inetutils/2021-06/msg00002.html>.

Thanks to Luke Mewburn <lukem@netbsd.org> for discussion and fix to
NetBSD code, we used a similar solution.

** logger
** rlogind

Code for non-getaddrinfo removed, since we are using gnulib to provide
getaddrinfo on any platform that lacks it.  This may have resulted in
logger not using getaddrinfo on platforms that didn't have the
getaddrinfo prototype, even though we use the gnulib module.

** Various bugs fixes, internal improvements and clean ups.

A lot of configure.ac checks were removed that are no longer needed
since we rely on gnulib for portability.

The tests/ftp-localhost.sh self-test no longer fails on platforms
where sysctl is missing.

# Noteworthy changes in release 2.1 (2021-07-24) [stable]

** ftp

Disable use of readline when environment variable TERM is unset or set
to "dumb" (caused problems with Emacs AngeFTP on MacOS).  Thanks to
Alex Bochannek for report, debugging and patch.

** ftpd

Our libls now uses gnulib's fts instead of our own custom version.

** telnet

*** Implement --bind (-b).

This is used to bind to a particular local socket, for compatibility
with NetKit's telnet.

** whois

Updated whois servers for .ORG and .IN.

** Various bugs fixes, internal improvements and clean ups.

ChangeLog is now automatically generated from version controlled logs.
Historical information is preserved as ChangeLog.0 and ChangeLog.1.

# Noteworthy changes in release 2.0 (2021-02-05) [stable]

* ping

** Implement subprivileged echo method.

Add fallback code usable by GNU/Linux to create a datagram socket for
sending ICMP ECHOREQUEST.  The change is related to issue #37252.

* ifconfig

**  Support changing of hardware address.

Implement the setting of link level addresses for systems running
GNU/Linux.

** Statistics for BSD systems.

** A work-around specific to GNU/Hurd.

This system uses a mixture of BSD definitions and GNU/Linux
interfaces.  In particular, some care is needed to check interface
hardware type.

**  Improve the support for GNU/Hurd.

Add system specific abilities, including parsing of command line and
hardware addresses.

** More info on tunnel interfaces.

** Implement a hardware list for BSD systems.

Patterned on the hardware recognition already in use by GNU/Linux, use
a similar mechanism for all of BSD.

** Sporadically appearing regression.

Device flags are sometimes calculated before their query using
SIOCGIFFLAGS.  First observed on GNU/Hurd.

** Apply flags correctly.

When finalizing actions, some flags could be forgotten.  In
particular, the flag 'up' was ignored whenever an address was assigned
at the same time.  This is related to the fact that an invocation only
effecting interface flags, still resulted in a full printout if
interface status.  This latter behaviour differs from all other
implementations and is rather annoying.  The issue was detected and
reported by Hans-Peter Budek in
http://lists.gnu.org/archive/html/bug-inetutils/2015-07/msg00000.html

** Verbose report on changed flags.

** Symbolic name as peer address.

* ftp

** Allow invocation, as well as command `open', to accept an explicit
** remote user name as extended host argument: `user@host'.

** Portability to Android.

Without a check for HAVE_DECL_GETPASS and without making a local
function declaration, the implicit declaration causes crashes on
64-bit systems lacking declared getpass(), such as Android.  See
http://lists.gnu.org/archive/html/bug-inetutils/2016-10/msg00000.html

* ftpd

** Mention mandatory argument for <max-timeout>.

* rcp

** Integer overflow.

During transmission of large files, size exceeding 2GB, a long integer
variable overflows.  Issue reported and identified by Wenlin Kang in
http://lists.gnu.org/archive/html/bug-inetutils/2015-07/msg00004.html

* hostname

** Avoid a trailing space.

Suppress the space character after the last presented IP number.
Problem reported by Terje Strand in
http://lists.gnu.org/archive/html/bug-inetutils/2016-04/msg00001.html

** Make -F handle comment-only input files without trailing newline.
Problem reported by Omer Anson <oaanson@gmail.com> in
https://lists.gnu.org/archive/html/bug-inetutils/2017-06/msg00010.html

* syslogd

** Redefine faulty macro LOG_MAKEPRI whenever needed.

Systems with Glibc header file <syslog.h> prior to 2.17, are not
correctly defining the helper macro LOG_MAKEPRI.  This effects our
syslog service whenever it receives kernel messages from a remote
host.  The issue was mentioned in Debian's BTS as report #729666.

* tftpd

** AIX portability

** Add LOG_NDELAY to openlog().  The file descriptor for logging must
** be active before chrooting happens.

* traceroute

** Subprivileged use case.

A fallback for ICMP tracing relevant to GNU/Linux is implemented,
allowing a rudimentary but suid-less use case.  The ability to
identify intermediary hosts is missing, due to the crippled capability
of receiving ICMP packets other than ICMP_ECHOREPLY.

* telnet

** Telnet -E(no escape) is treating _POSIX_VDISABLE char as escape.

Causes problems when sending binary data through telnet connections.

** Validate supplied environment variables. CVE-2019-0053

* telnetd

** Fix BraveStarr telnetd remote exploit CVE-2020-10188.

We used Debian's patch which is based on a patch to NetKit, see:
https://nvd.nist.gov/vuln/detail/CVE-2020-10188
https://appgateresearch.blogspot.com/2020/02/bravestarr-fedora-31-netkit-telnetd_28.html
https://src.fedoraproject.org/rpms/telnet/raw/master/f/telnet-0.17-overflow-exploit.patch

** Use tty, not pty on Solaris.

Setting of terminal attributes as well setting of window size must be
done via the slave descriptor, not the master descriptor.

** Scrub USER from environment.

Discard the environment variable USER.  It will later be set properly
for autologin, but at least one BSD system passes a preset value when
telnetd starts, a value which will cause rejected login when autologin
is not in effect.

** Portability of TTY termcap to Solaris systems.

** Portable option debugging.

BSD systems assign IAC and _POSIX_VDISABLE the common decimal value
255. Hence the NVT enforces value duplication more often during their
transmission, than GNU and Solaris systems do.

** Premature connection closure.

When many connections are attempted in quick succession, a substantial
number of them are cancelled.  This does not appear for manual use
cases, but for contrived automated set-ups.  The cause seems to be a
change in the evaluation of pty_read(), which was done to coincide
with the condition in use by the original BSD implementation.  Issue
reported and suggested by Chris Severance in
http://lists.gnu.org/archive/html/bug-inetutils/2015-07/msg00006.html

* whois

** Update Canadian TLD server.

Old host name no longer exists.  Reported by Neil Mayhem:
http://lists.gnu.org/archive/html/bug-inetutils/2017-01/msg00000.html

* Improved documentation, self-tests and build environment.

# Noteworthy changes in release 1.9.4 (2015-06-09) [stable]

This is a minor bug release that fixes a regression in `ifconfig'.
The issue was reported by Juergen Daubert in
http://lists.gnu.org/archive/html/bug-inetutils/2015-05/msg00002.html

# Noteworthy changes in release 1.9.3 (2015-05-12) [stable]

* ftp

An old inability to allow other names than the canonical name has
been corrected.  This means that a machine entry in the .netrc file
will now be used as expected.  Previously any alias name was replaced
by the corresponding canonical name, before reading the .netrc file.

The internal command `hash' accepts a suffixed letter to the size
argument, like `12k', instead of 12288.  Made a minor change to the
syntax of the command itself, allowing size changes independently
of activation of hash markings.  After a transfer the summary gives
the speed as `Mbytes/s', `kbytes/s', or `bytes/s'.

The .netrc file can be overridden by the environment variable NETRC.
Of even higher precedence is the new option `-N/--netrc'.  The access
to the resulting file, whatever method, is now denied unless it is a
regular file.

* ifconfig

Better command line parsing on BSD and Solaris systems.  Touch only
changeable flags on all systems.

* logger

The ability to use numerical facilities is restored to full range.

* ping, ping6

The ability to specify a pattern as payload is corrected.

* syslogd

A new switch `-T/--local-time' makes the service ignore a time
stamp passed on by the remote host, recording instead the local
time at the moment the message was received.  As a short form of
`--pidfile', the switch `-P' is new.

In common with other syslogd implementations, rsyslogd and sysklogd,
there has for a long time existed an attack vector based on large
facility numbers, made public in CVE-2014-3684.  This is now mended
in our code base.

* telnetd

The ability to autologin a client, without using authentication,
is now functional in the expected manner, i.e., the prompt for a
user name is suppressed in favour of an immediate password prompt.

In a setting where the client is using a UTF-8 encoding, it was
common to observe strange characters in most responses.  This was
caused by the server daemon, due to incomplete purging of internal
protocol data.  The issue should now be resolved.

* whois

Improved cooperation with servers like `whois.arin.net', `whois.eu',
and `whois.ripe.net'.

# Noteworthy changes in release 1.9.2 (2013-12-23) [stable]

An advisory file CHECKLIST containing testing and verification advice
has been added, pointing administrators to important properties and
settings for built executables.

* IDN -- International Domain Names

The clients `ftp', `ping', `ping6', `talk', `telnet', `tftp', and
`traceroute' are now capable of using libidn when resolving domain
names with character sets richer than ASCII.

Systems using the GNU C library achieve this ability by other means in
the present code, so they do not need to link against libidn at all.

* New tool 'dnsdomainname'.

* ftp

Called as `pftp', passive mode is preset.  New switch `-e/--no-edit'
for compatibility with other implementations.  Can now be built
without readline by passing `--disable-readline' to configure.  New
command `lpwd' avoids a shell call for a common task.  The legacy
limit for lengths of input lines (previously 200) has been removed.
Now it is system dependent and is common with most other tools.

* ifconfig

Provides new support for BSD and improved support for Solaris.
Argument handling has been corrected to avoid some segfaults.

* ping

New switches `--ip-timestamp', `--mask', `-T/--tos' and `--ttl'.  Can
use file capabilities instead of suid-setting.

* ping6

New switches `--hoplimit/--ttl', `-T/--tos' and `-v/--verbose'.  File
capabilities are sufficient.

* rcp

Supports IPv6 and Shishi.  New switches `-4/--ipv4', `-6/--ipv6',
`-k/--realm', `-K/--kerberos', and `-x/--encrypt'.  A file capability
like `cap_net_bind_service' can be applied instead of installing the
binary setuid.

* rexec

Supports IPv6.  New switches `-4/--ipv4', `-6/--ipv6', `-a/--ipany'

* rlogin, rsh

Support IPv6.  New switches `-4/--ipv4', `-6/--ipv6'.  A file
capability like `cap_net_bind_service' can be applied instead of
installing the binary setuid.

* syslogd

Messages can be logged to specific files according to the name of the
submitting program, on the tag attached to the message.  The mechanism
is patterned after same feature used in on BSD.

Support loading of multiple configuration files located in a single
directory.  New switches `-D/--rcdir'.

* telnet

New switch `-k/--realm'.

* traceroute

Default mode is now UDP, for better conformity with Unices.  New
switches `-f/--first-hop', `-g/--gateways', `-I/--icmp',
`-m/--max-hop', `-t/--tos', and `-w/--wait'.  File capabilities
suffice.

* ftpd

Full IPv6 support.  PAM support for Linux-PAM, OpenPAM, and Sun-PAM as
service `ftp'.  Observe that the latter two implementations only
affect non-anonymous access, since `pam_ftp.so' exists for Linux-PAM
only, so the standard checks are enforced on `ftp/anonymous' as usual.
The server now accepts the commands LPRT and LPSV.

The parsing of `/etc/ftpusers' and `/etc/ftpchroot' now allows the
specification of group names, simply by preceding the identifier with
an at-sign `@'.  An isolated `@' acts as a wildcard and matches every
user name.  In addition, the parser is more forgiving of spaces and
tabs, thus achieving better portability of these two files when
compared with other systems.

The server will by default not disclose that the requested user name
is invalid, but will instead proceed with a faked password dialogue.
This is in accordance with RFC 2577.  The new option `--non-rfc2577'
will now restore the legacy type responses, informing about
non-existing users and also about expired accounts, or expired
passwords.

* inetd

Service configuration now allows setting also the group.

* rexecd

Can be built with PAM support as service `rexec'.  New option
`-l/--logging'.

* rlogind

Support for IPv6 and PAM as services `rlogin' and `krlogin'.
Buildable with libwrap support for use in stand-alone daemon mode.
New switches `-4/--ipv4', `-6/--ipv6', and `-S/--server-principal'.

* rshd

Now has support for IPv6, PAM, and Shishi, with PAM services `rsh' and
`krsh'.  New switches `-k/--kerberos', `-r/--reverse-required',
`-S/--server-principal', `-v/--vacuous', and `-x/--encrypt'.

* talkd

Has seen reworked ACL-mechanisms, believed to be functional!  New
switches `-l/--logging', and `-S/--strict-policy'.

* telnetd

New switch `-S/--server-principal'.

* tftpd

New switches `-g/--group', `-s/--secure-dir', and `-u/--user'.

* uucpd

New switch `-u/--uucico'.

# Noteworthy changes in release 1.9.1 (2012-01-06) [stable]

* Don't install git-merge-changelog.

# Noteworthy changes in release 1.9 (2011-12-31) [stable]

* Security fixes

This release fixes a security flaw in telnetd that could lead to
remote access.

* Solaris is now a supported platform

Support is still new, so please report any bugs to
<bug-inetutils@gnu.org>.

* Many OpenBSD fixes.

* ftp, tftp, tftpd

Handle IPv6 connections.  ftpd is still IPv4-only until next release.

* syslogd, logger

Handle IPv6 connections.  The server can forward messages without
using a listening INET socket.  It can also bind to a single
INET/INET6 address.

* rlogind, rshd

This legacy code was vulnerable to an attack based on source routing.
Whenever either of IPOPT_SSRR or IPOPT_LSRR is encountered, the newly
initiated connection is now server-side aborted.  The advisory issued
by Secure Networks, Inc., February 1997, was adapted.  It was found at
http://www.citi.umich.edu/u/provos/papers/secnet-spoof.txt

* ifconfig

Now under GNU/Linux "ifconfig -a" shows also interfaces without an
address.

Adjusted output formatting for "unix".

* ping

Now supports -W parameter to specify number of seconds to wait for
response.

* Various bugs fixes, internal improvements and clean ups.

# Noteworthy changes in release 1.8 (2010-05-15) [stable]

* ftp

New options --active and --passive to enable/disable active transfer
mode.  The short option for --prompt has been removed, and is instead
now used to enable passive transfer mode.

* ifconfig

New commands (up and down) to bring up/down an interface using
ifconfig.

The short option for --address, -a, has been renamed to -A.  And --all
now uses -a instead.

New commands (multicast, allmulti) to set multicast flags.

New option -s displays a short list of interfaces (similar to netstat
-i).

The --format option can be used to read format from a file.  To do so,
prefix the file name with a '@' sign, e.g.:

          ifconfig --format=@FILE

The contents of this file is read literally, except that the lines
beginning with a `#' sign are ignored (and can thus be used to
introduce comments).

To obtain a list of the available built-in output formats, use

         ifconfig --format=help

When used with the --verbose option, --format=help also displays
format definitions.

* Man pages for the daemons are now in section 8 instead of 1.

* There is now a man page for ping6 too.

# Noteworthy changes in release 1.7 (2009-12-16) [stable]

* ping

New option --timeout=N, stop sending packets after N seconds.

* New logger implementation

The `logger' utility has been rewritten from scratch.  The new
implementation offers many new facilities.  In particular, it
is able to send messages to system loggers on remote machines, and
to supply the PID number to include in messages, instead of the
PID of the `logger' process.

* Restore the traditional behavior of ping without -c option.

* The manual is now licensed under the GNU FDL version 1.3 or later.

* rexec

New program.

* tftp

Command line parsing now uses argp.

* Man pages for all tools are generated using help2man.

# Noteworthy changes in release 1.6 (2008-12-27) [stable]

* Various bugs fixes and clean ups.

* hostname, traceroute

New programs.

* ping and ping6 now exit after four packets instead of pinging forever.

The previous behaviour can be enabled by passing `--count 0' to ping
(or ping6).

* telnet now delays initialization of Shishi until Kerberos is needed

* inetd

The configuration file syntax has been extended to allow for supplying
local addresses `inetd' should use when listening for a given service.
The addresses may be specified on a per-server basis as well as
globally (affecting several services).

It is possible to limit the number of service instances for `nowait'
services.

# Noteworthy changes in release 1.5 (2006-10-21) [stable]

* Various bugs fixes and clean ups.

* inetd

** New option --environment enables passing client/server data via
environment variables.

** New option --resolve enables resolving IP addresses before passing
them via environment.

** Allows numeric port names as service names

** inetd now creates a PID file

* rcp now supports the -V option

* rshd/rexecd now switches to the users home directory after
  authentication.

* rlogin now supports XON/XOFF without needing -8.

* syslogd now can actually disable forwarding.

* talk allows the use of 8-bit ASCII.

* telnet not subject to certain DNS spoofing techniques that could
  possibly foil Kerberos authentication.

# Noteworthy changes in release 1.4.2 (2002-12-22) [stable]

* Fix endianness problem in ftpd.

* Various portability updates.

* Security fix for rexecd/rshd.

* Fix processing accumulated messages in syslogd

# Noteworthy changes in release 1.4.1 (2002-09-02) [stable]

* Fixes a build problem on Solaris

* rsh now honours -V as well as --version

* Fixed a security problem with rshd where new files were being
  created as uid 0.

* Fixed improper ping initialization.

* The syntax of syslog.conf file has been extended. The new
  wildcard facility specification, **, catches all messages with
  a facility not specified explicitly in the configuration file.

# Noteworthy changes in release 1.4.0 (2002-07-31) [stable]

* It is now possible to specify whether to compile individual
  utilities using arguments to configure.

* The GNU networking utilities manual has been started.

* If you have the GNU readline library installed, it will now be used
  by the ftp client.

* There is now a whois client.

* Several security fixes and other bug fixes have been applied.

* The inetd server can read configuration file snippets from
  /etc/inetd.d/.

* The talkd and telnetd servers have been essentially rewritten.

* The ping program was added.

* The syslogd server supports several new features in the
  configuration file, like omitting file sync, piping messages into
  programs etc.  It also supports several new options on the command
  line.

* Inetutils should generally compile on most platforms now.

# Noteworthy changes in release 1.3.2 (1998-03-13) [stable]

This release attempts to get the encryption/authentication options to
compile correctly; they appear to work on systems with the appropriate
libraries, but have not been well tested.

# Noteworthy changes in release 1.3.1 (1997-09-11) [stable]

This release fixes various small problems.

Telnet now won't force the stripping of 8-bit characters when not in binary
mode (it will leave the terminal in whatever state it was originally).

# Noteworthy changes in release 1.3 (1997-02-25) [stable]

More portable again than 1.2.  It is still very BSD-specific, but now
works on many popular systems, such as linux and sunos/solaris.

The talk program finally seems to work.

ftp now supports a --prompt option to force it to print a prompt, even
when not on a tty (this makes it possible to use ange-ftp with pipes).

rsh now supports long options.

Many security fixes have been made, so this release should be more secure
than previous ones.

# Noteworthy changes in release 1.2 (1996-08-21) [stable]

An attempt to be somewhat more portable, and reorganize the code to make
porting a bit easier; it is still very BSD-specific.

A major bug in ftpd bug that prevents most logins from succeeding is
fixed, as well as other, more minor, bugs.

# Noteworthy changes in release 1.1 (1996-06-30) [stable]

A minor release intended only for the GNU hurd.

This release adds checking for crypt at both compile and runtime (on
systems where weak refs are supported).

# Noteworthy changes in release 1.0 (1996-06-09) [stable]

Never released, corresponds to first use of GNU inetutils 1.0 in CVS.

----------------------------------------------------------------------
Copyright (C) 1997-2025 Free Software Foundation, Inc.

Permission is granted to anyone to make or distribute verbatim copies
of this document as received, in any medium, provided that the
copyright notice and this permission notice are preserved, thus giving
the recipient permission to redistribute in turn.

Permission is granted to distribute modified versions of this
document, or of portions of it, under the above conditions, provided
also that they carry prominent notices stating who last changed them.
