/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;

class DialogUtils {
    private final ViewFetcher viewFetcher;
    private final Sleeper sleeper;

    public DialogUtils(ViewFetcher viewFetcher, Sleeper sleeper) {
        this.viewFetcher = viewFetcher;
        this.sleeper = sleeper;
    }

    public boolean waitForDialogToClose(long timeout) {
        this.sleeper.sleepMini();
        int elementsBefore = this.viewFetcher.getWindowDecorViews().length;
        long now = System.currentTimeMillis();
        long endTime = now + timeout;
        while (now < endTime) {
            int elementsNow = this.viewFetcher.getWindowDecorViews().length;
            if (elementsBefore < elementsNow) {
                elementsBefore = elementsNow;
            }
            if (elementsBefore > elementsNow) break;
            this.sleeper.sleepMini();
            now = System.currentTimeMillis();
        }
        return now <= endTime;
    }
}

