/*
 * Decompiled with CFR 0.152.
 */
package org.gnutelephony.bayonne;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class Libexec {
    protected String _tsid = System.getProperty("bayonne.tsid");
    protected String _home = System.getProperty("bayonne.home");
    protected String _ramfs = System.getProperty("bayonne.ramfs");
    protected String _tmpfs = System.getProperty("bayonne.tmpfs");
    protected String _query = "";
    protected String _digits = "";
    protected String _position = "00:00:00.000";
    protected int _exitcode = 0;
    protected int _resultcode = 0;
    protected int _reply = 0;
    private String _voice = null;
    private short _tonelevel = 0;
    private Map _head = new HashMap();
    private Map _args = new HashMap();
    private BufferedReader _in = new BufferedReader(new InputStreamReader(System.in));

    public static String getVersion() {
        return "4.0";
    }

    public Libexec() {
        String string;
        String string2;
        int n;
        String string3;
        if (this._tsid == null) {
            this._exitcode = 3;
            return;
        }
        System.out.println(String.valueOf(this._tsid) + " HEAD");
        while (this._exitcode < 1) {
            try {
                string3 = this._in.readLine();
            }
            catch (IOException iOException) {
                string3 = null;
            }
            if (string3 == null) {
                this._exitcode = 3;
                break;
            }
            if (string3.length() < 4) break;
            try {
                n = Integer.parseInt(string3.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n > 900) {
                this._exitcode = n - 900;
            }
            if (n > 0) {
                this._reply = n;
                continue;
            }
            n = string3.indexOf(58);
            string2 = string3.substring(0, n);
            string = string3.substring(n += 2);
            this._head.put(string2, string);
        }
        System.out.println(String.valueOf(this._tsid) + " ARGS");
        while (this._exitcode < 1) {
            try {
                string3 = this._in.readLine();
            }
            catch (IOException iOException) {
                string3 = null;
            }
            if (string3 == null) {
                this._exitcode = 3;
                break;
            }
            if (string3.length() < 4) break;
            try {
                n = Integer.parseInt(string3.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n > 900) {
                this._exitcode = n - 900;
            }
            if (n > 0) {
                this._reply = n;
                continue;
            }
            n = string3.indexOf(58);
            string2 = string3.substring(0, n);
            string = string3.substring(n += 2);
            this._args.put(string2, string);
        }
    }

    public void postSymbol(String string, String string2) {
        String string3 = this.getHead("SESSION");
        System.out.println(String.valueOf(string3) + " POST " + string + " " + string2);
    }

    public String getPosition() {
        return this._position;
    }

    public int lastResult() {
        return this._resultcode;
    }

    public int getExit() {
        return this._exitcode;
    }

    public void echo(String string) {
        if (this._tsid == null) {
            System.out.println(string);
        } else {
            System.err.println(string);
        }
    }

    public String getHead(String string) {
        return (String)this._head.get(string);
    }

    public String getArg(String string) {
        return (String)this._args.get(string);
    }

    public boolean isLive() {
        return this._tsid != null && this._exitcode <= 0;
    }

    public String getPath(String string) {
        String string2 = this.getHead("EXTENSION");
        String string3 = this.getHead("PREFIX");
        if (string2 == null) {
            string2 = ".au";
        }
        if (string == null) {
            return null;
        }
        if (string.startsWith("/") || string.startsWith(".")) {
            return null;
        }
        if (string.substring(1, 1) == ":") {
            return null;
        }
        if (string.indexOf("..") > 0 || string.indexOf("/.") > 0) {
            return null;
        }
        int n = string.lastIndexOf(47);
        int n2 = string.lastIndexOf(46);
        if (n2 < n) {
            n2 = 0;
        }
        if (n2 < 1) {
            string = String.valueOf(string) + string2;
        }
        if (string.startsWith("tmp:")) {
            return String.valueOf(this._tmpfs) + "/" + string.substring(4);
        }
        if (string.startsWith("ram:")) {
            return String.valueOf(this._ramfs) + "/" + string.substring(4);
        }
        if (string.indexOf(58) > 0) {
            return null;
        }
        if (string.indexOf(47) < 1 && string3 != null) {
            return String.valueOf(this._home) + "/" + string3 + "/" + string;
        }
        if (string.indexOf(47) < 1) {
            return null;
        }
        return String.valueOf(this._home) + "/" + string;
    }

    public void hangup() {
        if (this._tsid == null || this._exitcode > 0) {
            return;
        }
        System.out.println(String.valueOf(this._tsid) + " HANGUP");
        this._tsid = null;
    }

    public void error(String string) {
        if (this._tsid == null || this._exitcode > 0) {
            return;
        }
        System.out.println(String.valueOf(this._tsid) + " ERROR " + string);
        this._tsid = null;
    }

    public void detach(int n) {
        if (this._tsid == null || this._exitcode > 0) {
            return;
        }
        if (n < 0 || n > 255) {
            n = 255;
        }
        System.out.println(String.valueOf(this._tsid) + " EXIT " + n);
        this._tsid = null;
    }

    protected int command(String string) {
        int n = 0;
        this._resultcode = 255;
        this._query = "";
        if (this._tsid == null || this._exitcode > 0) {
            return 255;
        }
        System.out.println(String.valueOf(this._tsid) + " " + string);
        block10: while (this._exitcode < 1) {
            String string2;
            try {
                string2 = this._in.readLine();
            }
            catch (IOException iOException) {
                string2 = null;
            }
            if (string2 == null) {
                this._exitcode = 3;
                return 255;
            }
            if (string2.length() < 4) break;
            try {
                n = Integer.parseInt(string2.substring(0, 3));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            if (n > 900) {
                this._exitcode = n - 900;
                return 255;
            }
            if (n > 0) {
                this._reply = n;
                continue;
            }
            n = string2.indexOf(58);
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 2);
            switch (this._reply) {
                case 100: {
                    if (string3 == "RESULT") {
                        try {
                            this._resultcode = Integer.parseInt(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this._resultcode = 255;
                        }
                        continue block10;
                    }
                    if (string3 == "DIGITS") {
                        this._digits = string4;
                        break;
                    }
                    if (string3 != "POSITION") break;
                    this._position = string4;
                    break;
                }
                case 200: {
                    this._resultcode = 0;
                    this._query = string4;
                }
            }
        }
        return this._resultcode;
    }

    public int replayFile(String string) {
        return this.command("REPLAY " + string);
    }

    public int replayOffset(String string, String string2) {
        return this.command("REPLAY " + string + " " + string2);
    }

    public int recordFile(String string, long l, long l2) {
        return this.command("RECORD " + string + " " + l + " " + l2);
    }

    public int recordOffset(String string, String string2, long l, long l2) {
        return this.command("RECORD " + string + " " + l + " " + l2 + " " + string2);
    }

    public int eraseFile(String string) {
        if ((string = this.getPath(string)) == null) {
            this._resultcode = 254;
            return 254;
        }
        boolean bl = new File(string).delete();
        if (!bl) {
            this._resultcode = 1;
            return 1;
        }
        this._resultcode = 0;
        return 0;
    }

    public int moveFile(String string, String string2) {
        string = this.getPath(string);
        string2 = this.getPath(string2);
        if (string == null || string2 == null) {
            this._resultcode = 254;
            return 254;
        }
        boolean bl = new File(string).renameTo(new File(string2));
        if (!bl) {
            this._resultcode = 1;
            return 1;
        }
        this._resultcode = 0;
        return 0;
    }

    public boolean setVoice(String string) {
        this._voice = string;
        return true;
    }

    public void setLevel(short s) {
        this._tonelevel = s;
    }

    public int clearInput() {
        return this.command("FLUSH");
    }

    public char readKey(long l) {
        if (this._tsid == null || this._exitcode > 0) {
            return '\u0000';
        }
        this._digits = "";
        if (this.command("READ " + l) > 0) {
            return '\u0000';
        }
        if (this._digits.length() < 1) {
            return '\u0000';
        }
        return this._digits.charAt(0);
    }

    public String readInput(short s, long l) {
        if (this._tsid == null || this._exitcode > 0) {
            return "";
        }
        this._digits = "";
        if (this.command("READ " + l + " " + s) > 0) {
            return "";
        }
        return this._digits;
    }

    public boolean waitInput(long l) {
        if (this._tsid == null || this._exitcode > 0) {
            return false;
        }
        this._digits = "";
        if (this.command("WAIT " + l) > 0) {
            return false;
        }
        return this._digits.length() > 0;
    }

    public int sendResult(String string) {
        return this.command("RESULT " + string);
    }

    public int speak(String string) {
        String string2 = "PROMPT";
        if (this._voice != null) {
            string2 = this._voice;
        }
        return this.command(String.valueOf(string2) + " " + string);
    }

    public int playTone(String string, long l) {
        return this.command("TONE " + string + " " + l + " " + this._tonelevel);
    }

    public int playSingleTone(short s, long l) {
        return this.command("STONE " + s + " " + l + " " + this._tonelevel);
    }

    public int playTone(short s, short s2, long l) {
        return this.command("DTONE " + s + " " + s2 + " " + l + " " + this._tonelevel);
    }

    public int sizeSymbol(String string, int n) {
        return this.command("NEW " + string + " " + n);
    }

    public int setSymbol(String string, String string2) {
        return this.command("SET " + string + " " + string2);
    }

    public int addSymbol(String string, String string2) {
        return this.command("ADD " + string + " " + string2);
    }

    public String getSymbol(String string) {
        if (this._tsid == null || this._exitcode > 0) {
            return null;
        }
        this._query = "";
        this._reply = 0;
        this.command("GET " + string);
        if (this._reply != 200) {
            return null;
        }
        return this._query;
    }
}

