.\" $Id: xboard.man,v 1.25 1994/05/22 02:23:03 mann Exp $
.TH xboard 6 "$Date: 1994/05/22 02:23:03 $" "GNU"
.SH NAME
xboard \- X user interface for GNU Chess, the Internet Chess Server (ICS),
and electronic mail correspondence chess.
.SH SYNOPSIS
To run with GNU Chess:
.B xboard [options]
.br
To run with the ICS:
.B xboard -ics [options]
.br
To play email chess: See
.IR cmail (6).
.br
To run standalone:
.B xboard -ncp [options]
.SH DESCRIPTION
.IR xboard
is a graphical chessboard that can serve as a
user interface for GNU Chess, for the Internet Chess Server, 
or for electronic mail correspondence chess.
.IR xboard 
can also be used by itself.
.PP
As an interface to GNU Chess,
.IR xboard
lets you play a game against the machine,
set up arbitrary positions,
force variations, or watch
a game between two machines.
.PP
As an interface to the Internet Chess Server (ICS),
.I xboard -ics
lets you play against other ICS users,
observe games they are playing, or review
games that have recently finished.
.PP
As an interface to electronic mail correspondence chess,
.IR xboard
works with the
.IR cmail (6)
program.  See its manual page for instructions.
.PP
You can also use
.IR xboard
as a chessboard to play through games.
It will read and write game files and allow you to play 
through variations manually.
You can use it to browse games off the net
or review GNU Chess, ICS, and correspondence games you have saved.  
These features are available at all times; even if you do not have
access to GNU Chess or the ICS, you can use them by giving the command
.IR "xboard -ncp" .
.PP
After starting
.IR xboard ,
you make moves by dragging pieces with the mouse.  
Press mouse button 1 while the cursor is on one of your pieces, then
move the cursor to another square and release the button.
.SH OPTIONS
Most of the 
.IR xboard
options have both a long name and a short name.
To turn a boolean option on or off from the command line, either give
its long name followed by the value True or False
.RI ( -longOptionName
True), or give
just the short name to turn the option on
.RI ( -opt ),
or the short name preceded by "x" to turn the option off
.RI ( - x opt ).
For options that take strings or numbers as values, you can use the long or
short option names interchangeably.
.PP
Each option corresponds to an X resource
with the same name, so you can set options in your
.IR \&.Xdefaults
file if you like.
For options that have two names, the longer
one is the name of the corresponding X resource; the short name is not
recognized in \&.Xdefaults.
To turn a boolean option on or off in your \&.Xdefaults
file, give its long name followed by the value True or False 
.RI (XBoard* longOptionName :
True).

.SH GNU Chess Options
.TP 8
.B -tc or -timeControl minutes[:seconds]
.PD 0
.TP 8
.B -mps or -movesPerSession moves
Each player begins with the specified amount of time on his clock.
If a player makes the specified number of moves before his clock runs out,
.IR xboard
adds the specified amount of time to his clock.
Default: 40 moves in 5 minutes.  
.PD
.TP 8
.B -clock or -clockMode
Determines whether or not to display the chess clocks.
If clockMode is False, the clocks are not shown, but the
side that is to play next is still highlighted.  Also, unless 
searchTime or searchDepth is set, GNU Chess still keeps track of the
clock time and uses it to determine how fast to make its moves.
.TP 8
.B -st or -searchTime minutes[:seconds]
Tells GNU Chess to spend at most the given amount of time searching
for each of its moves.  Without this option, GNU Chess chooses
its search time based on the number of moves and amount of time
remaining until the next time control.
Setting this option also sets clockMode to False.
.TP 8
.B -sd or -searchDepth number
Tells GNU Chess to look ahead at most the given number of moves when searching
for a move to make.  Without this option, GNU Chess chooses
its search depth based on the number of moves and amount of time
remaining until the next time control.
Setting this option also sets clockMode to False.
.TP 8
.B -mm or -matchMode
Automatically runs a game between two chess programs.
If the loadGameFile or loadPositionFile option is set, 
.IR xboard
starts the game with the given opening moves or the given
position; 
otherwise, the game starts with the standard initial chess position.
If the saveGameFile 
option is set, a move record for the match
is appended to the specified file.
If the savePositionFile 
option is set, the final position reached in the match
is appended to the specified file.
When the match is over, 
.IR xboard
exits.
Default: False.
.TP 8
.B -fcp or -firstChessProgram program
Name of first chess program.
In matches between two machines, this program plays black.
Default: "gnuchessx".
.TP 8
.B -scp or -secondChessProgram program
Name of second chess program, if needed.
In matches between two machines, this program plays white; otherwise
it is not started.
Default: "gnuchessx".
.TP 8
.B -fh or -firstHost host
Name of host the first chess program plays on.
Default: "localhost".
.TP 8
.B -sh or -secondHost host
Name of host the second chess program plays on.
Default: "localhost".
.TP 8
.B -rsh or -remoteShell shell-name
Some systems do not use rsh as the remote shell.
This option allows a user to name the remote shell command.
.TP 8
.B -initString string
The string that is sent to initialize the chess program.
Default: "new\\nbeep\\nrandom\\neasy\\n".

If you change this option, don't remove the "new" and "beep" commands.
You can remove the "random" command if you
like; including it causes GNU Chess to randomize its move selection slightly so
that it doesn't play the same moves in every game.  
(Even without "random", GNU Chess
randomizes its choice of moves from its opening book.)
You can also remove "easy" if you like; including it toggles easy mode
off, causing GNU Chess to think on your time.
That is, if "easy" is 
.IR included
in the initString, GNU Chess thinks
on your time; if not, it does not.  
(Yes, this does seem backwards, doesn't it!)
To see what GNU Chess is thinking about, you can add the "post" 
command and run 
.IR xboard
with debugMode turned on.
You can also try adding other commands to the initString; 
see the GNU Chess documentation for details.
.TP 8
.B -whiteString string
.PD 0
.TP 8
.B -blackString string
These options control what is sent when the Machine White and Machine Black
buttons are selected.  This is mostly for compatibility with obsolete versions
of GNU Chess.
.PD
.SH Internet Chess Server Options
.TP 8
.B -ics or -internetChessServerMode
Connect with an Internet Chess Server to play chess against
its other users, observe games they are playing, or
review games that have recently finished.  Default: False.

To use xboard in ICS mode, run it in the foreground, and use the
terminal you started it from to type commands and receive text responses
from the chess server.  Useful ICS commands include
.IR who
to see who is logged on,
.IR games
to see what games are being played,
.IR match
to challenge another player to a game,
.IR observe
to observe an ongoing game,
.IR examine
or
.IR oldmoves
to review a recently completed game,
and of course
.IR help .
Whenever you ask to observe an ongoing game, review a completed game, or
resume an adjourned game,
.IR xboard
retrieves and parses the list of past moves from the ICS, so
you can review them with the Forward and Backward commands
or save them with Save Game.

You can create a script file containing ICS commands that 
.IR xboard
will type in for you whenever you connect to the ICS.  See FILES below.
.TP 8
.B -autoflag or -autoCallFlag
If autoCallFlag is True and your opponent runs out of time
before you do,
.IR xboard
will automatically call his flag, claiming a win on time (or a draw
if you do not have mating material).
Default: False.
.TP 8
.B -quiet or -quietPlay
If this option is True, 
.IR xboard
will automatically issue a "set shout 0" command whenever you start an ICS
game and a "set shout 1" command whenever you finish one.  Default: False.
.TP 8
.B -icshost or -internetChessServerHost host
The Internet host name or address of the chess server to connect 
to when in ICS mode.  
Default: ics.uoknor.edu.  Other values to try: 
anemone.daimi.aau.dk, coot.lcs.mit.edu, chess.pitt.edu.

If your site doesn't have a working Internet name server, try 
specifying the host address in numeric form.  The addresses for the hosts
given above are respectively 129.15.10.21, 
130.225.18.58, 18.52.0.70, and 136.142.81.40.
.TP 8
.B -icsport or -internetChessServerPort port-number
The port number to use when connecting to a chess server in ICS mode.
Default: 5000.
.TP 8
.B -gateway
If this option is set to a host name,
.IR xboard
uses
.IR rsh
to run telnet on the given host to communicate with the Internet
Chess Server instead of opening a direct TCP connection.

This option is useful if your machine is unable
to connect directly to the ICS but is able
to rsh to a gateway host that can connect to the ICS.
As an example, suppose the gateway host is
called gate.wassamatta-u.edu, and you set options as
follows:
.EX 4
-gateway gate.wassamatta-u.edu
-internetChessServer ics.uoknor.edu
-internetChessServerPort 5000
.EE
Then when you run
.IR xboard
in ICS mode, it will connect to the ICS by using rsh
to run the command "telnet ics.uoknor.edu 5000" on
host gate.wassamatta-u.edu.
.TP 8
.B -telnet or -useTelnet
If this option set to True,
.IR xboard 
runs the 
.IR telnet (1)
program to communicate with the Internet Chess
Server instead of opening a direct TCP connection.
The default is False.  

One case where this option is useful is
if your machine is unable to connect directly
to the ICS but is able to telnet to a gateway host that can
connect to the ICS.  It is more general than the gateway 
option, because you may be able to telnet to a host that 
you cannot rsh to, but it's not as convenient to use.
As an example, suppose the gateway host is
called gate.wassamatta-u.edu, and you set options as
follows:
.EX 4
-useTelnet true
-internetChessServer gate.wassamatta-u.edu
-internetChessServerPort 23
.EE
Then when you run
.IR xboard
in ICS mode, you will get a login prompt from the gateway host.
Log in there and run the telnet program (giving a command like
"telnet ics.uoknor.edu 5000") to connect to the ICS.
This works because giving the option "-internetChessServerPort 23" causes 
.IR xboard 
to connect to the gateway host's standard incoming telnet service instead of 
trying to connect to a chess server running on the gateway host.
.PP
.TP 8
.B -telnetProgram
This option gives the name of the telnet program to be used with the 
gateway and useTelnet options.  The default is "telnet".  The 
telnet program 
is invoked with the value of internetChessServer as its first argument
and the value of internetChessServerPort as its second argument.
.PP
.SH Load and Save Options
.TP 8
.B -lgf or -loadGameFile file
.PD 0
.TP 8
.B -lgi or -loadGameIndex index
If the loadGameFile option is set,
.IR xboard
loads the specified position file at startup.
If the loadGameIndex option is set to N, 
the
.IR N th
game found in the file is loaded; otherwise the first game is loaded.
.PD
.TP 8
.B -td or -timeDelay seconds
Time delay between moves during "Load Game".
Fractional seconds are allowed; try -td 0.4.  
A time delay value of -1 tells
.IR xboard
not to step through game files automatically.
Default: 1 second.
.TP 8
.B -sgf or -saveGameFile file
If this option is set, 
.IR xboard 
appends a record of every game played to the specified file.
.TP 8
.B -autosave or -autoSaveGames
If this option is True, at the end of every game
.IR xboard
prompts you for a file name and appends a record
of the game to the file you specify.  Ignored if autoSaveGames is set.
.TP 8
.B -lpf or -loadPositionFile file
.PD 0
.TP 8
.B -lpi or -loadPositionIndex index
If the loadPositionFile option is set,
.IR xboard
loads the specified position file at startup.
If the loadPositionIndex option is set to N, 
the
.IR N th
position found in the file is loaded; otherwise the first position is loaded.
.PD
.TP 8
.B -spf or -savePositionFile file
If this option is set, 
.IR xboard 
appends the final position reached in
every game played to the specified file.
.TP 8
.B -oldsave or -oldSaveStyle
If this option is False (the default), 
.IR xboard
saves games in PGN (portable game notation) and positions in FEN
(Forsythe-Edwards notation).  If the option is True, 
a save style that is compatible with older versions of
.IR xboard
is used instead.
.SH User Interface Options
.TP 8
.B standard Xt options
.IR xboard
accepts standard Xt options like -display, -geometry, and -iconic.
.TP 8
.B -bell or -ringBellAfterMoves
If this option is True,
.IR xboard
alerts you by ringing the terminal bell after each
of your opponent's moves (or after every move if
you are observing a game on the Internet Chess Server).
The bell is not rung after moves you make 
or moves read from a saved game file.  Default: False.

If you turn on this option when using
.IR xboard
with the Internet Chess Server, you will probably want to
give the "set bell 0" command to the ICS, since otherwise the ICS
will ring the bell itself after every move (not just yours).
.TP 8
.B -queen or -alwaysPromoteToQueen
If this option is False (the default),
.IR xboard
brings up a dialog box whenever you move a pawn to the last rank,
asking what piece you want to promote it to.  
If the option is True, your pawns are always promoted to
queens.  (Your opponent can still underpromote, however.)
.TP 8
.B -size or -boardSize "(Large | Medium | Small)"
Determines how large the board will be and what built-in piece bitmaps
will be used.  On a large board (the default), 
pieces are 80x80 pixels, on a medium board 64x64 pixels, and
on a small board 40x40 pixels.
.TP 8
.B -coords or -showCoords
If this option is True,
.IR xboard
displays algebraic coordinates along the board's left and bottom edges.
The default is False.  The
.IR coordFont
option specifies what font to use.  
.TP 8
.B -flip or -flipView
If you are
playing a game on the ICS, the board is always
oriented at the start of the game so that your 
pawns move from the bottom of the window towards the top.
Otherwise, the starting is determined by the flipView option; if it is
False (the default), White's pawns move from bottom to top at the
start of each game; if it is True, Black's pawns move from bottom to top.
.TP 8
.B -title or -titleInWindow 
If this option is True, 
.IR xboard
displays player names (for ICS games) and game file names (for Load
Game) inside its main window.  If the option is False (the default),
this information is displayed only in the window banner.  You probably
won't want to set this option unless the information is not showing up
in the banner, as happens with a few X window managers.
.TP 8
.B -mono or -monoMode
Determines whether
.IR xboard
displays its pieces and squares with two colors (True) or four (False).
You shouldn't have to specify monoMode;
.IR xboard
will determine if it is necessary.
.TP 8
.B -borderXoffset
.PD 0
.TP 8
.B -borderYoffset
These options are part of a kludge 
that helps position the Comment and Edit Comment
windows in the same place on the screen when they are closed and reopened.
They should be set equal to the width and height of the borders that
your X window manager adds to windows when it displays them.  The
defaults are correct for 
.IR tvtwm (1).
.PD
.TP 8
.B -clockFont
The font used for the clocks.
If the option
value is a pattern that does not specify the font size, 
.IR xboard
tries to choose an appropriate font for the board size being used.
Default: -*-helvetica-bold-r-normal--*-*-*-*-*-*-*-*.
.TP 8
.B -coordFont
The font used for rank and file coordinate labels if 
.IR showCoords
is True.
If the option
value is a pattern that does not specify the font size, 
.IR xboard
tries to choose an appropriate font for the board size being used.
Default: -*-helvetica-bold-r-normal--*-*-*-*-*-*-*-*.
.TP 8
.B -font
The font used for popup dialogs, menus, comments, etc.
Default: -*-helvetica-medium-r-normal--*-100-*-*-*-*-*-*.
.PP
Alternate bitmaps for piece icons can be specified
either by choosing one of the built-in sets or with
the file name options described below.
There are three built-in sets of piece bitmaps available,
large (the default), medium, or small.
.PP
.TP 8
.B -solidPawnBitmap
.PD 0
.TP 8
.B -solidKnightBitmap
.TP 8
.B -solidBishopBitmap
.TP 8
.B -solidRookBitmap 
.TP 8
.B -solidQueenBitmap
.TP 8
.B -solidKingBitmap
Names of the bitmap files for the solid piece icons.
.PD

.PD 0
.TP 8
.B -outlinePawnBitmap 
.TP 8
.B -outlineKnightBitmap 
.TP 8
.B -outlineBishopBitmap 
.TP 8
.B -outlineRookBitmap 
.TP 8
.B -outlineQueenBitmap 
.TP 8
.B -outlineKingBitmap 
Names of the bitmap files for the outline piece icons.  These
are used only in monochrome mode.
.PD
.TP 8
.B -whitePieceColor
Color specification for white pieces,
suitable for
.IR XParseColor (3X11).
Default: #FFFFCC.
These colors look good on a DEC workstation.
If you need different colors, try using the
.IR xcolors
application.  Source for
.IR xcolors
can be found in the X11 contrib directory.
.TP 8
.B -blackPieceColor
Same for black pieces.
Default: #202020.
.TP 8
.B -lightSquareColor
Same for light squares.
Default: #C8C365.
.TP 8
.B -darkSquareColor
Same for dark squares.
Default: #77A26D.
.PP
If you are using a grayscale monitor, try setting the colors to:
.EX 4
-whitePieceColor     gray100
-blackPieceColor     gray0
-lightSquareColor    gray80
-darkSquareColor     gray60
.EE
.SH Other Options
.TP 8
.B -ncp or -noChessProgram
If this option is True,
.IR xboard
acts as a passive chessboard; it does not
start a chess program at all.
Turning on this option also turns off clockMode.
Default: False.
.TP 8
.B -debug or -debugMode
Turns on debugging printout.
.SH MENU COMMANDS, BUTTONS, AND KEYS
All 
.IR xboard
commands are available on menus.  The most frequently used
commands also have shortcut keys or on-screen buttons.
.SH File Menu
.TP 8
.B Reset
Resets
.IR xboard
and GNU Chess to the beginning of a new chess game.
The "r" key is a keyboard equivalent.
In Internet Chess Server mode, clears the current state of 
.IR xboard ,
then resynchronizes with ICS by sending a 
.IR refresh
command.
If you want to stop playing, observing, or examining a game 
on ICS, use an appropriate command from the 
Action menu, not Reset.
.TP 8
.B Load Game
Plays a game from a record file.
A popup dialog prompts you for the file name.
If the file contains more than one game, and you want
to load the 
.IR N th
one, type the number 
.IR N 
after the file name, separated by a space.
The "g" key is a keyboard equivalent.

The game file parser will accept PGN (portable game notation), or
in fact almost any file that contains moves in algebraic notation.
If the file includes a PGN position (FEN tag), or an 
.IR xboard
position diagram
bracketed by "[--" and "--]" before the
first move, the game starts from that position.
Text enclosed in parentheses, square brackets, or curly braces 
is assumed to be commentary and is displayed in a pop-up window.
Any other text in the file is ignored.  PGN variations (enclosed in 
parentheses) are treated as comments; 
.IR xboard
is not able to walk variation trees.
.TP 8
.B Load Next Game
Loads the next game from the last game record file you loaded.
.TP 8
.B Load Previous Game
Loads the previous game from the last game record file you loaded.
.TP 8
.B Reload Same Game
Reloads the last game you loaded.
.TP 8
.B Load Position
Sets up a position from a position file.
A popup dialog prompts you for the file name.
If the file contains more than one saved position, and you want
to load the 
.IR N th
one, type the number 
.IR N 
after the file name, separated by a space.
Position files must be in the format that the Save Position command
writes.
.TP 8
.B Save Game
Appends a record of the current game to a file.
A popup dialog prompts you for the file name.
If the game did not begin with the standard starting position,
the game file includes the starting position used.
Games are saved in the PGN (portable game notation) format,
unless the oldSaveStyle option is
True, in which case they are saved in an older format that is specific to 
.IR xboard .
Both formats are human-readable, and both can be read back by the Load Game 
command. 
.TP 8
.B Save Position
Appends a diagram of the current position to a file.
A popup dialog prompts you for the file name.
Positions are saved in FEN (Forsythe-Edwards notation) format unless
the oldSaveStyle option is True, in which case they are saved in an older,
human-readable format that is specific to 
.IR xboard .
Both formats can be read back by the Load Position command.
.TP 8
.B Mail Move
.PD 0
.TP 8
.B Reload CMail Game
See the manual page for
.IR cmail (6).
.PD
.TP 8
.B Exit
Exits from
.IR xboard .
The "q" key is a keyboard equivalent.
.SH Mode Menu
.TP 8
.B Pause
Pauses updates to the board, and if you are playing
against GNU Chess, also pauses your clock.
To continue, select Pause again, and the display will automatically
update to the latest position.
The [P] button and keyboard "p" key are equivalents.

If you select Pause when you are playing against GNU Chess and
it is not your move, GNU Chess's clock
will continue to run and it will eventually make a move, at which point
both clocks will stop.  Since board updates are paused, however,
you will not see the move until you exit from Pause mode (or select Forward).
This behavior is meant to simulate adjournment with a sealed move.

If you select Pause while you are in 
.IR examine
mode on ICS, you can step
backward and forward in the current history of the examined game without
affecting the other observers and examiners.  Select Pause again to reconnect
yourself to the current state of the game on ICS.

If you select Pause while you are loading a game, the 
game stops loading.
You can load more moves manually by selecting Forward, or resume automatic
loading by selecting Pause again.
.TP 8
.B Edit Comment
Adds or modifies a comment on the current position.  Comments are
saved by Save Game and are displayed by Load Game, Forward, and Backward.
.TP 8
.B Machine White
Forces GNU Chess to play white.  GNU Chess mode only.
.TP 8
.B Machine Black
Forces GNU Chess to play black.  GNU Chess mode only.
.TP 8
.B Two Machines
Plays a game between two computer programs.  GNU Chess mode only.
.TP 8
.B ICS Client
ICS mode only.  Takes 
.IR xboard
out of the Edit Game or Edit Position state.
.TP 8
.B Edit Game
Allows you to make moves for both black and white, and
to change moves after backing up with the Backward command.
In GNU Chess mode, GNU chess continues to check moves for
legality but does not participate in the game.  You can bring GNU
Chess back into the game by selecting Machine White, Machine Black, 
or Two Machines.  In ICS mode, the moves are not sent to the ICS.
The clocks do not run.
.TP 8
.B Edit Position
Lets you set up an arbitrary board position.
Use mouse button 1 to drag pieces to new squares, or to
delete a piece by dragging it off the board or dragging an empty square
on top of it.  To drop a new piece on a square, press mouse button 2 or 3
over the square.  This brings up a menu of white pieces (button 2) or black
pieces (button 3).  Additional menu choices let you empty the square or
clear the board.  You can set the side to play next
by clicking on the White or Black indicator at the top of the screen.
.SH Action Menu
.TP 8
.B Accept
Accepts a pending match offer from your opponent.
If there is more than one offer pending, you will have to type in a more
specific command instead of using this menu choice.  (ICS mode only)
.TP 8
.B Decline
Declines a pending offer (match, draw, adjourn, etc.) from your opponent.
If there is more than one offer pending, you will have to type in a more
specific command instead of using this menu choice.  (ICS mode only)
.TP 8
.B Call Flag
Calls your opponent's flag, claiming a win on time, or claiming a draw
if you are both out of time.  You can also call your opponent's flag
by clicking on his clock or by pressing the keyboard "t" key.
.TP 8
.B Draw
Offers a draw to your opponent, accepts a pending draw offer
from your opponent, or claims a draw by repetition or the 50-move 
rule, as appropriate.  The "d" key is a keyboard equivalent.  (ICS mode only)
.TP 8
.B Adjourn
Asks your opponent to agree to adjourning the current game, or
agrees to a pending adjournment offer from your opponent.  (ICS mode only)
.TP 8
.B Abort
Asks your opponent to agree to aborting the current game, or
agrees to a pending abort offer from your opponent.
An aborted game ends immediately without affecting either player's rating.
.TP 8
.B Resign
Resigns the game to your opponent.  The shifted "R" key is a keyboard
equivalent. 
.TP 8
.B Stop Observing
Ends your participation in observing a game, by issuing the ICS
.IR observe
command with no arguments.  (ICS mode only)
.TP 8
.B Stop Examining
Ends your participation in examining a game, by issuing the ICS
.IR unexamine
command.  (ICS mode only)
.SH Step Menu
.TP 8
.B Backward
Steps backward through a series of remembered moves.
The [<] button and the "b" key are equivalents.

In most modes, Backward only lets you look back at 
old positions; it does not retract moves.
This is the case if you are playing against GNU Chess, playing or
observing a game on the ICS, or loading a game.  If you select Backward in any
of these situations, you will not be allowed to make a different move.
Use Retract Move or Edit Game if you want to change past moves.

If you are examining a game on ICS, the behavior of
Backward depends on whether 
.IR xboard
is in Pause mode.
If Pause mode is off, Backward issues the ICS 
.IR backward
command, which
backs up everyone's view of the game and allows you to make a different move.
If Pause mode is on, Backward only backs up your local view.
.TP 8
.B Forward
Steps forward through a series of remembered moves (undoing the effect of
Backward) or forward through a game file.
The [>] button and the f key are equivalents.

If you are examining a game on ICS, the behavior of
Forward depends on whether 
.IR xboard
is in Pause mode.
If Pause mode is off, Forward issues the ICS 
.IR forward
command, which
moves everyone's view of the game forward along the current line.
If Pause mode is on, Forward only moves your local view forward, and it
will not go past the position that the game was in when you paused.
.TP 8
.B Back to Start
Jumps backward to the first remembered position in the game.
The [<<] button and the shifted "B" key are equivalents.

In most modes, Back to Start only lets you look back at 
old positions; it does not retract moves.
This is the case if you are playing against GNU chess, playing or
observing a game on the ICS, or loading a game.  If you select Back to
Start in any
of these situations, you will not be allowed to make different moves.
Use Retract Move or Edit Game if you want to change past moves; or
start a new game.

If you are examining a game on ICS, the behavior of
Back to Start depends on whether 
.IR xboard
is in Pause mode.
If Pause mode is off, Back to Start issues the ICS 
.I backward 999999
command, which
backs up everyone's view of the game to the start and allows you to make
different moves.
If Pause mode is on, Back to Start only backs up your local view.
.TP 8
.B Forward to End
Jumps forward to the last remembered position in the game.
The [>>] button and the shifted "F" key are equivalents.

If you are examining a game on ICS, the behavior of
Forward to End depends on whether 
.IR xboard
is in Pause mode.
If Pause mode is off, Forward to End issues the ICS 
.I forward 999999
command, which moves everyone's view of the game forward to the end
of the current line.  
If Pause mode is on, Forward to End only moves your local view forward, and it
will not go past the position that the game was in when you paused.
.TP 8
.B Revert
If you are examining a game on ICS and Pause mode is off, 
issues the ICS command
.IR revert .
.TP 8
.B Truncate Game
Discards all remembered moves of the game beyond the current position.
Puts 
.IR xboard
into Edit Game mode if it was not there already.
.TP 8
.B Move Now
Forces GNU Chess to move immediately.  (GNU Chess mode only)
.TP 8
.B Retract Move
Retracts your last move.  
In GNU Chess mode, you can do this only after GNU Chess has replied to
your move; if GNU Chess is still thinking, use Move Now first.
In ICS mode, Retract Move issues the command 
.I takeback 1
or
.I takeback 2
depending on whether it is your opponent's move or yours; however,
this command currently works only on FICS.
.SH Options Menu
.TP 8
.B Always Queen
Toggles the alwaysPromoteToQueen option.
.TP 8
.B Autoflag
Toggles the autoCallFlag option.
.TP 8
.B Autosave
Toggles the autoSaveGames option.  Disabled if the saveGameFile
option is set, as in that case all games are saved to the specified file.
.TP 8
.B Bell
Toggles the ringBellAfterMoves option.
.TP 8
.B Flip View
Inverts your view of the chess board for the duration of the current
game.  Starting a new game returns the board to normal.  

If you are
playing a game on the ICS, the board is always
oriented at the start of the game so that your 
pawns move from the bottom of the window towards the top.
Otherwise, the starting orientation is determined by the flipView command line
option; if it is False (the default), White's pawns move from bottom
to top at the start of each game; if it is True, Black's pawns move
from bottom to top.
.TP 8
.B Old Save Style
Toggles the oldSaveStyle option.
.TP 8
.B Quiet Play
Toggles the quietPlay option.
.TP 8
.B Show Coords
Toggles the showCoords option.
.SH Help Menu
.TP 8
.B Hint
Displays a move hint from GNU Chess.  GNU Chess mode only.
.TP 8
.B About Game
Displays information about the current game, in the form of PGN 
(portable game notation) tags.
.TP 8
.B About XBoard
Shows the current 
.IR xboard
version number.
.SH Other shortcut keys
.TP 8
.B Iconify
Pressing the i or c key iconifies
.IR xboard .
.PP
You can add more shortcut keys to
.IR xboard
using the X resource 
.IR form.translations .
Here is an example of what would go in your .Xdefaults file:
.EX 4
XBoard*form.translations: Shift<Key>?: AboutGameProc() \\n \\
    <Key>y: AcceptProc() \\n \\
    <Key>n: DeclineProc()
.EE
The 
.IR xboard
functions that can be bound to keys in this way are: 
AbortProc,
AboutGameProc,
AboutProc,
AcceptProc,
AdjournProc,
AlwaysQueenProc,
AutoflagProc,
AutosaveProc,
BackwardProc,
BellProc,
CallFlagProc,
DeclineProc,
DrawProc,
EditGameProc,
EditPositionProc,
FlipViewProc,
ForwardProc,
HintProc,
IcsClientProc,
LoadGameProc,
LoadNextGameProc,
LoadPositionProc,
LoadPrevGameProc,
MachineBlackProc,
MachineWhiteProc,
MailMoveProc,
MoveNowProc,
OldSaveStyleProc,
PauseProc,
QuietPlayProc,
QuitProc,
ReloadGameProc,
ResetProc,
ResignProc,
RetractMoveProc,
RevertProc,
SaveGameProc,
SavePositionProc,
ShowCoordsProc,
StopExaminingProc,
StopObservingProc,
ToEndProc,
ToStartProc,
TruncateGameProc, and
TwoMachinesProc.
.SH ENVIRONMENT
Game and position files
are found in the directory named by the CHESSDIR environment
variable.  If this variable is not set, the current working
directory is used.
If CHESSDIR is set,
.IR xboard
actually changes its working directory to $CHESSDIR, so GNU Chess listing
files will be stored there as well.
.SH FILES
Whenever
.IR xboard
connects to the Internet Chess Server, if it finds a file called ".icsrc",
it feeds the file's contents to the ICS as commands.
Usually the first two lines of the file should be your ICS user name
and password.
The .icsrc file can be either in $CHESSDIR, in 
.IR xboard 's
working directory if CHESSDIR is not set, or in your home directory.
.SH SEE ALSO
.IR gnuchess (6)
.SH LIMITATIONS
There is no way for two people running copies of
.IR xboard
to play each other without going through the Internet Chess Server.  
.PP
The game parser recognizes only algebraic notation.
.PP
The internal move legality tester does not look at the game history,
so in some cases it misses illegal castling or en passant captures.
However, if you attempt such a move when using
GNU Chess (or the ICS), it will reject the move, and
.IR xboard
will undo it and let you try another.
Also, FEN positions saved by 
.IR xboard
do not include correct information about whether castling or en passant
are legal.
.PP
In ICS mode, 
.IR xboard
cannot handle observing (and/or playing) more than one game at
a time.  It may get confused if you try to do this, though it
tries to recover gracefully.  Select Reset from the File menu
if you have problems.
.PP
Your password gets echoed when you log on to the ICS.  This
happens because 
.IR xboard
does not implement the telnet protocol.  Also, if useTelnet mode
is set, every line you type to the ICS gets echoed an extra time.  
This happens because 
.IR xboard
does not put the keyboard into raw mode and let the
telnet program do all the echoing.  (The details of
how to do so vary on different versions of Unix.)
.PP
The .icsrc file does not work properly when you 
connect to ICS through a Unix gateway host with useTelnet mode.
The Unix login process apparently discards type-ahead.
.PP
Some
.IR xboard
functions may not work with versions of GNU Chess earlier 
than 4.0, patchlevel 52. 
In particular, with GNU Chess 3.1
the timeControl option can be given only to
the nearest minute, restoring a saved position with 
black to play may not work, and if you use
the Backward button after a mate or draw, the clocks are reset (because 
GNU Chess has exited and must
be restarted).
.SH AUTHORS
Original authors:  Chris Sears and Dan Sears.
Enhancements, current maintainer:  Tim Mann.
Thanks to John Chanak for the initial implementation of ICS mode.
Thanks to Evan Welsh for implementing 
.IR cmail (6).
.PP
Send bug reports to <bug-gnu-chess@prep.ai.mit.edu>.
.SH COPYRIGHT
Copyright 1991 by Digital Equipment Corporation, Maynard, Massachusetts.
Enhancements Copyright 1992-94 Free Software Foundation, Inc.
.PP
XBoard borrows its colors, icon and piece bitmaps from XChess,
which was written and is copyrighted by Wayne Christopher.
.PP
The following terms apply to Digital Equipment Corporation's copyright
interest in XBoard:
.PP
.RS
All Rights Reserved
.PP
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.
.PP
DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
.RE
.PP
The following terms apply to the enhanced version of XBoard distributed
by the Free Software Foundation:
.PP
.RS
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.PP
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.RE
