/*
 *      ibmterm.h          IBM-specific graphics macros         mak
 *
 *	Copyright (C) 1989 The Regents of the University of California
 *	This Software may be copied and distributed for educational,
 *	research, and not for profit purposes provided that this
 *	copyright and statement are included in all such copies.
 *
 */

#define GR_SIZE 10000

#define prepare_to_draw gr_mode()
#define done_drawing nop()

#define prepare_to_draw_turtle ibm_prepare_to_draw_turtle()
#define done_drawing_turtle ibm_done_drawing_turtle()

#define screen_height (screen_bottom - screen_top)
#define screen_width (screen_right - screen_left)

#define screen_left 0
#define screen_right (MaxX - 1)
#define screen_top ibm_screen_top
#define screen_bottom (MaxY - 1)

#define turtle_left_max -(MaxX/2)
#define turtle_right_max MaxX/2
#define turtle_top_max ibm_turtle_top_max
#define turtle_bottom_max -(MaxY/2)

#define turtle_height t_height()
#define turtle_half_bottom t_half_bottom()
#define turtle_side t_side()

#define screen_x_coord screen_right/2 + turtle_x
#define screen_y_coord screen_bottom/2 - turtle_y

#define clear_screen erase_screen()

#define line_to(x,y) {if (current_vis==0) lineto((int)x,(int)y); else moveto((int)x,(int)y);}
#define move_to(x,y) moveto((int)x,(int)y)
#define draw_string(s) outtext((char far *)s)
#define set_pen_vis(v) current_vis = v
#define set_pen_mode(m) set_ibm_pen_mode(m)
#define set_pen_color(c) {if (!in_erase_mode) setcolor(c);}
#define set_pen_width(w) set_ibm_pen_width(w)
#define set_pen_height(h) set_ibm_pen_width(h)
#define set_pen_x(x) moveto((int)x, gety())
#define set_pen_y(y) moveto(getx(), (int)y)

/* pen_info is a stucture type with fields for the various
   pen characteristics including the location, size, color,
   mode (e.g. XOR or COPY), pattern, visibility (0 = visible) */

typedef struct { int      h;
				 int	  v;
				 int	  vis;
				 int	  width;
				 int      color, prev_color;
				 unsigned char pattern[8];
				 int	  mode; } pen_info;

#define p_info_x(p) p.h
#define p_info_y(p) p.v

#define pen_width get_ibm_pen_width()
#define pen_height get_ibm_pen_width()
#define pen_color getcolor()
#define pen_mode get_ibm_pen_mode()
#define pen_vis current_vis
#define pen_x getx()
#define pen_y gety()
#define get_node_pen_pattern Get_node_pen_pattern()
#define get_node_pen_mode Get_node_pen_mode()

#define pen_reverse ibm_pen_xor()
#define pen_erase ibm_pen_erase()
#define pen_down ibm_pen_down()

#define button Button()
#define mouse_x mickey_x()
#define mouse_y mickey_y()

#define full_screen f_screen()
#define split_screen s_screen()
#define text_screen t_screen()

/* definitions from term.c and math.c for ibmterm.c */
extern int x_coord, y_coord, x_max, y_max, tty_charmode;
extern char so_arr[], se_arr[];
extern FLONUM degrad;

/* definitions from ibmterm.c for graphics.c */
extern void gr_mode();
extern void ibm_prepare_to_draw_turtle(),
			ibm_done_drawing_turtle();
extern void set_ibm_pen_width();
extern int get_ibm_pen_width();
extern void ibm_pen_erase(), ibm_pen_down(), ibm_pen_xor();
extern void set_ibm_pen_mode();
extern int get_ibm_pen_mode();
extern void save_pen(), restore_pen(), set_pen_pattern();
extern void plain_xor_pen();
extern void set_list_pen_pattern(), get_pen_pattern(), erase_screen();
extern void label(), logofill();
extern void t_screen(), s_screen(), f_screen(), tone();
extern FIXNUM mickey_x(), mickey_y();
extern NODE *Get_node_pen_pattern(), *Get_node_pen_mode();
extern FIXNUM t_height();
extern FLONUM t_half_bottom(), t_side();
extern int current_vis, ibm_screen_top, ibm_turtle_top_max;
extern BOOLEAN in_erase_mode;
