;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: XGINSENG; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: toplevel.lisp,v 1.7 1993/07/20 06:25:50 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :xginseng)


;;;;    Contains definition of the top-level xginseng function


(defun xginseng-loaded-p ()
  (fboundp 'xginseng1))

(sneps:defsnepscom xginseng (())
  "Top-level function.  If XGinseng is already running, restarts it;
else, loads proper files and calls XGINSENG1."
  (unless (xginseng-loaded-p)
    ;; Try to load it, this will print an error message and
    ;; return if Xginseng can't be loaded because Garnet is not installed.
    (load "sneps:xginseng;load-xginseng.LISP"))
  (when (xginseng-loaded-p)
    ;; If we successfully loaded Xginseng, run it:
    (if (boundp 'display-window)
	(restart)
      (xginseng1))))
