;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: new-thresh.lisp,v 1.1 1993/07/17 02:16:36 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;-----------------------
;  Thresh handler
;-----------------------

(defun rule-handler.thresh (ant-report cqch)
  (let* ((i (node-to-number.n (choose.ns (nodeset.n *NODE* 'sneps::thresh))))
	 (n (cardinality.ns (nodeset.n *NODE* 'sneps::arg)))
	 (j (if (nodeset.n *NODE* 'sneps::threshmax)
		(node-to-number.n (choose.ns (nodeset.n *NODE* 'sneps::threshmax)))
		(1- n)))
	 (ants (ants.cqch cqch)))

    ; if the antecedents have the same set of variables,
    ; use S-indexing, otherwise use linear ruiset handling    
    (do.set (rui (if (is-all-pat-same-vars ants)
		     (get-rule-use-info-sindexing ant-report cqch)
		     (get-rule-use-info ant-report cqch)))
      (cond ((and (>= (poscount.rui rui) i) (> (negcount.rui rui) (- n j 1)))
	     (report-contradiction.thresh (context.ch (channel.cqch cqch)) i j ants
					  *NODE* rui))
	    ((and (>= (poscount.rui rui) i) (= (negcount.rui rui) (- n j 1)))
	     (let ((restr (make.restr (subst.rui rui)))
		   (ch (channel.cqch cqch)))
	       (unless-remarkedp.rui rui (inform-pos.thresh restr ch ants rui))
	       (send-reports
		 (makeone.repset
		   (make.rep (restrict-binding-to-pat (subst.rui rui)
						      (destination.ch ch))
			     (compute-new-support.thresh
				   ch
				   (combinations.fns i  (select-pos.rui rui)
						        (select-neg.rui rui))
				   (subst.rui rui))
			     'POS  *NODE*   nil  (context.ch ch)))
		 ch)))
	    ((and (= (poscount.rui rui) (1- i)) (>= (negcount.rui rui) (- n j)))
	     (let ((restr (make.restr (subst.rui rui)))
		   (ch (channel.cqch cqch)))
	       (unless-remarkedp.rui rui (inform-neg.thresh restr ch ants rui))
	       (send-reports
		 (makeone.repset
		   (make.rep (restrict-binding-to-pat (subst.rui rui)
						      (destination.ch ch))
			     (compute-new-support.thresh 
				      ch
				      (combinations.fns (- n j)
							(select-neg.rui rui)
							(select-pos.rui rui))
				      (subst.rui rui))
			     'NEG  *NODE*  nil  (context.ch ch)))
		 ch)))))))
