;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: new-num-quant.lisp,v 1.1 1993/07/17 02:16:33 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;----------------------------------------
;    Numerical quantifier handler
;----------------------------------------

(defun rule-handler.num-quant (ant-report cqch)
  (declare (special *NODE*
		    *NUM-QUANT-POS-INSTANCES*
		    *NUM-QUANT-NEG-INSTANCES*))
  (let* ((i (if (nodeset.n *NODE* 'sneps::emin)
		(node-to-number.n (choose.ns (nodeset.n *NODE* 'sneps::emin)))
	      nil))
         (j (if (nodeset.n *NODE* 'sneps::emax)
		(node-to-number.n (choose.ns (nodeset.n *NODE* 'sneps::emax)))
	      nil))
	 (k (if (nodeset.n *NODE* 'sneps::etot)
		(node-to-number.n (choose.ns (nodeset.n *NODE* 'sneps::etot)))
	      nil))
	 (n (cardinality.ns (nodeset.n *NODE* 'sneps::&ant)))
	 (type1 (and i j k))
	 (type2 (and i (not j) k))
	 (type3 (and (not i) j (not k)))
	 (type4 (and i j (not k)))
;	 (ants (ants.cqch cqch))
	 (ch (channel.cqch cqch))
	 (destn (destination.ch ch)))
    
     ; use the P-tree method for the numerical quantifiers
    
    (do.set (rui (get-rule-use-info-ptree ant-report cqch))
       (let ((f-sbst (restrict.sbst (subst.rui rui)
				    (freevars.n *NODE*)))
	     (q-sbst (restrict.sbst (subst.rui rui)
				    (quantified-vars.n *NODE*))))
	 (cond ((and (= (poscount.rui rui) (+ n 1))
		     (= (negcount.rui rui) 0))
		(setq *NUM-QUANT-POS-INSTANCES* 
		      (update-instances.num-quant f-sbst
						  q-sbst
						  *NUM-QUANT-POS-INSTANCES*))

		(if (and (or type1 type3 type4) 
			 (= (length
			     (select-instances.num-quant
			      f-sbst *NUM-QUANT-POS-INSTANCES*)) j))
		    (send-reports.num-quant 'NEG n f-sbst rui cqch)))
	 
	       
	       ((and (= (poscount.rui rui) n) (= (negcount.rui rui) 1))
		(when (or (and (eq (signature.rep ant-report) destn)
			       (eq (sign.rep ant-report) 'NEG))
			  (and (not (eq (signature.rep ant-report) destn))
			       (eq (sign.rep ant-report) 'POS)))
		  (setq *NUM-QUANT-NEG-INSTANCES* 
		     (update-instances.num-quant f-sbst
						 q-sbst
						 *NUM-QUANT-NEG-INSTANCES*))

		  (if (and (or type1 type2) 
			   (= (length
			       (select-instances.num-quant
				f-sbst *NUM-QUANT-NEG-INSTANCES*)) 
			      (- k i)))
		      (send-reports.num-quant 'POS n f-sbst rui cqch)))))))))



(defun send-reports.num-quant (sign n f-sbst old-rui cqch)
  (let* ((ch (channel.cqch cqch))
	 (ptree-ruiset (ruiset.cqch cqch))
	 (destn (destination.ch ch))
	 (ptree (first ptree-ruiset))
	 (node-ruiset (third ptree-ruiset))
	 (ant-ptree (first ptree))
	 (ruiset (rest (assoc ptree node-ruiset :test 'equal)))
	 (ants-ruiset (rest (assoc ant-ptree node-ruiset :test 'equal))))

   (do* ((ruis ants-ruiset (others.ruis ruis))
	 (rui (choose.ruis ruis) (choose.ruis ruis)))
	((isnew.ruis ruis))
     (let ((restr (make.restr (subst.rui rui)))
	   (q-sbst (restrict.sbst (subst.rui rui)
				  (quantified-vars.n *NODE*)))
	   (pos-instances (select-instances.num-quant
			     f-sbst
			     *NUM-QUANT-POS-INSTANCES*))
	   (neg-instances (select-instances.num-quant
			     f-sbst
			     *NUM-QUANT-NEG-INSTANCES*)))
       (when (and (match::is-compatible.sbst f-sbst (subst.rui rui))
		  (not (match::ismemb.sbst
			  q-sbst
			  (union.Set pos-instances neg-instances))))
	 (cond ((eq sign 'POS)
		(setq *NUM-QUANT-POS-INSTANCES*
		      (update-instances.num-quant f-sbst
						 q-sbst
						 *NUM-QUANT-POS-INSTANCES*))
		(inform.num-quant 'POS f-sbst restr neg-instances destn))
	       (t
		(setq *NUM-QUANT-NEG-INSTANCES*
		      (update-instances.num-quant f-sbst
						 q-sbst
						 *NUM-QUANT-NEG-INSTANCES*))
		(inform.num-quant 'NEG f-sbst restr pos-instances destn)))

	 (send-reports
	   (makeone.repset
	     (make.rep
	       (restrict.sbst (subst.rui rui) (freevars.n destn))
	       (compute-new-support.num-quant ch old-rui rui ruiset n sign)
	       sign *NODE* nil (context.ch ch)))
	   ch))))))


