;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: new-and-or.lisp,v 1.1 1993/07/17 02:16:28 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


;------------------------
;  And-or handler
;------------------------

(defun rule-handler.and-or (ant-report cqch)
  (let* ((min (node-to-number.n (choose.ns (nodeset.n *NODE* 'sneps::min))))
	 (max (node-to-number.n (choose.ns (nodeset.n *NODE* 'sneps::max))))
	 (tot (cardinality.ns (nodeset.n *NODE* 'sneps::arg)))
	 (ch (channel.cqch cqch))
	 (ants (ants.cqch cqch)))
    
    ; if the antecedents have the same set of variables,
    ; use S-indexing, otherwise use linear ruiset handling    
    (do.set (rui (if (is-all-pat-same-vars ants)
		     (get-rule-use-info-sindexing ant-report cqch)
		     (get-rule-use-info ant-report cqch)))
      (cond ((> (poscount.rui rui) max)
	     (report-contradiction.and-or
	      "More true arguments than max"
	      (context.ch ch)  min  max  ants  *node* (select-pos.rui rui)))
	    ((> (negcount.rui rui) (- tot min))
	     (report-contradiction.and-or
	      "More false arguments than tot-min"
	      (context.ch ch)  min  max  ants  *node* (select-neg.rui rui)))
	    ((= (poscount.rui rui) max)  
	     (let ((restr (make.restr (subst.rui rui))))
	       (unless-remarkedp.rui rui
				     (inform-neg.and-or restr ch ants rui))
	       (send-reports
		 (makeone.repset
		   (make.rep (restrict-binding-to-pat (subst.rui rui)
						      (destination.ch ch))
			     (compute-new-support.and-or ch
							 (select-pos.rui rui)
							 (subst.rui rui))
			     'NEG
			     *NODE*
			     nil
			     (context.ch ch)))
		 ch)))
	    ((= (negcount.rui rui) (- tot min)) 
	     (let ((restr (make.restr (subst.rui rui))))
	       (unless-remarkedp.rui rui
				     (inform-pos.and-or restr ch ants rui))
	       (send-reports
		 (makeone.repset
		   (make.rep (restrict-binding-to-pat (subst.rui rui)
						      (destination.ch ch))
			     (compute-new-support.and-or ch
							 (select-neg.rui rui)
							 (subst.rui rui))
			     'POS
			     *NODE*
			     nil
			     (context.ch ch)))
		 ch)))))))

