;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: MULTI; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: sched.lisp,v 1.3 1993/06/04 06:27:40 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :multi)


; =============================================================================
;
; schedule
; --------
;
;       arguments     : event - <process>
;                       events - <process queue>
;
;       returns       : <process queue>
;
;       description   : the scheduling function required by Multi
;
;                                        written :  rgh 11/18/85
;                                        modified:  rgh 12/02/85
;                                                   rgh  4/13/86
;                                                   rgh  4/20/86
;                                                   njm  1/19/89
;                                                   njm  3/22/89
;                                                   njm/hc 4/26/89
;
; This is the new, streamlined version that doesn't have to
; deal with high-priority and low-priority processes on the
; same queue anymore.
;
(defun schedule (event queue)
  (cond ((dequeue:in-queue event queue) queue)
	((eq (regfetch event '*NAME*) 'snip:USER)
	 (dequeue:insert-front event queue))
	(t (dequeue:insert-rear event queue))))


