;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: resource-lim.lisp,v 1.3 1993/06/04 06:27:26 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; decrease-resources
; ------------------
;
;       returns       : <integer>
;
;       nonlocal-vars : REMAINING-RESOURCES
;
;       description   : reduces the available resources whenever match or
;                       forward-match is called
;
;       side-effects  : changes the value of REMAINING-RESOURCES
;
;       implementation: tempororily de-activated for initial tests
;
;                                        written :  rgh 10/05/85
;                                        modified:
;
;
(defmacro decrease-resources ()
  `t)
;
;
; =============================================================================
;
; enough-resources
; ----------------
;
;       returns       : <boolean>
;
;       nonlocal-vars : REMAINING-RESOURCES
;
;       description   : checks to see if there are enough resources available
;                       to perform a match
;
;       implementation: tempororily de-activated for initial tests
;
;                                        written :  rgh 10/05/85
;                                        modified:
;
;
(defmacro enough-resources ()
  `t)
;
;
; =============================================================================
