;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: make.lisp,v 1.3 1993/06/04 06:27:02 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


(defun make-v-ent (n)
   (multi:new 'rule              ; NAME:
        'or-entailment           ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:              
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.v-ent      ; RULE-HANDLER:
        'usability-test.v-ent))  ; USABILITY-TEST:

(defun make-&-ent (n)
   (multi:new 'rule              ; NAME:
        'and-entailment          ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.&-ent      ; RULE-HANDLER:
        'usability-test.&-ent))  ; USABILITY-TEST:

(defun make-thresh (n)
   (multi:new 'rule              ; NAME:
        'thresh                  ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.thresh     ; RULE-HANDLER:
        'usability-test.thresh)) ; USABILITY-TEST:

(defun make-nor (n)
   (multi:new 'rule              ; NAME:
	'nor                     ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.nor        ; RULE-HANDLER:
        'usability-test.nor))    ; USABILITY-TEST:

(defun make-and (n)
   (multi:new 'rule              ; NAME:
        'and                     ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.and        ; RULE-HANDLER:
        'usability-test.and))    ; USABILITY-TEST:

(defun make-and-or (n)
   (multi:new 'rule              ; NAME:
        'and-or                  ; TYPE:
        n                        ; NODE:
        (new.iset)               ; KNOWN-INSTANCES:
        (new.repset)             ; REPORTS:
        (new.chset)              ; REQUESTS:
        (new.feedset)            ; INCOMING-CHANNELS:
        (new.chset)              ; OUTGOING-CHANNELS:
        (new.cqchset)            ; RULE-USE-CHANNELS:
	(new.ichset)             ; INTRODUCTION-CHANNELS:
        (new.repset)             ; PENDING-FORWARD-INFERENCES:
        nil                      ; PRIORITY:
        'rule-handler.and-or     ; RULE-HANDLER:
        'usability-test.and-or)) ; USABILITY-TEST:

(defun make-num-ent (n)
   (multi:new 'rule                ; NAME:
        'num-entailment            ; TYPE:
        n                          ; NODE:
        (new.iset)                 ; KNOWN-INSTANCES:
        (new.repset)               ; REPORTS:
        (new.chset)                ; REQUESTS:
        (new.feedset)              ; INCOMING-CHANNELS:
        (new.chset)                ; OUTGOING-CHANNELS:
        (new.cqchset)              ; RULE-USE-CHANNELS:
	(new.ichset)               ; INTRODUCTION-CHANNELS:
        (new.repset)               ; PENDING-FORWARD-INFERENCES:
        nil                        ; PRIORITY:
        'rule-handler.num-ent      ; RULE-HANDLER:
        'usability-test.num-ent))  ; USABILITY-TEST:

(defun make-num-quant (n)
  (multi:new 'num-quant.rule
        'num-quantifier              ; TYPE:
        n                            ; NODE:
        (new.iset)                   ; KNOWN-INSTANCES:
	nil                          ; NUM-QUANT-POS-INSTANCES:
	nil                          ; NUM-QUANT-NEG-INSTANCES:
        (new.repset)                 ; REPORTS:
        (new.chset)                  ; REQUESTS:
        (new.feedset)                ; INCOMING-CHANNELS:
        (new.chset)                  ; OUTGOING-CHANNELS:
        (new.cqchset)                ; RULE-USE-CHANNELS:
	(new.ichset)                 ; INTRODUCTION-CHANNELS:
        (new.repset)                 ; PENDING-FORWARD-INFERENCES:
        nil                          ; PRIORITY:
        'rule-handler.num-quant      ; RULE-HANDLER:
        'usability-test.num-quant))  ; USABILITY-TEST:

(defun make-non-deriv (n)
   (multi:new 'rule                  ; NAME:
        'non-derivable               ; TYPE:
        n                            ; NODE:
        (new.iset)                   ; KNOWN-INSTANCES:
        (new.repset)                 ; REPORTS:
        (new.chset)                  ; REQUESTS:
        (new.feedset)                ; INCOMING-CHANNELS:
        (new.chset)                  ; OUTGOING-CHANNELS:
        (new.cqchset)                ; RULE-USE-CHANNELS:
	(new.ichset)                 ; INTRODUCTION-CHANNELS:
        (new.repset)                 ; PENDING-FORWARD-INFERENCES:
        nil                          ; PRIORITY:
        'rule-handler.non-deriv      ; RULE-HANDLER:
        'usability-test.non-deriv))  ; USABILITY-TEST:

(defun make-non-rule (n)
   (multi:new 'non-rule   ; NAME:
        n                 ; NODE:
        (new.iset)        ; KNOWN-INSTANCES:
        (new.repset)      ; REPORTS:
        (new.chset)       ; REQUESTS:
        (new.feedset)     ; INCOMING-CHANNELS:
        (new.chset)       ; OUTGOING-CHANNELS:
        (new.repset)      ; PENDING-FORWARD-INFERENCES:
        nil))             ; PRIORITY:


