;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNIP; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: freport.lisp,v 1.3 1993/06/04 06:26:18 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :snip)


; =============================================================================
;
; <freport>  ::=  ( <report> . <context> )
;
;
; -----------------------------------------------------------------------------
;
; RECOGNIZERS    is.frep      :  <universal> --> <boolean>
;
;
; CONSTRUCTORS   make.frep    :  <report> x <context> --> <freport>
;                                  
;
; SELECTORS      report.frep  :  <freport> --> <report>
;                context.frep   :  <freport> --> <context>
;      
;
; TESTS          iseq.frep  :  <freport> x <freport> --> <boolean>
;
;
; =============================================================================
;
; is.frep
; -------
;
;       arguments     : u - <universal>
;
;       returns       : <boolean>
;
;       description   : returns "true" is "u" is a <freport>,
;                               "false" otherwise
;
;                                        written :  cpf 10/25/88
;                                        modified:  
;                                        modified:  
;
(defmacro is.frep (u)
  `(and (consp ,u)
        (is.rep (car ,u))
	(is.ct (cdr ,u))))
;
; =============================================================================
;
; make.frep
; ---------
;
;       arguments     : rep - <report>
;                       ct  - <context>                                        
;
;       returns       : <freport>
;
;       description   : returns a <freport> consisting of the components
;                       passed as arguments
;
;                                        written :  cpf 10/25/88
;                                        modified:  
;                                        modified:  
;
(defmacro make.frep (rep ct)
  `(cons ,rep ,ct))
;
;
; =============================================================================
;
; report.frep
; -----------
;
;       arguments     : freport  -  <freport>
;
;       returns       : <report>
;
;       description   : selects the <report> of the freport
;
;                                        written :  cpf 10/25/88;                                   
;                                        modified: 
;
(defmacro report.frep (freport)
   `(car ,freport))
;
;
; =============================================================================
;
; context.frep
; ------------
;
;       arguments     : freport  -  <freport>
;
;       returns       : <context>
;
;       description   : selects the <context> of the freport
;
;                                        written :  cpf 10/25/88
;                                        modified:  
;
;
(defmacro context.frep (freport)
   `(cdr ,freport))
;
;
; =============================================================================
;
; iseq.frep
; ---------
;
;       arguments     : fr1 - <freport>
;                       fr2 - <freport>
;
;       returns       : <boolean>
;
;       description   : returns "true" if "fr1" and "fr2" are equal
;
;                                        written :  cpf 10/25/88
;                                        modified:  
;                                        modified:
;
(defmacro iseq.frep (fr1 fr2)
  `(and (iseq.ct (context.frep ,fr1) (context.frep ,fr2))
	(iseq.rep (report.frep ,fr1) (report.frep ,fr2))))
;
;
; =============================================================================
;
; addbinding.frep
; ---------------
;
;       arguments     : mb - <mbind>
;                       frep - <report>
;
;       returns       : <freport>
;
;       description   : adds the binding "mb" to the <substitution> of "frep"
;
;                                        written :  cpf 10/25/88
;                                        modified:  
;
;
(defmacro addbinding.frep (mb frep)
  `(addbinding.rep ,mb (report.frep ,frep)))
;
;
; =============================================================================
