;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: svfns.lisp,v 1.4 1993/07/20 06:25:12 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


; ==========================================================================
;
; * 
; -
;
;      arguments     : sv - <svar>
;
;      returns       : <snepsset>
;
;      description   : Gets the value of the sneps variable "sv".
;                      This value is a <snepsset>, and is one of the 
;                      following: <node set>, <relation set>, <svar set>, 
;                      or <command set>.
;
;                                         written:  CCC 08/02/83
;                                         modified: ejm 10/23/83
;                                                   njm 04/28/89
;                                                   hc  07/18/93
;
(defsnepscom * ((id) (top ns bns tbns fns rs) t)
  (values (value.sv id) (value.sv 'defaultct)))


; ==========================================================================
;
; $ 
; -
;
;      arguments     : sv - <svar>
;
;      returns       : <node set> 
;
;      description   : Creates a new <permanent variable node>, which 
;                      becomes the value of the <svar> "sv".
;
;      side-effects  : Adds the new variable node to the value of 
;                      "varnodes".
;
;                                         written : CCC 08/02/83
;                                         modified: ejm 10/11/83
;                                                   hc  07/18/93
;
(defsnepscom $ ((id) (bns) t)
  (let ((svar (genpvar.n)))
    (setf (node-snepslog svar) id)
    (set.sv id (makeone.ns svar))))

; ==========================================================================
;


(defsnepscom |#| ((id) $ t)
  (set.sv id (makeone.ns (genpbase.n))))
