;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: intext.lisp,v 1.5 1993/07/20 06:25:03 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


;; intext
;; ------
;;
;;       arguments     : file - <filename> 
;;
;;       returns       : <nothing>
;;
;;       description   : User function to be called from the Sneps 
;;                       environment. It opens FILE and uses it as the
;;                       source of the input stream for the read-eval-print
;;                       loop of Sneps until encountering eof on FILE.
;;                       FILE is then closed and the source of input 
;;                       used prior to opening FILE is reinstated as 
;;                       the source of input stream (just like demo
;;                       but no input echoing).
;;
;;       side-effects  : It changes the source of input and it prints
;;                       a message at the beginning and the end.
;;
;;                                          written : jgn 09/01/83
;;                                          modified: ejm 02/28/84, 06/01/84
;;                                                    hc  11/22/91
;;                                                    hc  07/18/93
;;
(defsnepscom intext ((file))
  (declare (special outunit))
  (demo-start (open file :direction :input))
  (format outunit "~&File ~A is now the source of input.~%" file)
  (demo-set exit-function
	    #'(lambda ()
		(declare (special demo-start-time))
		(format outunit "~&~%End of file ~A" file)
		(setq demo-start-time (demo-get start-time))))
  (values))
