;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: innet.lisp,v 1.6 1993/07/20 06:25:02 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


; ==========================================================================
;
; innet
; ------
;
;       arguments     : fl - <filename> 
;
;       returns       : <nothing>
;
;       description   : "User function" to be called from SNePS environment.   
;                        It opens file fl and, if the content of file fl
;                        is a SNePS network, it inputs the network, 
;                        otherwise simply returns appropriate message.
;
;       side-effects  : It changes the entire <network> and prints a
;                       message. All previous existing contexts, nodes
;                       are erased before loadind the stored net.
;        
;
;        
;
;                                        written:  jgn 08/27/83
;                                        modified: ejm 06/01/84
;                                                  ssc 02/13/87
;                                                  njm 09/26/88
;                                                   hc 06/30/93
;                                                   hc 07/18/93
(defsnepscom innet ((file) (top) t)
  (with-open-file (inunit file :direction :input)
    (let* ((*package* (find-package 'snepsul))
	   (netid (read inunit)))
      (cond ((and (symbolp netid)
		  (string= (symbol-name netid) "SNePS network 2.0"))
	     ;; we've got the right one baby:
	     (resetnet t)
	     (inindices inunit)
	     (inrelations inunit)
	     (inpaths inunit)
	     (incontexts inunit)
	     (innodes inunit)
	     (insysvars inunit)
	     (format t "~%~%Network loaded from file: ~A~%" file)
	     (values))
	    ((eq netid '|SNePS network|)
	     (sneps-error
	      (format nil "~A~
                         ~%     is an old-style SNePS network file,~
                         ~%     do `(load \"sneps:sneps;fns;oinnet\")' ~
                                and use `oinnet'~
                         ~%     instead of `innet' if you want to convert it."
		      file)
	      'innet
	      'innet))
	    (t (sneps-error
		(format nil "~A is not~
                           ~%     a SNePS network file" file)
		'innet
		'innet))))))

(defun inindices (inunit)
  ;; Restores node-ID and context-ID indices:
  (dolist (p '(b m v p tm tv tp))
    (setf (get 'gennewnode p) (read inunit)))
  (setf (get 'gennewcontext 'c) (read inunit)))

(defun inrelations (inunit)
  (dotimes (i (read inunit))
    (read.r inunit)))

(defun inpaths (inunit)
  (dotimes (i (read inunit))
    (read-path.r inunit)))

(defun incontexts (inunit)
  (dotimes (i (read inunit))
    (read.ct inunit)))

(defun innodes (inunit)
  (dotimes (i (read inunit))
    (read.n inunit)))

;
;
;
; ==========================================================================
;
; insysvars
; ---------
;
;       arguments     : inunit - <input port> 
;
;       returns       : ignored
;
;       nonlocal-vars : The system variables (side-effected by read.sv)
;
;       description   : Calls read.sv to read S-expressions from INUNIT
;                       and sets the values of the system variables to
;                       these S-expressions.
;
;       side-effects  : read.sv sets the values of the system variables 
;
;                                          written : jgn 10/10/83
;                                          modified: ssc 02/25/87
;                                          modified: ssc 05/03/88
;                                                    hc  06/29/93
;
(defun insysvars (inunit)
  (dotimes (i (read inunit))
    (read.sv inunit)))
