;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: findhelp.lisp,v 1.4 1993/06/04 06:24:47 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


(defconstant *path-specifiers*
	     '(converse compose kstar kplus or and not relative-complement
			irreflexive-restrict exception domain-restrict
			range-restrict )
  "  A list of all of the available path constructors.")

(defun is.qv (qv)
    (and (consp qv) (eq (car qv) '?)))
 
(defmacro svar.qv (qv)
    `(second ,qv))
 
(defmacro is.p (p)
  `(and (consp ,p)
    (or (is.r (car ,p))
     (member (car ,p) ',*path-specifiers*))))
 
(defmacro rel-to-path (r)
    `(or (get ,r :pathdef) (list ,r)))
 
(defun is.nsf (nsf)
    (or (consp nsf) (atom nsf)))
 

