;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: demo.lisp,v 1.7 1993/07/20 06:24:51 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


;;  demo
;;  ----
;; 
;;         arguments     : &optional file  <filename>
;;                         &optional pause
;;                             one of: (T b before pause bv before-verbose
;;				        a after av after-verbose n NIL)
;; 
;;         returns       : <nothing>
;; 
;;         description   : User function to be called from SNePS.
;;                         It opens FILE  and changes the source
;;                         of the input stream to FILE. All the input
;;                         will be echoed to the terminal. Reading is
;;                         done similar to lisp reading, i.e., comments
;;                         can be put at all places. Depending on PAUSE
;;                         it pauses before reading a SNePSUL form,
;;                         after it has read it but not executed it, or
;;                         does not pause at all (NIL). The verbose forms
;;                         additionally print a pausing message.
;;
;;                         If FILE is a non-existent single character
;;                         filename a menu with available demonstrations
;;                         will be presented (the pity is we can't use
;;                         ? for this purpose because this is a read macro
;;                         that wants to consume the next argument, of course,
;;                         \? works)
;;
;;                         If demo is called without any arguments, a menu
;;                         with available demonstrations will be presented
;;                         and initial pausing will be av (which can be changed
;;                         later at the pause prompt).
;; 
;;         side-effects  : It changes the source of input and it prints
;;                         messages at the beginning and at the end.
;; 
;;                                         written:  jgn 08/07/83
;;                                         modified: ejm 06/01/84
;;                                         modified: scs 11/20/87
;;                                                    hc 11/20/91
;;                                                    hc 07/18/93
;;
(defsnepscom demo ((&optional (file 'x file-supplied-p)
			      (pause nil pause-supplied-p)
			      &rest ignore))
  (declare (ignore ignore))
  (cond (file-supplied-p
	 (if pause-supplied-p
	     (demo-internal file :pause pause)
	   (demo-internal file)))
	(t (demo-internal file :pause 'av)))
  (demo-set input-filter #'demo-input-filter)
  (values))


(defun demo-internal (file &key (pause nil pause-supplied-p)
		                (menu (when (initialized-p
					     *available-sneps-demos-menu*)
					*available-sneps-demos-menu*)))
  "Does the main work as described for DEMO. Putting this into a separate
function makes it easier available to other packages such as SNePSLOG (e.g.,
the menu handling couldn't have been easily supported by the DEMO
macro itself)."
  (declare (special outunit))
  (let ((pause (if pause-supplied-p
		   pause
		   ;; Copy pause from outer demo invocation
		   ;; if such a thing exists, i.e., in recursive demos
		   ;; use same pause control as in frame demo unless
		   ;; otherwise specified
		   (demo-get pause)))
	real-file)
    (when (demo-start file outunit pause menu)
      (setq real-file (truename (demo-get input-stream)))
      (format outunit "~&~%File ~A is now the source of input.~%" real-file)
      (when pause
	(format outunit
		"~%  The demo will pause between commands, at that time press~
               ~%  RETURN to continue, or ? to see a list ~
                   of available commands~%"))
      (demo-set exit-function
		#'(lambda ()
		    (declare (special demo-start-time))
		    (format outunit "~&~%End of ~A demonstration." real-file)
		    (setq demo-start-time (demo-get start-time)))))
    (values)))


(defun demo-input-filter (input)
  #+explorer
  ;; When we read from a demo file we have to account for the Explorer's
  ;; special way to read input. Because their read function does not
  ;; consume the #\newline at the end of an s-expression it does not get
  ;; echoed at the end of the read, but rather at the beginning of the
  ;; next read. This leads to the problem that we always get a newline
  ;; at the prompt. To avoid that we check for that case in the input
  ;; filter and read off the newline if necessary.
  (let ((input-stream (demo-get input-stream))
	(demo-stream (demo-get demo-stream)))
    ;; We only have to do this when we read a list
    (and (consp input)
	 ;; If the immediate character after a list is
	 ;; a newline lets read it off and echo it (of
	 ;; course, if there was some whitespace before
	 ;; the newline this will not work)
	 (eql (peek-char nil input-stream nil :eof)
	      #\newline)
	 (read-char demo-stream)))
  input)
