;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: node1.lisp,v 1.4 1993/07/02 00:30:33 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


; =============================================================================
;
; print.n
; -------
;
;       arguments     : n - <node>
;                       outunit - <unit>
;
;       returns       : nil
;
;       description   : It Prints a <node> to "outunit"
;                       so that it can later be reconstructed with read.n
;
;       side-effects  : It prints the <node>
;
;                                        written :  ejm 10/04/83
;                                        modified:  scs 02/16/87
;                                                   ssc 02/25/87
;                                                   njm 09/26/88
;                                                   hc  06/29/93
;
(defun print.n (node outunit)
  (with-readable-nodes-and-contexts
      (format outunit "~%~S~%~S ~S ~S~%~S~%~S~%~S~%~S"
	      (node-na node)
	      (node-type node)
	      (node-perm node)
	      (node-freevars node)
	      (node-fcableset node)
	      ;;(node-gi-node node)    ;; won't survive outnetting
	      ;;(node-activation node) ;; shouldn't survive outnetting
	      (node-asupport node)
	      (node-jsupport node)
	      (node-contexts node)
	      ;;(node-snepslog node)   ;; uses too much room
	      )))

;
;
; =============================================================================
;
; read.n
; ------
;
;       arguments     : inunit - <unit>
;
;       returns       : <node>
;
;       description   : It reads and reconstructs a <node> from "inunit"
;                       assuming that the information was printed by print.n.
;
;       side-effects  : It constructs, or possibly just fills the <node>.
;                       Right now it does NOT update any system variables
;                       (more efficient, it's only used in in/outnet).
;
;                                        written :  ejm 10/04/83
;                                        modified:  scs 02/20/87
;                                        modified:  njm 09/27/88
;                                                   njm 10/04/88
;                                                    hc 06/29/93
;
(defun read.n (inunit)
  (let* ((name (read inunit))
	 (type (read inunit))
	 (node (or (node name)
		   (newnode name type))))
    ;; Reconstruct node:
    (setf (node-na node) name)
    (setf (node-type node) type)
    (setf (node-perm node) (read inunit))
    (setf (node-freevars node) (read inunit))
    (setf (node-fcableset node) (read inunit))
    ;;(setf (node-gi-node node) (read inunit))
    ;;(setf (node-activation node) (read inunit))
    (setf (node-asupport node) (read inunit))
    (setf (node-jsupport node) (read inunit))
    (setf (node-contexts node) (read inunit))
    ;;(setf (node-snepslog node) (read inunit))
    ;; Assume that this is only used for in/outnet, hence,
    ;; we don't have to handle system variables such as
    ;; `varnodes' or `assertions'.
    ))
