;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: context1.lisp,v 1.4 1993/07/02 00:30:27 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


; =============================================================================
;
; print.ct
; --------
;
;       arguments     : context - <context>
;                       outunit - <unit>
;
;       returns       : nil
;
;       description   : It Prints <context> to <outunit> so that it can later
;                       be reconstructed with read.ct.
;
;       side-effects  : It prints the <context>
;
;                                        written :  njm  09/26/88  
;                                        modified:  hc   06/29/93
;
(defun print.ct (context outunit)
  (with-readable-nodes-and-contexts
      (format outunit "~%~S~%~S~%~S~%~S~%~S"
	      (context-ca context)
	      (context-names context)
	      (context-hyps context)
	      (context-restriction context)
	      (context-kinconsistent context))))

;
; =============================================================================
;
; read.ct
; -------
;
;       arguments     : inunit - <unit>
;
;       returns       : nil
;
;       description   : It reads and reconstructs a context from <inunit>,
;                       assuming that the information was printed by print.ct.
;                       Right now it does NOT update any system variables
;                       (more efficient, it's only used in in/outnet).
;
;       side-effects  : It constructs the <context>.
;
;                                        written :  njm  09/27/88  
;                                        modified:  njm  10/13/88
;                                                    hc  06/29/93
;
(defun read.ct (inunit)
  (let* ((name (read inunit))
	 (context (c^ name)))
    ;; Reconstruct context:
    (setf (context-ca context) name)
    (setf (context-names context) (read inunit))
    (setf (context-hyps context) (read inunit))
    (setf (context-restriction context) (read inunit))
    (setf (context-kinconsistent context) (read inunit))
    ;; Hash it:
    (setf (gethash (context-hyps context) (value.sv 'contexts)) context)
    ;; Assume that this is only used for in/outnet, hence,
    ;; we don't have to handle system variables such as context names.
    ))