;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: SNEPS; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: context0.lisp,v 1.6 1993/06/04 06:23:31 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :sneps)


;; Definition of the structure CONTEXT
;; ===================================
;;
;;                                        written :  njm  09/14/88 
;;                                        modified:  hc 7/13/92
;;
;; Use the %context-... access functions as the actual access functions for
;; the context structure, and define the standard context-... access functions
;; in a way such that they can take structures as well as SNePSUL context
;; variables as their arguments (needed for easier implementation of
;; intensional contexts).
;;
(defstruct (context
	     (:print-function context-printer)
	     (:conc-name %context-)
	     (:predicate %context-p)
	     )
  (ca nil)             ;; Context access.
  (names nil)	       ;; Sneps variables set. Names used by the user
		       ;; to access this context.
  (hyps nil)           ;; Node set. Hypotheses defining this context.
  (restriction nil)    ;; Context set. Set of contexts that are
                       ;;  inconsistent with this context.
  (kinconsistent nil)) ;; Flag. T if this context is contradictory.

(defun context-printer (obj stream depth)
  (declare (ignore depth))
  (write-string (symbol-name (%context-ca obj)) stream))


;; Now define "tolerant" versions of the standard access functions
;; (the only difference is that now the access functions are defined as
;; macros which makes them non-funcallable, however, this can be fixed
;; if need arises):
;;
(defmacro get-context (context-or-name)
  `(cond ((%context-p ,context-or-name) ,context-or-name)
         ((is.sv ,context-or-name)
	  (value.sv ,context-or-name))))

;; Leave this one untouched for now, so it will only
;; return T for actual context structures:
(defun context-p (thing)
  (%context-p thing))

(defmacro context-ca (context-or-name)
  `(%context-ca (get-context ,context-or-name)))

(defmacro context-names (context-or-name)
  `(%context-names (get-context ,context-or-name)))

(defmacro context-hyps (context-or-name)
  `(%context-hyps (get-context ,context-or-name)))

(defmacro context-restriction (context-or-name)
  `(%context-restriction (get-context ,context-or-name)))

(defmacro context-kinconsistent (context-or-name)
  `(%context-kinconsistent (get-context ,context-or-name)))
