;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: ENGLEX; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: wordize.lisp,v 1.3 1993/06/04 06:22:53 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :englex)


(defun wordize (numbr lexeme)
  "Returns the singular or plural form of the 2nd arg according to the
   feature given as the 1st arg."
  (let* ((lex (first-atom lexeme))
	 (lexeme (typecase lex
		   (string lex)
		   (symbol (symbol-name lex))
		   (sneps::node (symbol-name (sneps::node-na lex)))))) 
    (cond ((null numbr) (or (lookup-lexical-feature 'root lexeme) lexeme))
	  ((eq numbr 'sing) (or (lookup-lexical-feature 'root lexeme) lexeme))
	  ((lookup-lexical-feature 'plur lexeme))
	  (t (pluralize (or (lookup-lexical-feature 'root lexeme) lexeme))))))

(defun pluralize (wform)
  (let ((wlength (1- (length wform)))
	(vowls '(#\a #\e #\i #\o #\u)))
    (cond ((char= (schar wform wlength) #\f)
	   (concatenate 'string (subseq wform 0 wlength) "ves"))
	  ((char= (schar wform wlength) #\y)
	   (cond ((member (schar wform (1- wlength)) vowls :test #'char=)
		  (concatenate 'string wform "s"))
		 (t
		  (concatenate 'string (subseq wform 0 wlength) "ies"))))
	  ((string= (subseq wform (- wlength 2) (1+ wlength)) "sis")
	   (concatenate 'string (subseq wform 0 (1- wlength)) "es"))
	  ((or (char= (schar wform wlength) #\x)
	       (char= (schar wform wlength) #\s)
	       (char= (schar wform wlength) #\z)
	       (and (char= (schar wform wlength) #\o)
		    (not (member (schar wform (1- wlength)) vowls
				 :test #'char=)))
	       (and (char= (schar wform wlength) #\h)
		    (char= (schar wform (1- wlength)) #\c)))
	   (concatenate 'string wform "es"))
	  (t (concatenate 'string wform "s")))))