;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: ENGLEX; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: exports.lisp,v 1.6 1993/06/04 06:22:43 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :englex)


;;;  Export the following symbols in the ENGLEX package.

(export
 '(*lexicon* lexin lookup verbize verbize-y verbthread wordize getf
	flistify first-atom get-lexical-feature lookup-lexical-feature))

;; Ugly but necessary:
(import '(snepsul:n snepsul:q))


(export '(ctgy   adj n noun v verb multi-start
	  multi-rest
	  num    sing singular plur pl plural
	  ;; past
	  pastp
	  ;; plur
	  pprt
	  ;; pres
	  presp
	  presprt
	  tense  pres past p future futr ftr fut
	  root
	  stative
	  p1 person1 firstperson p2 person2 secondperson p3
	  decl
	  int interrogative interrog intrg ques question ynq q
	  imp imper imperative impr command request req
	  inf infinitive infin
	  gnd gerund ing grnd
	  non-prog
	  progr prgr prg progress progressive ;; prog (in LISP)
	  non-perf
	  perf pft prft prfct perfect perfective
	  active
	  pass passive
	  affirmative
	  neg nega negative negated ;; not (in LISP)
	  may must can shall will))

;;; Lusardi's new features and variables:
(export '(adv contr prep pron *Trace* *Count-New-Strings*))

;;;   Import these ENGLEX functions in the SNePSUL package.

(import '(lexin pres presf past pptf pastp
		wordize verbize verbize-y verbthread flistify )
	(find-package 'snepsul))


;;;   Import this feature-mania into the SNePSUL package

(import '(ctgy   adj ;; n (already in SNePSUL)
	             noun v verb multi-start
	  multi-rest
	  num    sing singular plur pl plural
	  ;; past
	  ;; pastp (also a function)
	  ;; plur
	  pprt
	  ;; pres 
	  presp
	  presprt
	  tense  ;; pres past (also functions)
	         p future futr ftr fut
	  root
	  stative
	  p1 person1 firstperson p2 person2 secondperson p3
	  decl
	  int interrogative interrog intrg ques question ynq ;; q (in SNePSUL)
	  imp imper imperative impr command request req
	  inf infinitive infin
	  gnd gerund ing grnd
	  non-prog
	  progr prgr prg progress progressive ;; prog (in LISP)
	  non-perf
	  perf pft prft prfct perfect perfective
	  active
	  pass passive
	  affirmative
	  neg nega negative negated ;; not (in LISP)
	  may must can shall will)
	(find-package 'snepsul))

;;; Lusardi's new features:
(import '(adv contr prep pron)
	(find-package 'snepsul))
