;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: util.lisp,v 1.2 1993/06/04 06:22:03 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


#+symbolics
(shadowing-import '(scl:defflavor scl:defmethod scl:send user::self scl:make-instance)
		  (find-package 'ginseng))

#+symbolics
(DEFMETHOD (:CLEAR-SCREEN tv:window :DEFAULT) (&OPTIONAL MARGINS-P)
  (SEND SELF :CLEAR-WINDOW))




;;; 
;;;  These variables all relate to the identification, size, or operation 
;;;     of the Ginseng window.
;;;
(defvar *window* nil       "The current Ginseng window.")
(defvar *window-width* 0   "The width of the current Ginseng window.")
(defvar *window-height* 0  "The height of the current Ginseng window.")
(defvar *window-centerx* 0 "The X coord. of the current Ginseng window as it
                                        overlays *world*.")
(defvar *window-centery* 0 "The Y coord. of the current Ginseng window as it 
                                        overlays *world*.")
(defvar *viewport-position* '(0 0 0 0) "Left, Top, Right, Bottom of window as it
                                        overlays *world*.")
(defvar *display-bounds* '(0 0 0 0) "Left, Top, Right, Bottom bounds of the area that
                                      contains displayed nodes.")
(defconstant *avail-font-sizes* '(:tiny :very-small :small :normal :large :very-large)
                               "Available sizes of fonts -- used for scaling.")
(defvar *font-size* ':small "The size of characters printed on the display, and hence
                               the scale of the drawing.")
;;;
;;;  These variables contain information about NODES.
;;;
(defvar *displayed-nodes* () "The nodes that currently have a ginseng node description.")
(defvar *default-x-space* 36 "The default horizontal node spacing value.")
(defvar *default-y-space* 100 "The default vertical node spacing value.")
(defvar *min-node-radius* 12 "The minimum radius of a node.")
(defvar *node-margin-size* 5 "The margin between a node's label and edge.")

;;;  
;;;  These variables are involved in operating the mouse.
;;;
(defvar *mouse-sensitive* nil "Boolean that shows whether the mouse is sensitive in
                                the Ginseng window.")
(defvar *alist-alpha* nil  "The alist that contains all of the information on how
                              to interpret mouse clicks on sensitive items.")
(defvar *move-flag* nil "Boolean that shows whether moving is activated.")
(defvar *bend-flag* nil "Boolean that shows whether bending an arc is activated.")
(defvar *pan-flag* nil  "Boolean that shows whether panning is activated.")
(defvar *default-x-pan* 40  "The default number of pixels to shift on the X axis.")
(defvar *default-y-pan* 30  "The default number of pixels to shift on the Y axis.")
(defvar *pan-menu* nil  "This is the pop-up menu for panning.")


;;;
;;;
;;;

(defmacro left (lst)
  `(first ,lst))

(defmacro top (lst)
  `(second ,lst))

(defmacro right (lst)
  `(third ,lst))

(defmacro bottom (lst)
  `(fourth ,lst))


(defun // (a b)
  (floor (/ a b)))


(defun sector-code (x1 y1 left top right bottom)
  "Returns a code for the quadrant of left, top, right, bottom of node2
      that is closest to the point (x1, y1).  ssc 4/25/89"
  (if (> 75 (abs (- x1 (// (+ right left) 2))))
      ;; Are the "X"s close or far apart?
      (if (< (abs (- y1 top)) (abs (- y1 bottom)))
	  ;; Centered!  So, Top or Bottom?
	  8					; Mark top center.
	  4)					; Mark bottom center.
      (if (< (abs (- x1 left)) (abs (- x1 right)))
	  ;; Not centered! So, left or right?
	  (if (> 60 (abs (- y1 (// (+ top bottom) 2))))
	      ;; Left! So, centered?
	      1					; Mark left center.
	      (if (< (abs (- y1 top)) (abs (- y1 bottom)))
		  ;; Left and not centered!  So, top or bottom?
		  9				; Mark left and top.
		  5))				; Mark left and bottom.
	  (if (> 60 (abs (- y1 (// (+ top bottom) 2))))
	      ;; Right!  So, centered?
	      2					; Mark right center.
	      (if (< (abs (- y1 top)) (abs (- y1 bottom)))
		  ;; Right and not centered!  So, top or bottom?
		  10				; Mark right and top.
		  6)))))			; Mark right and bottom.


(defun calculate-node-edges (r1 x1 y1 base-p1 r2 x2 y2 base-p2)
  "Calculates the points on the edges of node1 and node2 that are "closest".
    Nodes' edges are broken down into 8 sections: top, bottom, left, right,
    and the four corners."
  (let* ((
x (- x2 x1)) (
y (- y2 y1))
	 (length (round (sqrt (+ (* 
x 
x) (* 
y 
y)))))
	 (coor1
	   (cond (base-p1
		  (let* ((left (- x1 r1)) (right (+ x1 r1))
			 (top (- y1 10))	(bottom (+ y1 10))
			 (code (sector-code x2 y2 left top right bottom)))
		    (list (case code
			    ((9 5) (+ left 4))
			    ((10 6) (- right 2))
			    (1 left)
			    (2 right)
			    (otherwise x1))
			  (case code
			    ((9 10) (+ top 2))
			    ((5 6)  (- bottom 4))
			    (8 top)
			    (4 bottom)
			    (otherwise y1)))))
		 (t (list (+ x1 (// (* 
x r1) length)) (+ y1 (// (* 
y r1) length))))))
	 (coor2
	   (cond (base-p2
		  (let* ((left (- x2 r2)) (right (+ x2 r2))
			 (top (- y2 10))	(bottom (+ y2 10))
			 (code (sector-code x1 y1 left top right bottom)))
		    (list (case code
			    ((9 5) (+ left 4))
			    ((10 6) (- right 2))
			    (1 left)
			    (2 right)
			    (otherwise x2))
			  (case code
			    ((9 10) (+ top 2))
			    ((5 6)  (- bottom 4))
			    (8 top)
			    (4 bottom)
			    (otherwise y2)))))
		 (t (list (- x2 (// (* 
x r2) length)) (- y2 (// (* 
y r2) length)))))))
    (values (car coor1) (cadr coor1)		; Endpoint for Node1
	    (car coor2) (cadr coor2)		; Endpoint for Node2
	    (// (+ x1 x2) 2)			; X-coor of mid-point
	    (// (+ y1 y2) 2))))			; Y-coor of mid-point


(defun calculate-arc-label-position (x1 y1 x2 y2 label)
  (let* ((
x (if (= x1 x2) 1 (- x2 x1)))
	 (
y (- y2 y1))
	 (line-length (round (sqrt (+ (* 
x 
x) (* 
y 
y)))))
	 (tan-pt2 (/ 
y 
x))			; Tangent at (x2,y2)
	 (cos-pt2 (/ 
x line-length))			; Cosine at (x2,y2)
	 (label-pix-length (* (scl:string-length label) 10))
	 (hypot (// (+ line-length label-pix-length) 2))
	 (new-
x (round (* hypot cos-pt2)))
	 (new-
y (round (* new-
x tan-pt2))))
    (values (- x2 new-
x)(- y2 new-
y))))


(defun neq (x y)
  (not (eq x y)))


(defun draw-bent-arrow (from-x from-y mid-x mid-y to-x to-y
			&rest args
			&key stream
			(alu tv:alu-ior)
			(thickness 1)
			(arrow-head-length tv:*default-arrow-length*)
			(arrow-base-width  tv:*default-arrow-width*)
			&allow-other-keys)
  (setq arrow-head-length (* arrow-head-length thickness)
	arrow-base-width (* arrow-base-width thickness))
  (let* ((delta-x (- to-x mid-x))
	 (delta-y (- to-y mid-y))
	 (length-of-line (sqrt (+ (expt delta-x 2) (expt delta-y 2)))))
    (unless (zerop length-of-line)
      ;; If length-of-line = 0, we do nothing and return nil
      (let* (;; Angle of inclination of the line
	     (cos-theta (/ delta-x length-of-line))
	     (sin-theta (/ delta-y length-of-line))
	     ;; Coords of center of base of arrowhead, where the line enters
	     (x-base (- to-x (* arrow-head-length cos-theta)))
	     (y-base (- to-y (* arrow-head-length sin-theta)))
	     ;; Changes in x and y from arrow base to corners
	     (delta-x-corner (/ (* arrow-base-width sin-theta) 2.0))
	     (delta-y-corner (/ (* arrow-base-width cos-theta) -2.0)))
	(si:with-rem-keywords (some-args args '(:arrow-head-length :arrow-base-width))
	  ;; Draw the spline -- don't overlap with arrowhead in case 
	  ;; alu is :flip or something
	  (send stream :draw-cubic-spline
		(make-array 3 :initial-contents
			    (list (- from-x (left *viewport-position*))
				  (- mid-x (left *viewport-position*))
				  (- to-x (left *viewport-position*))))
		(make-array 3 :initial-contents
			    (list (- from-y (top *viewport-position*))
				  (- mid-y (top *viewport-position*))
				  (- to-y (top *viewport-position*))))
		20
		1
		alu)

	  ;; Draw the arrowhead
	  (apply #'graphics:draw-triangle
		 (- to-x (left *viewport-position*))
		 (- to-y (top *viewport-position*))
		 (- (+ x-base delta-x-corner) (left *viewport-position*))
		 (- (+ y-base delta-y-corner) (top *viewport-position*))
		 (- (+ x-base (- delta-x-corner)) (left *viewport-position*))
		 (- (+ y-base (- delta-y-corner)) (top *viewport-position*))
		 some-args)))
      ;; Return t if actually drew something
      t)))


