;;; -*- Mode: Lisp; Syntax: Common-Lisp; Package: GINSENG; Base: 10 -*-

;; Copyright (C) 1984, 1988, 1989, 1993 Research Foundation of 
;;                                      State University of New York

;; Version: $Id: move.lisp,v 1.2 1993/06/04 06:21:57 snwiz Exp $

;; This file is part of SNePS.

;; SNePS is free software; you may redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; SNePS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with SNePS; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA, or to
;; Dr. Stuart C. Shapiro, Department of Computer Science, State University of
;; New York at Buffalo, 226 Bell Hall, Buffalo, NY 14260, USA

(in-package :ginseng)


;;;
;;;  GI-MOVE
;;;


(defun gi-move (gi-node &optional (window *window*))
  (cond (*pan-flag*
	 (tv:with-notification-mode (:pop-up)
	   (tv:notify nil
		      "You must Disable Panning before you may move node: ~A. "
		      (send gi-node :the-node))))
	(t
	 (setq *move-flag* t)
	 ;; Erase current view of node so that it may be moved.
	 (erase-node gi-node)
	 ;; Perform the move operation.
	 (gi-move-driver gi-node)
	 (send window :refresh)
	 (send window :display)
	 (send window :deselect))))


(defun gi-move-driver (gi-node &optional (window *window*))
  (multiple-value-bind (window-left window-top) (send window :edges)
    (loop while *move-flag*  do
      ;; Look for activity of any button and report mouse position.
      (multiple-value-bind (dumb1 dumb2 button-push button-rel mouse-x mouse-y)
	  (tv:mouse-input)
	(when (< 0 button-push)			; When button activity
	  (setq *move-flag* nil)		; Stop moving.
	  (return t))
	;; Failed attempt at rubber-banding the move operation.
	(send gi-node :set-xpos (+ (left *viewport-position*)
				   (- mouse-x window-left)))
	(send gi-node :set-ypos (+ (top *viewport-position*)
				   (- mouse-y window-top)))
	(send gi-node :draw-moving-node window)
	(dolist (arc (send gi-node :arcs) t)
	  (send arc :draw-moving-arc window))))))



;;; 
;;;  GI-ARC-BEND
;;;

(defun gi-arc-bend (gi-arc &optional (window *window*))
  (cond (*pan-flag*
	 (tv:with-notification-mode (:pop-up)
	   (tv:notify nil
		      "You must Disable Panning before you may move arc: ~A. "
		      (send gi-arc :arc-label))))
	(t
	 (setq *bend-flag* t)
	 ;; Erase current view of the arc.
	 (send gi-arc :draw-self window tv:alu-andca)
	 ;; Perform the bending.
	 (gi-arc-bend-driver gi-arc)
	 (send window :refresh)
	 (send window :display)
	 (send window :deselect))))


(defun gi-arc-bend-driver (gi-arc &optional (window *window*))
  (multiple-value-bind (window-left window-top) (send window :edges)
    (loop while *bend-flag*  do
      ;; Look for activity of any button and report mouse position.
      (multiple-value-bind (dumb1 dumb2 button-push button-rel mouse-x mouse-y)
	  (tv:mouse-input)
	(when (< 0 button-push)			; When button activity.
	  (setq *bend-flag* nil)		; Stop the bending.
	  (return t))
	;;Failed attempt at rubber-banding the bend procedure.
	(setf (send gi-arc :middle-point)
	      (list (+ (left *viewport-position*)
				   (- mouse-x window-left))
		    (+ (top *viewport-position*)
				   (- mouse-y window-top))))
	(setf (send gi-arc :bent) t)
	(send gi-arc :draw-moving-arc window)))))
















